/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.contents.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import org.jetbrains.annotations.NotNull;
import tictim.paraglider.bargain.preview.QuantifiedIngredient;
import tictim.paraglider.bargain.preview.QuantifiedItem;
import tictim.paraglider.contents.recipe.SimpleBargain;

public abstract class SimpleBargainSerializer<T extends SimpleBargain>
implements RecipeSerializer<T> {
    @NotNull
    public T fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
        ObjectOpenHashSet userTags;
        int essenceOffers;
        int staminaVesselOffers;
        int heartContainerOffers;
        List<QuantifiedItem> itemOffers;
        int essenceDemands;
        int staminaVesselDemands;
        int heartContainerDemands;
        List<QuantifiedIngredient> itemDemands;
        ResourceLocation bargainType = new ResourceLocation(json.has("bargainType") ? GsonHelper.m_13906_((JsonObject)json, (String)"bargainType") : (json.has("owner") ? GsonHelper.m_13906_((JsonObject)json, (String)"owner") : GsonHelper.m_13906_((JsonObject)json, (String)"bargainType")));
        JsonObject demands = GsonHelper.m_13841_((JsonObject)json, (String)"demands", null);
        if (demands != null) {
            JsonArray items = GsonHelper.m_13832_((JsonObject)demands, (String)"items", null);
            if (items == null || items.isEmpty()) {
                itemDemands = Collections.emptyList();
            } else {
                itemDemands = new ArrayList();
                for (JsonElement i : items) {
                    itemDemands.add(new QuantifiedIngredient(GsonHelper.m_13918_((JsonElement)i, (String)"item")));
                }
            }
            heartContainerDemands = Math.max(0, GsonHelper.m_13824_((JsonObject)demands, (String)"heartContainers", (int)0));
            staminaVesselDemands = Math.max(0, GsonHelper.m_13824_((JsonObject)demands, (String)"staminaVessels", (int)0));
            essenceDemands = Math.max(0, GsonHelper.m_13824_((JsonObject)demands, (String)"essences", (int)0));
        } else {
            itemDemands = Collections.emptyList();
            heartContainerDemands = 0;
            staminaVesselDemands = 0;
            essenceDemands = 0;
        }
        JsonObject offers = GsonHelper.m_13841_((JsonObject)json, (String)"offers", null);
        if (offers != null) {
            JsonArray items = GsonHelper.m_13832_((JsonObject)offers, (String)"items", null);
            if (items == null || items.isEmpty()) {
                itemOffers = Collections.emptyList();
            } else {
                itemOffers = new ArrayList();
                for (JsonElement i : items) {
                    ItemStack stack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13918_((JsonElement)i, (String)"item"));
                    itemOffers.add(new QuantifiedItem(stack.m_41720_(), stack.m_41613_()));
                }
            }
            heartContainerOffers = Math.max(0, GsonHelper.m_13824_((JsonObject)offers, (String)"heartContainers", (int)0));
            staminaVesselOffers = Math.max(0, GsonHelper.m_13824_((JsonObject)offers, (String)"staminaVessels", (int)0));
            essenceOffers = Math.max(0, GsonHelper.m_13824_((JsonObject)offers, (String)"essences", (int)0));
        } else {
            itemOffers = Collections.emptyList();
            heartContainerOffers = 0;
            staminaVesselOffers = 0;
            essenceOffers = 0;
        }
        JsonArray tags = GsonHelper.m_13832_((JsonObject)json, (String)"tags", null);
        if (tags != null) {
            userTags = new ObjectOpenHashSet();
            for (JsonElement tag : tags) {
                userTags.add(GsonHelper.m_13805_((JsonElement)tag, (String)"tag"));
            }
        } else {
            userTags = Collections.emptySet();
        }
        return this.instantiate(recipeId, json, bargainType, itemDemands, heartContainerDemands, staminaVesselDemands, essenceDemands, itemOffers, heartContainerOffers, staminaVesselOffers, essenceOffers, (Set<String>)userTags);
    }

    @NotNull
    protected abstract T instantiate(@NotNull ResourceLocation var1, @NotNull JsonObject var2, @NotNull ResourceLocation var3, @NotNull @NotNull List<@NotNull QuantifiedIngredient> var4, int var5, int var6, int var7, @NotNull @NotNull List<@NotNull QuantifiedItem> var8, int var9, int var10, int var11, @NotNull @NotNull Set<@NotNull String> var12);

    @NotNull
    public T fromNetwork(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
        ResourceLocation bargainType = buffer.m_130281_();
        ArrayList<QuantifiedIngredient> itemDemands = new ArrayList<QuantifiedIngredient>();
        int size = buffer.m_130242_();
        for (int i = 0; i < size; ++i) {
            itemDemands.add(QuantifiedIngredient.read(buffer));
        }
        int heartContainerDemands = buffer.m_130242_();
        int staminaVesselDemands = buffer.m_130242_();
        int essenceDemands = buffer.m_130242_();
        ArrayList<QuantifiedItem> itemOffers = new ArrayList<QuantifiedItem>();
        int size2 = buffer.m_130242_();
        for (int i = 0; i < size2; ++i) {
            itemOffers.add(QuantifiedItem.read(buffer));
        }
        int heartContainerOffers = buffer.m_130242_();
        int staminaVesselOffers = buffer.m_130242_();
        int essenceOffers = buffer.m_130242_();
        ObjectOpenHashSet userTags = new ObjectOpenHashSet();
        int size3 = buffer.m_130242_();
        for (int i = 0; i < size3; ++i) {
            userTags.add(buffer.m_130277_());
        }
        return this.instantiate(recipeId, buffer, bargainType, itemDemands, heartContainerDemands, staminaVesselDemands, essenceDemands, itemOffers, heartContainerOffers, staminaVesselOffers, essenceOffers, (Set<String>)userTags);
    }

    @NotNull
    protected abstract T instantiate(@NotNull ResourceLocation var1, @NotNull FriendlyByteBuf var2, @NotNull ResourceLocation var3, @NotNull @NotNull List<@NotNull QuantifiedIngredient> var4, int var5, int var6, int var7, @NotNull @NotNull List<@NotNull QuantifiedItem> var8, int var9, int var10, int var11, @NotNull @NotNull Set<@NotNull String> var12);

    public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull T recipe) {
        buffer.m_130085_(((SimpleBargain)recipe).getBargainType());
        List<QuantifiedIngredient> itemDemands = ((SimpleBargain)recipe).getItemDemands();
        buffer.m_130130_(itemDemands.size());
        for (QuantifiedIngredient quantifiedIngredient : itemDemands) {
            quantifiedIngredient.write(buffer);
        }
        buffer.m_130130_(((SimpleBargain)recipe).getHeartContainerDemands());
        buffer.m_130130_(((SimpleBargain)recipe).getStaminaVesselDemands());
        buffer.m_130130_(((SimpleBargain)recipe).getEssenceDemands());
        List<QuantifiedItem> itemOffers = ((SimpleBargain)recipe).getItemOffers();
        buffer.m_130130_(itemOffers.size());
        for (QuantifiedItem offer : itemOffers) {
            offer.write(buffer);
        }
        buffer.m_130130_(((SimpleBargain)recipe).getHeartContainerOffers());
        buffer.m_130130_(((SimpleBargain)recipe).getStaminaVesselOffers());
        buffer.m_130130_(((SimpleBargain)recipe).getEssenceOffers());
        Set<String> set = ((SimpleBargain)recipe).getUserTags();
        buffer.m_130130_(set.size());
        for (String userTag : set) {
            buffer.m_130070_(userTag);
        }
    }

    public static final class Simple
    extends SimpleBargainSerializer<SimpleBargain> {
        @Override
        @NotNull
        protected SimpleBargain instantiate(@NotNull ResourceLocation recipeId, @NotNull JsonObject json, @NotNull ResourceLocation bargainType, @NotNull @NotNull List<@NotNull QuantifiedIngredient> itemDemands, int heartContainerDemands, int staminaVesselDemands, int essenceDemands, @NotNull @NotNull List<@NotNull QuantifiedItem> itemOffers, int heartContainerOffers, int staminaVesselOffers, int essenceOffers, @NotNull @NotNull Set<@NotNull String> userTags) {
            return new SimpleBargain(recipeId, bargainType, itemDemands, heartContainerDemands, staminaVesselDemands, essenceDemands, itemOffers, heartContainerOffers, staminaVesselOffers, essenceOffers, userTags);
        }

        @Override
        @NotNull
        protected SimpleBargain instantiate(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer, @NotNull ResourceLocation bargainType, @NotNull @NotNull List<@NotNull QuantifiedIngredient> itemDemands, int heartContainerDemands, int staminaVesselDemands, int essenceDemands, @NotNull @NotNull List<@NotNull QuantifiedItem> itemOffers, int heartContainerOffers, int staminaVesselOffers, int essenceOffers, @NotNull @NotNull Set<@NotNull String> userTags) {
            return new SimpleBargain(recipeId, bargainType, itemDemands, heartContainerDemands, staminaVesselDemands, essenceDemands, itemOffers, heartContainerOffers, staminaVesselOffers, essenceOffers, userTags);
        }
    }
}

