/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.contents;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.function.Function;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import org.jetbrains.annotations.NotNull;
import tictim.paraglider.ParagliderMod;
import tictim.paraglider.config.FeatureCfg;

public final class ParagliderVillageStructures {
    private ParagliderVillageStructures() {
    }

    public static void addVillageStructures(@NotNull MinecraftServer server) {
        if (!FeatureCfg.get().enableStructures()) {
            return;
        }
        Registry reg = (Registry)server.m_206579_().m_6632_(Registries.f_256948_).orElseThrow();
        ParagliderMod.LOGGER.debug("Start adding village structures");
        ParagliderVillageStructures.appendPool((Registry<StructureTemplatePool>)reg, new ResourceLocation("village/desert/houses"), Pair.of((Object)StructurePoolElement.m_210507_((String)"paraglider:gerudo_village_goddess_statue"), (Object)1), Pair.of((Object)StructurePoolElement.m_210507_((String)"paraglider:desert_village_horned_statue"), (Object)1));
        ParagliderVillageStructures.appendPool((Registry<StructureTemplatePool>)reg, new ResourceLocation("village/plains/houses"), Pair.of((Object)StructurePoolElement.m_210507_((String)"paraglider:hateno_village_goddess_statue"), (Object)1), Pair.of((Object)StructurePoolElement.m_210507_((String)"paraglider:plains_village_horned_statue"), (Object)1));
        ParagliderVillageStructures.appendPool((Registry<StructureTemplatePool>)reg, new ResourceLocation("village/savanna/houses"), Pair.of((Object)StructurePoolElement.m_210507_((String)"paraglider:rito_village_goddess_statue"), (Object)3), Pair.of((Object)StructurePoolElement.m_210507_((String)"paraglider:savanna_village_horned_statue"), (Object)1));
        ParagliderVillageStructures.appendPool((Registry<StructureTemplatePool>)reg, new ResourceLocation("village/snowy/houses"), Pair.of((Object)StructurePoolElement.m_210507_((String)"paraglider:snowy_village_horned_statue"), (Object)1));
        ParagliderVillageStructures.appendPool((Registry<StructureTemplatePool>)reg, new ResourceLocation("village/taiga/houses"), Pair.of((Object)StructurePoolElement.m_210507_((String)"paraglider:kakariko_village_goddess_statue"), (Object)3), Pair.of((Object)StructurePoolElement.m_210507_((String)"paraglider:taiga_village_horned_statue"), (Object)1));
        ParagliderMod.LOGGER.debug("Finished adding village structures");
    }

    @SafeVarargs
    private static void appendPool(Registry<StructureTemplatePool> templatePoolRegistry, ResourceLocation id, Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer> ... elementToWeight) {
        StructureTemplatePool pool = (StructureTemplatePool)templatePoolRegistry.m_7745_(id);
        if (pool == null) {
            ParagliderMod.LOGGER.warn("Template pool '{}' doesn't exist", (Object)id);
            return;
        }
        if (elementToWeight.length == 0) {
            return;
        }
        ArrayList<Pair> newWeightedPool = new ArrayList<Pair>(pool.f_210559_.size() + elementToWeight.length);
        newWeightedPool.addAll(pool.f_210559_);
        for (Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer> p : elementToWeight) {
            newWeightedPool.add(Pair.of((Object)((StructurePoolElement)((Function)p.getFirst()).apply(StructureTemplatePool.Projection.RIGID)), (Object)((Integer)p.getSecond())));
        }
        pool.f_210559_ = newWeightedPool;
        pool.f_210560_.clear();
        for (Pair pair : pool.f_210559_) {
            StructurePoolElement structurepoolelement = (StructurePoolElement)pair.getFirst();
            for (int i = 0; i < (Integer)pair.getSecond(); ++i) {
                pool.f_210560_.add((Object)structurepoolelement);
            }
        }
        ParagliderMod.LOGGER.debug("Added {} elements to template pool '{}'", (Object)elementToWeight.length, (Object)id);
    }
}

