/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.cinderscapes.feature;

import com.terraformersmc.cinderscapes.init.CinderscapesBlocks;
import com.terraformersmc.terraform.shapes.api.Filler;
import com.terraformersmc.terraform.shapes.api.Position;
import com.terraformersmc.terraform.shapes.api.Quaternion;
import com.terraformersmc.terraform.shapes.api.Shape;
import com.terraformersmc.terraform.shapes.api.layer.Layer;
import com.terraformersmc.terraform.shapes.impl.Shapes;
import com.terraformersmc.terraform.shapes.impl.filler.SimpleFiller;
import com.terraformersmc.terraform.shapes.impl.layer.pathfinder.AddLayer;
import com.terraformersmc.terraform.shapes.impl.layer.transform.RotateLayer;
import com.terraformersmc.terraform.shapes.impl.layer.transform.TranslateLayer;
import com.terraformersmc.terraform.shapes.impl.validator.SafelistValidator;
import java.util.Arrays;
import net.minecraft.class_1922;
import net.minecraft.class_1945;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_265;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3746;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;

public class DeadTreeFeature
extends class_3031<class_3111> {
    public DeadTreeFeature() {
        super(class_3111.field_24893);
    }

    public boolean method_13151(class_5821<class_3111> context) {
        class_5819 random = context.method_33654();
        class_2338 pos = context.method_33655();
        class_5281 world = context.method_33652();
        if (world.method_8320(pos.method_10074()).method_26204() == CinderscapesBlocks.ASH) {
            pos = pos.method_10074();
        }
        if (!class_2248.method_9501((class_265)world.method_8320(pos.method_10074()).method_26220((class_1922)world, pos.method_10074()), (class_2350)class_2350.field_11036)) {
            return false;
        }
        if (world.method_8320(pos.method_10074()).method_26204() == class_2246.field_10092 || world.method_8320(pos.method_10074()).method_26204() == CinderscapesBlocks.SCORCHED_STEM) {
            return false;
        }
        int trunkHeight = random.method_43048(4) + 4;
        Shape trunkShape = DeadTreeFeature.verticalLine(trunkHeight, Quaternion.of((double)1.0, (double)0.0, (double)0.0, (double)0.0)).applyLayer((Layer)new TranslateLayer(Position.of((class_2338)pos)));
        Shape topperShape = DeadTreeFeature.recursiveTreeTopper(random, 2, 4, 15, 45, 2, 5, 3, 3).applyLayer((Layer)new TranslateLayer(Position.of((double)0.0, (double)trunkHeight, (double)0.0))).applyLayer((Layer)new TranslateLayer(Position.of((class_2338)pos)));
        SafelistValidator safelistValidator = new SafelistValidator((class_3746)world, Arrays.asList(class_2246.field_10124.method_9564(), CinderscapesBlocks.ASH.method_9564()));
        boolean trunkSafe = safelistValidator.validate(trunkShape);
        boolean topperSafe = safelistValidator.validate(topperShape);
        if (trunkSafe && topperSafe) {
            trunkShape.fill((Filler)new SimpleFiller((class_1945)world, CinderscapesBlocks.SCORCHED_STEM.method_9564()));
            topperShape.fill((Filler)new SimpleFiller((class_1945)world, CinderscapesBlocks.SCORCHED_HYPHAE.method_9564()));
            return true;
        }
        return false;
    }

    private static Shape recursiveTreeTopper(class_5819 random, int minLength, int maxLength, int minSpread, int maxSpread, int minChildren, int maxChildren, int totalRecursionLevel, int recursionCounter) {
        Shape shape = Shapes.rectanglarPrism((double)1.0, (double)1.0, (double)1.0);
        if (recursionCounter == 0) {
            return shape;
        }
        int children = random.method_43048(maxChildren - minChildren) + minChildren;
        for (int i = 0; i < children; ++i) {
            float recursionRatio = (float)recursionCounter / (float)totalRecursionLevel;
            int length = random.method_43048(maxLength - minLength) + minLength;
            shape = shape.applyLayer((Layer)new AddLayer(Shapes.rectanglarPrism((double)1.0, (double)length, (double)1.0).applyLayer((Layer)new TranslateLayer(Position.of((double)0.0, (double)((float)length / 2.0f), (double)0.0))).applyLayer((Layer)new AddLayer(DeadTreeFeature.recursiveTreeTopper(random, minLength, (int)((float)(maxLength - minLength) * recursionRatio) + minLength, (int)((float)minSpread * recursionRatio), (int)((float)maxSpread * recursionRatio), (int)((float)minChildren * recursionRatio), (int)((float)maxChildren * recursionRatio), totalRecursionLevel, recursionCounter - 1).applyLayer((Layer)new TranslateLayer(Position.of((double)0.0, (double)length, (double)0.0))))).applyLayer((Layer)new RotateLayer(Quaternion.of((double)0.0, (double)(random.method_43057() * 360.0f), (double)(random.method_43057() * (float)(maxSpread - minSpread) + (float)minSpread), (boolean)true)))));
        }
        return shape;
    }

    private static Shape verticalLine(int height, Quaternion rotation) {
        return Shape.of(pos -> true, (Position)Position.of((double)1.0, (double)height, (double)1.0), (Position)Position.of((double)0.0, (double)0.0, (double)0.0)).applyLayer((Layer)new RotateLayer(rotation));
    }
}

