/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.cinderscapes.feature;

import com.terraformersmc.cinderscapes.feature.config.CanopiedHugeFungusFeatureConfig;
import com.terraformersmc.terraform.shapes.api.Filler;
import com.terraformersmc.terraform.shapes.api.Position;
import com.terraformersmc.terraform.shapes.api.Shape;
import com.terraformersmc.terraform.shapes.api.layer.Layer;
import com.terraformersmc.terraform.shapes.impl.Shapes;
import com.terraformersmc.terraform.shapes.impl.filler.RandomSimpleFiller;
import com.terraformersmc.terraform.shapes.impl.filler.SimpleFiller;
import com.terraformersmc.terraform.shapes.impl.layer.pathfinder.AddLayer;
import com.terraformersmc.terraform.shapes.impl.layer.pathfinder.SubtractLayer;
import com.terraformersmc.terraform.shapes.impl.layer.transform.TranslateLayer;
import com.terraformersmc.terraform.shapes.impl.validator.AirValidator;
import com.terraformersmc.terraform.shapes.impl.validator.SafelistValidator;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.class_1922;
import net.minecraft.class_1945;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3031;
import net.minecraft.class_3746;
import net.minecraft.class_4771;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;

public class CanopiedHugeFungusFeature
extends class_3031<CanopiedHugeFungusFeatureConfig> {
    private static final Random localRandom = new Random();

    public CanopiedHugeFungusFeature() {
        super(CanopiedHugeFungusFeatureConfig.CODEC);
    }

    public boolean method_13151(class_5821<CanopiedHugeFungusFeatureConfig> context) {
        CanopiedHugeFungusFeatureConfig config = (CanopiedHugeFungusFeatureConfig)context.method_33656();
        class_5281 world = context.method_33652();
        class_2338 pos = context.method_33655();
        class_5819 random = context.method_33654();
        ArrayList<class_2680> baseSafeList = new ArrayList<class_2680>(List.of(config.soilBlock(), class_2246.field_10124.method_9564(), class_2246.field_10515.method_9564()));
        if (config.planted()) {
            if (world.method_8320(pos.method_10074()) != config.soilBlock()) {
                return false;
            }
            boolean solidGround = Shape.of(ipos -> true, (Position)Position.of((double)2.0, (double)0.0, (double)2.0), (Position)Position.of((double)-1.0, (double)-1.0, (double)-1.0)).applyLayer((Layer)TranslateLayer.of((Position)Position.of((class_2338)pos))).stream().map(Position::toBlockPos).allMatch(ipos -> !world.method_22347(ipos) && class_2248.method_9501((class_265)world.method_8320(ipos).method_26220((class_1922)world, pos.method_10074()), (class_2350)class_2350.field_11036));
            if (!solidGround) {
                return false;
            }
            class_2680 groundZero = world.method_8320(pos);
            if (groundZero.method_26204() instanceof class_4771) {
                baseSafeList.add(groundZero);
            }
        }
        int stemHeight = random.method_43048(20) + 6;
        Shape stem = Shapes.ellipticalPrism((double)1.4, (double)1.4, (double)(0.8 * (double)stemHeight)).applyLayer((Layer)new TranslateLayer(Position.of((double)0.0, (double)(0.6 * (double)(stemHeight - 1)), (double)0.0))).applyLayer((Layer)new TranslateLayer(Position.of((class_2338)pos)));
        Shape base = Shapes.rectanglarPrism((double)3.0, (double)(0.2 * (double)stemHeight), (double)3.0).applyLayer((Layer)new TranslateLayer(Position.of((double)0.0, (double)(0.1 * (double)(stemHeight - 1)), (double)0.0))).applyLayer((Layer)new TranslateLayer(Position.of((class_2338)pos)));
        int canopyRadius = random.method_43048(3) + 6;
        int canopyHeight = random.method_43048(5) + 5;
        Position canopyPos = Position.of((class_2338)pos.method_10086(stemHeight - canopyHeight + 2));
        Shape canopy = Shapes.hemiEllipsoid((double)canopyRadius, (double)canopyRadius, (double)canopyHeight).applyLayer((Layer)new SubtractLayer(Shapes.hemiEllipsoid((double)(canopyRadius - 1), (double)(canopyRadius - 1), (double)(canopyHeight - 1)))).applyLayer((Layer)new AddLayer(Shapes.ellipticalPrism((double)canopyRadius, (double)canopyRadius, (double)1.0).applyLayer((Layer)new SubtractLayer(Shapes.ellipticalPrism((double)(canopyRadius - 1), (double)(canopyRadius - 1), (double)1.0))))).applyLayer((Layer)new TranslateLayer(canopyPos));
        Shape flesh = Shapes.hemiEllipsoid((double)(canopyRadius - 1), (double)(canopyRadius - 1), (double)(canopyHeight - 1)).applyLayer((Layer)new SubtractLayer(Shapes.hemiEllipsoid((double)(canopyRadius - 2), (double)(canopyRadius - 2), (double)(canopyHeight - 2)))).applyLayer((Layer)new TranslateLayer(canopyPos));
        Shape detailBlocks = Shapes.hemiEllipsoid((double)(canopyRadius - 2), (double)(canopyRadius - 2), (double)(canopyHeight - 2)).applyLayer((Layer)new SubtractLayer(Shapes.hemiEllipsoid((double)(canopyRadius - 3), (double)(canopyRadius - 3), (double)(canopyHeight - 3)))).applyLayer((Layer)new TranslateLayer(canopyPos));
        Shape fleshDripping = Shapes.ellipticalPrism((double)(canopyRadius - 1), (double)(canopyRadius - 1), (double)1.0).applyLayer((Layer)new SubtractLayer(Shapes.ellipticalPrism((double)(canopyRadius - 2), (double)(canopyRadius - 2), (double)1.0))).applyLayer((Layer)new TranslateLayer(canopyPos));
        Shape canopyDripping = Shapes.ellipticalPrism((double)canopyRadius, (double)canopyRadius, (double)1.0).applyLayer((Layer)new SubtractLayer(Shapes.ellipticalPrism((double)(canopyRadius - 1), (double)(canopyRadius - 1), (double)1.0))).applyLayer((Layer)new TranslateLayer(Position.of((class_2338)canopyPos.toBlockPos().method_10074())));
        boolean baseClear = SafelistValidator.of((class_3746)world, baseSafeList).validate(base);
        boolean stemClear = AirValidator.of((class_3746)world).validate(stem);
        boolean canopyClear = Stream.of(canopy, flesh, detailBlocks, fleshDripping, canopyDripping).allMatch(shape -> AirValidator.of((class_3746)world).validate(shape));
        if (baseClear && stemClear && canopyClear) {
            canopy.fill((Filler)new SimpleFiller((class_1945)world, config.canopyBlock()));
            canopyDripping.fill((Filler)new RandomSimpleFiller((class_1945)world, config.canopyBlock(), localRandom, 0.5f));
            flesh.fill((Filler)new SimpleFiller((class_1945)world, config.fleshBlock()));
            fleshDripping.fill((Filler)new RandomSimpleFiller((class_1945)world, config.fleshBlock(), localRandom, 0.5f));
            detailBlocks.fill((Filler)new RandomSimpleFiller((class_1945)world, config.decorationBlock(), localRandom, 0.2f));
            stem.fill((Filler)new SimpleFiller((class_1945)world, config.stemBlock()));
            base.fill((Filler)new SimpleFiller((class_1945)world, config.hyphaeBlock()));
            if (!config.planted()) {
                this.makePlatform(world, config, pos);
            }
            return true;
        }
        return false;
    }

    private void makePlatform(class_5281 world, CanopiedHugeFungusFeatureConfig config, class_2338 origin) {
        for (class_2338 pos : Shapes.rectanglarPrism((double)3.0, (double)1.0, (double)3.0).applyLayer((Layer)new TranslateLayer(Position.of((class_2338)origin))).stream().map(Position::toBlockPos).toList()) {
            for (int i = 1; i < 5; ++i) {
                if (!world.method_8320(pos.method_10087(i)).method_26212((class_1922)world, pos.method_10087(i))) continue;
                while (i > 1) {
                    world.method_8652(pos.method_10087(i), class_2246.field_10515.method_9564(), 3);
                    --i;
                }
                break;
            }
            world.method_8652(pos.method_10074(), config.soilBlock(), 3);
        }
    }
}

