/*
 * Decompiled with CFR 0.152.
 */
package daripher.autoleveling.event;

import daripher.autoleveling.config.Config;
import daripher.autoleveling.data.DimensionsLevelingSettingsReloader;
import daripher.autoleveling.data.EntitiesLevelingSettingsReloader;
import daripher.autoleveling.init.AutoLevelingAttributes;
import daripher.autoleveling.mixin.LivingEntityAccessor;
import daripher.autoleveling.network.NetworkDispatcher;
import daripher.autoleveling.network.message.SyncLevelingData;
import daripher.autoleveling.saveddata.GlobalLevelingData;
import daripher.autoleveling.saveddata.WorldLevelingData;
import daripher.autoleveling.settings.DimensionLevelingSettings;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="autoleveling")
public class MobsLevelingEvents {
    private static final String LEVEL_TAG = "LEVEL";

    @SubscribeEvent
    public static void applyLevelBonuses(EntityJoinLevelEvent event) {
        if (!MobsLevelingEvents.shouldSetLevel(event.getEntity())) {
            return;
        }
        LivingEntity entity = (LivingEntity)event.getEntity();
        if (MobsLevelingEvents.hasLevel((Entity)entity)) {
            MobsLevelingEvents.applyAttributeBonuses(entity);
            return;
        }
        BlockPos spawnPos = MobsLevelingEvents.getSpawnPosition(entity);
        double distanceToSpawn = Math.sqrt(spawnPos.m_123331_((Vec3i)entity.m_20183_()));
        int level = MobsLevelingEvents.createLevelForEntity(entity, distanceToSpawn);
        MobsLevelingEvents.setLevel(entity, level);
        MobsLevelingEvents.applyAttributeBonuses(entity);
        MobsLevelingEvents.addEquipment(entity);
    }

    private static BlockPos getSpawnPosition(LivingEntity entity) {
        ResourceKey dimension = entity.m_9236_().m_46472_();
        DimensionLevelingSettings levelingSettings = DimensionsLevelingSettingsReloader.getSettingsForDimension((ResourceKey<Level>)dimension);
        return levelingSettings.spawnPosOverride().orElse(entity.m_9236_().m_220360_());
    }

    @SubscribeEvent
    public static void adjustExperienceDrop(LivingExperienceDropEvent event) {
        if (!MobsLevelingEvents.hasLevel((Entity)event.getEntity())) {
            return;
        }
        int level = MobsLevelingEvents.getLevel(event.getEntity()) + 1;
        int originalExp = event.getDroppedExperience();
        double expBonus = (Double)Config.COMMON.expBonus.get() * (double)level;
        event.setDroppedExperience((int)((double)originalExp + (double)originalExp * expBonus));
    }

    @SubscribeEvent
    public static void dropAdditionalLoot(LivingDropsEvent event) {
        LivingEntity entity = event.getEntity();
        if (!MobsLevelingEvents.hasLevel((Entity)entity)) {
            return;
        }
        ResourceLocation lootTableId = new ResourceLocation("autoleveling", "gameplay/leveled_mobs");
        MinecraftServer server = entity.m_9236_().m_7654_();
        if (server == null) {
            return;
        }
        LootTable lootTable = server.m_278653_().m_278676_(lootTableId);
        LootParams lootParams = MobsLevelingEvents.createLootParams(entity, event.getSource());
        lootTable.m_287228_(lootParams, arg_0 -> ((LivingEntity)entity).m_19983_(arg_0));
    }

    @SubscribeEvent
    public static void reloadSettings(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new DimensionsLevelingSettingsReloader());
        event.addListener((PreparableReloadListener)new EntitiesLevelingSettingsReloader());
    }

    @SubscribeEvent
    public static void syncEntityLevel(PlayerEvent.StartTracking event) {
        if (!MobsLevelingEvents.hasLevel(event.getTarget())) {
            return;
        }
        LivingEntity entity = (LivingEntity)event.getTarget();
        NetworkDispatcher.network_channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SyncLevelingData(entity));
    }

    @SubscribeEvent
    public static void applyAttributesDamageBonus(LivingHurtEvent event) {
        DamageSource damage = event.getSource();
        Entity entity = damage.m_7639_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)entity;
        float multiplier = MobsLevelingEvents.getDamageMultiplier(damage, attacker);
        if (multiplier > 1.0f) {
            event.setAmount(event.getAmount() * multiplier);
        }
    }

    public static float getDamageMultiplier(DamageSource damage, LivingEntity attacker) {
        if (damage.m_269533_(DamageTypeTags.f_268524_)) {
            return MobsLevelingEvents.getAttributeValue(attacker, (Attribute)AutoLevelingAttributes.PROJECTILE_DAMAGE_MULTIPLIER.get());
        }
        if (damage.m_269533_(DamageTypeTags.f_268415_)) {
            return MobsLevelingEvents.getAttributeValue(attacker, (Attribute)AutoLevelingAttributes.EXPLOSION_DAMAGE_MULTIPLIER.get());
        }
        return 1.0f;
    }

    private static float getAttributeValue(LivingEntity entity, Attribute damageBonusAttribute) {
        if (entity.m_21051_(damageBonusAttribute) == null) {
            return 0.0f;
        }
        return (float)Objects.requireNonNull(entity.m_21051_(damageBonusAttribute)).m_22135_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean shouldShowName(LivingEntity entity) {
        if (!Minecraft.m_91404_()) {
            return false;
        }
        if (entity.m_20160_()) {
            return false;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (entity == minecraft.m_91288_()) {
            return false;
        }
        LocalPlayer clientPlayer = minecraft.f_91074_;
        if (clientPlayer == null) {
            return false;
        }
        if (!clientPlayer.m_142582_((Entity)entity) || entity.m_20177_((Player)clientPlayer)) {
            return false;
        }
        if (!MobsLevelingEvents.hasLevel((Entity)entity)) {
            return false;
        }
        if (!MobsLevelingEvents.shouldShowLevel((Entity)entity)) {
            return false;
        }
        if (((Boolean)Config.COMMON.alwaysShowLevel.get()).booleanValue()) {
            return true;
        }
        return (Boolean)Config.COMMON.showLevelWhenLookingAt.get() != false && minecraft.f_91076_ == entity;
    }

    private static boolean shouldSetLevel(Entity entity) {
        if (entity.m_9236_().f_46443_) {
            return false;
        }
        return MobsLevelingEvents.canHaveLevel(entity);
    }

    private static int createLevelForEntity(LivingEntity entity, double distance) {
        int levelBonus;
        MinecraftServer server = entity.m_20194_();
        if (server == null) {
            return 0;
        }
        Record levelingSettings = EntitiesLevelingSettingsReloader.getSettingsForEntity(entity.m_6095_());
        if (levelingSettings == null) {
            ResourceKey dimension = entity.m_9236_().m_46472_();
            levelingSettings = DimensionsLevelingSettingsReloader.getSettingsForDimension((ResourceKey<Level>)dimension);
        }
        int monsterLevel = levelingSettings.startingLevel() - 1;
        int maxLevel = levelingSettings.maxLevel();
        monsterLevel += (int)((double)levelingSettings.levelsPerDistance() * distance);
        monsterLevel += (int)Math.pow(distance, distance * (double)levelingSettings.levelPowerPerDistance()) - 1;
        if (entity.m_20186_() < 64.0) {
            double deepness = 64.0 - entity.m_20186_();
            monsterLevel += (int)((double)levelingSettings.levelsPerDeepness() * deepness);
            monsterLevel += (int)Math.pow(deepness, deepness * (double)levelingSettings.levelPowerPerDeepness()) - 1;
        }
        if ((levelBonus = levelingSettings.randomLevelBonus() + 1) > 0) {
            monsterLevel += entity.m_217043_().m_188503_(levelBonus);
        }
        monsterLevel = Math.abs(monsterLevel);
        monsterLevel += WorldLevelingData.get((ServerLevel)entity.m_9236_()).getLevelBonus();
        if (maxLevel > 0) {
            monsterLevel = Math.min(monsterLevel, maxLevel - 1);
        }
        GlobalLevelingData globalLevelingData = GlobalLevelingData.get(server);
        return monsterLevel += globalLevelingData.getLevelBonus();
    }

    public static void applyAttributeBonuses(LivingEntity entity) {
        int level = MobsLevelingEvents.getLevel(entity);
        Config.getAttributeBonuses().forEach((attribute, bonus) -> MobsLevelingEvents.applyAttributeBonus(entity, attribute, bonus.floatValue() * (float)level));
    }

    private static void applyAttributeBonus(LivingEntity entity, Attribute attribute, double bonus) {
        AttributeInstance attributeInstance = entity.m_21051_(attribute);
        if (attributeInstance == null) {
            return;
        }
        UUID modifierId = UUID.fromString("6a102cb4-d735-4cb7-8ab2-3d383219a44e");
        AttributeModifier modifier = attributeInstance.m_22111_(modifierId);
        if (modifier != null && modifier.m_22218_() == bonus) {
            return;
        }
        if (modifier != null) {
            attributeInstance.m_22130_(modifier);
        }
        modifier = new AttributeModifier(modifierId, "Auto Leveling Bonus", bonus, AttributeModifier.Operation.MULTIPLY_TOTAL);
        attributeInstance.m_22125_(modifier);
        if (attribute == Attributes.f_22276_) {
            entity.m_5634_(entity.m_21233_());
        }
    }

    public static void addEquipment(LivingEntity entity) {
        MinecraftServer server = entity.m_9236_().m_7654_();
        if (server == null) {
            return;
        }
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            LootTable equipmentTable = MobsLevelingEvents.getEquipmentLootTableForSlot(server, entity, slot);
            if (equipmentTable == LootTable.f_79105_) continue;
            LootParams lootParams = MobsLevelingEvents.createEquipmentLootParams(entity);
            equipmentTable.m_287228_(lootParams, itemStack -> entity.m_8061_(slot, itemStack));
        }
    }

    private static LootTable getEquipmentLootTableForSlot(MinecraftServer server, LivingEntity entity, EquipmentSlot equipmentSlot) {
        ResourceLocation entityId = EntityType.m_20613_((EntityType)entity.m_6095_());
        ResourceLocation lootTableId = new ResourceLocation(entityId.m_135827_(), "equipment/" + entityId.m_135815_() + "_" + equipmentSlot.m_20751_());
        return server.m_278653_().m_278676_(lootTableId);
    }

    private static LootParams createLootParams(LivingEntity entity, DamageSource damageSource) {
        LivingEntityAccessor accessor = (LivingEntityAccessor)entity;
        ServerLevel level = (ServerLevel)entity.m_9236_();
        LootParams.Builder builder = new LootParams.Builder(level).m_287286_(LootContextParams.f_81455_, (Object)entity).m_287286_(LootContextParams.f_81460_, (Object)entity.m_20182_()).m_287286_(LootContextParams.f_81457_, (Object)damageSource).m_287289_(LootContextParams.f_81458_, (Object)damageSource.m_7639_()).m_287289_(LootContextParams.f_81459_, (Object)damageSource.m_7640_());
        int lastHurtByPlayerTime = accessor.getLastHurtByPlayerTime();
        Player lastHurtByPlayer = accessor.getLastHurtByPlayer();
        if (lastHurtByPlayerTime > 0 && lastHurtByPlayer != null) {
            builder = builder.m_287286_(LootContextParams.f_81456_, (Object)lastHurtByPlayer).m_287239_(lastHurtByPlayer.m_36336_());
        }
        return builder.m_287235_(LootContextParamSets.f_81415_);
    }

    private static LootParams createEquipmentLootParams(LivingEntity entity) {
        return new LootParams.Builder((ServerLevel)entity.m_9236_()).m_287286_(LootContextParams.f_81455_, (Object)entity).m_287286_(LootContextParams.f_81460_, (Object)entity.m_20182_()).m_287235_(LootContextParamSets.f_81413_);
    }

    private static boolean canHaveLevel(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        if (entity.m_6095_() == EntityType.f_20532_) {
            return false;
        }
        ResourceLocation entityId = EntityType.m_20613_((EntityType)entity.m_6095_());
        String entityNamespace = entityId.m_135827_();
        List blacklist = (List)Config.COMMON.blacklistedMobs.get();
        if (blacklist.contains(entityNamespace + ":*")) {
            return false;
        }
        List whitelist = (List)Config.COMMON.whitelistedMobs.get();
        if (whitelist.contains(entityNamespace + ":*")) {
            return true;
        }
        if (blacklist.contains(entityId.toString())) {
            return false;
        }
        if (!whitelist.isEmpty()) {
            return whitelist.contains(entityId.toString());
        }
        return true;
    }

    public static boolean shouldShowLevel(Entity entity) {
        ResourceLocation entityId = EntityType.m_20613_((EntityType)entity.m_6095_());
        List blacklist = (List)Config.COMMON.blacklistedShownLevels.get();
        if (blacklist.contains(entityId.toString())) {
            return false;
        }
        String namespace = entityId.m_135827_();
        return !blacklist.contains(namespace + ":*");
    }

    public static boolean hasLevel(Entity entity) {
        return entity.getPersistentData().m_128441_(LEVEL_TAG);
    }

    public static int getLevel(LivingEntity entity) {
        return entity.getPersistentData().m_128451_(LEVEL_TAG);
    }

    public static void setLevel(LivingEntity entity, int level) {
        entity.getPersistentData().m_128405_(LEVEL_TAG, level);
    }
}

