/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.biolith.impl.surface;

import com.terraformersmc.biolith.impl.Biolith;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.SurfaceRules;

public class SurfaceRuleCollector {
    public static final SurfaceRuleCollector END = new SurfaceRuleCollector();
    public static final SurfaceRuleCollector NETHER = new SurfaceRuleCollector();
    public static final SurfaceRuleCollector OVERWORLD = new SurfaceRuleCollector();
    private final HashMap<ResourceLocation, List<SurfaceRules.RuleSource>> MATERIAL_RULES = new HashMap(16);

    public void add(ResourceLocation ruleOwner, SurfaceRules.RuleSource ... materialRules) {
        if (materialRules.length > 0) {
            this.MATERIAL_RULES.computeIfAbsent(ruleOwner, ignored -> new ArrayList(4)).addAll(Arrays.stream(materialRules).toList());
        } else {
            Biolith.LOGGER.warn("Request to add empty surface rule set with ID of '{}'", (Object)ruleOwner);
        }
    }

    public SurfaceRules.RuleSource get(ResourceLocation ruleOwner) {
        if (this.MATERIAL_RULES.get(ruleOwner).size() > 1) {
            SurfaceRules.RuleSource[] rules = new SurfaceRules.RuleSource[]{};
            return SurfaceRules.m_198272_((SurfaceRules.RuleSource[])this.MATERIAL_RULES.get(ruleOwner).toArray(rules));
        }
        return this.MATERIAL_RULES.get(ruleOwner).get(0);
    }

    public SurfaceRules.RuleSource[] getAll() {
        SurfaceRules.RuleSource[] rulesType = new SurfaceRules.RuleSource[]{};
        return this.MATERIAL_RULES.keySet().stream().map(this::get).toList().toArray(rulesType);
    }

    public Set<ResourceLocation> getRuleOwners() {
        return this.MATERIAL_RULES.keySet();
    }

    public int getRuleCount() {
        return this.MATERIAL_RULES.size();
    }

    public int getRuleCount(ResourceLocation ruleOwner) {
        if (this.MATERIAL_RULES.containsKey(ruleOwner)) {
            return this.MATERIAL_RULES.get(ruleOwner).size();
        }
        return 0;
    }
}

