/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.biolith.impl.mixin;

import com.google.common.collect.Streams;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.terraformersmc.biolith.impl.Biolith;
import com.terraformersmc.biolith.impl.biome.BiolithFittestNodes;
import com.terraformersmc.biolith.impl.biome.BiomeCoordinator;
import com.terraformersmc.biolith.impl.biome.EndBiomePlacement;
import com.terraformersmc.biolith.impl.biome.VanillaEndBiomeParameters;
import java.util.ArrayList;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.QuartPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.TheEndBiomeSource;
import net.minecraft.world.level.levelgen.DensityFunction;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TheEndBiomeSource.class}, priority=900)
public abstract class MixinTheEndBiomeSource
extends BiomeSource {
    private static HolderGetter<Biome> biolith$biomeLookup;
    private static Climate.ParameterList<Holder<Biome>> biolith$biomeEntries;

    @Inject(method={"createVanilla"}, at={@At(value="HEAD")})
    private static void biolith$getRegistry(HolderGetter<Biome> biomeLookup, CallbackInfoReturnable<TheEndBiomeSource> cir) {
        biolith$biomeLookup = biomeLookup;
    }

    @ModifyReturnValue(method={"biomeStream"}, at={@At(value="RETURN")})
    private Stream<Holder<Biome>> biolith$biomeStream(Stream<Holder<Biome>> original) {
        if (Biolith.COMPAT_DATAGEN) {
            return original;
        }
        RegistryAccess.Frozen registryManager = BiomeCoordinator.getRegistryManager();
        ArrayList parameterList = new ArrayList(64);
        if (biolith$biomeLookup == null) {
            assert (registryManager != null);
            biolith$biomeLookup = registryManager.m_255025_(Registries.f_256952_);
        }
        VanillaEndBiomeParameters.writeEndBiomeParameters(parameterList::add);
        BiomeCoordinator.END.writeBiomeParameters(parameterList::add);
        if (biolith$biomeEntries == null) {
            biolith$biomeEntries = new Climate.ParameterList(parameterList.stream().map(pair -> pair.mapSecond(key -> biolith$biomeLookup.m_255043_(key))).toList());
        }
        return Streams.concat((Stream[])new Stream[]{original, parameterList.stream().map(pair -> biolith$biomeLookup.m_255043_((ResourceKey)pair.getSecond()))}).distinct();
    }

    @Inject(method={"getBiome"}, at={@At(value="RETURN")}, cancellable=true)
    private void biolith$getBiome(int x, int y, int z, Climate.Sampler noise, CallbackInfoReturnable<Holder<Biome>> cir) {
        BiolithFittestNodes fittestNodes;
        RegistryAccess.Frozen registryManager = BiomeCoordinator.getRegistryManager();
        Holder original = (Holder)cir.getReturnValue();
        EndBiomePlacement biomePlacement = (EndBiomePlacement)BiomeCoordinator.END;
        double erosion = noise.f_207848_().m_207386_((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext((SectionPos.m_123171_((int)QuartPos.m_175402_((int)x)) * 2 + 1) * 8, QuartPos.m_175402_((int)y), (SectionPos.m_123171_((int)QuartPos.m_175402_((int)z)) * 2 + 1) * 8));
        Climate.TargetPoint noisePoint = new Climate.TargetPoint(Climate.m_186779_((float)biomePlacement.temperatureNoise.sample((double)x / 576.0, (double)z / 576.0)), Climate.m_186779_((float)biomePlacement.humidityNoise.sample((double)x / 448.0, (double)z / 448.0)), original.m_203565_(Biomes.f_48210_) ? 0L : Climate.m_186779_((float)Mth.m_14036_((float)((float)erosion + 0.0625f), (float)-1.0f, (float)1.0f)), Climate.m_186779_((float)((float)erosion)), 156L * (long)(56 - y), Climate.m_186779_((float)biomePlacement.weirdnessNoise.sample((double)x / 192.0, (double)z / 192.0)));
        if (original.m_203565_(Biomes.f_48210_)) {
            Climate.RTree.Leaf ultimate = new Climate.RTree.Leaf(new Climate.ParameterPoint(Climate.Parameter.m_186820_((float)Climate.m_186796_((long)noisePoint.f_187003_())), Climate.Parameter.m_186820_((float)Climate.m_186796_((long)noisePoint.f_187004_())), Climate.Parameter.m_186820_((float)Climate.m_186796_((long)noisePoint.f_187005_())), Climate.Parameter.m_186820_((float)Climate.m_186796_((long)noisePoint.f_187006_())), Climate.Parameter.m_186820_((float)Climate.m_186796_((long)noisePoint.f_187007_())), Climate.Parameter.m_186820_((float)Climate.m_186796_((long)noisePoint.f_187008_())), 0L), (Object)original);
            fittestNodes = new BiolithFittestNodes(ultimate, 0L);
        } else {
            fittestNodes = MixinTheEndBiomeSource.biolith$biomeEntries.f_186847_.biolith$searchTreeGet(noisePoint, Climate.RTree.Node::m_186959_);
        }
        if (!original.equals(fittestNodes.ultimate().f_186948_) && (((Holder)fittestNodes.ultimate().f_186948_).m_203565_(Biomes.f_48162_) || ((Holder)fittestNodes.ultimate().f_186948_).m_203565_(Biomes.f_48165_) || ((Holder)fittestNodes.ultimate().f_186948_).m_203565_(Biomes.f_48163_) || ((Holder)fittestNodes.ultimate().f_186948_).m_203565_(Biomes.f_48164_))) {
            fittestNodes = new BiolithFittestNodes(new Climate.RTree.Leaf(MixinTheEndBiomeSource.biolith$createNoiseHypercube(fittestNodes.ultimate().f_186956_), (Object)original), 0L, fittestNodes.ultimate(), fittestNodes.ultimateDistance());
        }
        cir.setReturnValue(BiomeCoordinator.END.getReplacement(x, y, z, noisePoint, fittestNodes));
    }

    private static Climate.ParameterPoint biolith$createNoiseHypercube(Climate.Parameter ... parameters) {
        assert (parameters.length == 6);
        return Climate.m_186798_((Climate.Parameter)parameters[0], (Climate.Parameter)parameters[1], (Climate.Parameter)parameters[2], (Climate.Parameter)parameters[3], (Climate.Parameter)parameters[4], (Climate.Parameter)parameters[5], (float)0.0f);
    }
}

