/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.biolith.impl.mixin;

import com.terraformersmc.biolith.impl.Biolith;
import com.terraformersmc.biolith.impl.biome.BiolithFittestNodes;
import com.terraformersmc.biolith.impl.biome.InterfaceSearchTree;
import com.terraformersmc.biolith.impl.biome.SimpleArrayIterator;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Climate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={Climate.RTree.class})
public class MixinSearchTree<T>
implements InterfaceSearchTree<T> {
    @Shadow
    @Final
    private Climate.RTree.Node<T> f_186910_;
    private final ThreadLocal<Climate.RTree.Leaf<T>> previousUltimateNode = new ThreadLocal();
    private final ThreadLocal<Climate.RTree.Leaf<T>> previousPenultimateNode = new ThreadLocal();

    @Override
    public BiolithFittestNodes<T> biolith$searchTreeGet(Climate.TargetPoint point, Climate.DistanceMetric<T> distanceFunction) {
        Climate.RTree.SubTree branchNode;
        long penultimateDistance;
        long[] otherParameters = point.m_187016_();
        Climate.RTree.Node node = this.f_186910_;
        long nodeDistance = Long.MAX_VALUE;
        SimpleArrayIterator[] stack = new SimpleArrayIterator[16];
        int stackDepth = 0;
        Climate.RTree.Leaf ultimate = this.previousUltimateNode.get();
        Climate.RTree.Leaf penultimate = this.previousPenultimateNode.get();
        long ultimateDistance = ultimate != null ? distanceFunction.m_186809_(ultimate, otherParameters) : Long.MAX_VALUE;
        long l = penultimateDistance = penultimate != null ? distanceFunction.m_186809_(penultimate, otherParameters) : Long.MAX_VALUE;
        if (ultimateDistance > penultimateDistance) {
            Climate.RTree.Leaf temp = ultimate;
            ultimate = penultimate;
            penultimate = temp;
            long tempDistance = ultimateDistance;
            ultimateDistance = penultimateDistance;
            penultimateDistance = tempDistance;
        }
        if (node instanceof Climate.RTree.SubTree) {
            branchNode = (Climate.RTree.SubTree)node;
            stack[stackDepth] = new SimpleArrayIterator<Climate.RTree.Node>(branchNode.f_186965_);
        } else {
            if (node instanceof Climate.RTree.Leaf) {
                Climate.RTree.Leaf leafNode = (Climate.RTree.Leaf)node;
                return new BiolithFittestNodes(leafNode, distanceFunction.m_186809_((Climate.RTree.Node)leafNode, otherParameters));
            }
            Biolith.LOGGER.error("No biomes are available in MultiNoiseBiomeSource!");
            return new BiolithFittestNodes<T>(ultimate, ultimateDistance);
        }
        while (stack[stackDepth].hasNext()) {
            node = (Climate.RTree.Node)stack[stackDepth].next();
            nodeDistance = distanceFunction.m_186809_(node, otherParameters);
            while (node instanceof Climate.RTree.SubTree) {
                branchNode = (Climate.RTree.SubTree)node;
                if (penultimateDistance <= nodeDistance) break;
                stack[++stackDepth] = new SimpleArrayIterator<Climate.RTree.Node>(branchNode.f_186965_);
                node = (Climate.RTree.Node)stack[stackDepth].next();
                nodeDistance = distanceFunction.m_186809_(node, otherParameters);
            }
            if (node instanceof Climate.RTree.Leaf) {
                Climate.RTree.Leaf leafNode = (Climate.RTree.Leaf)node;
                if (penultimateDistance > nodeDistance) {
                    if (ultimateDistance > nodeDistance) {
                        if (!this.biolith$keyOf(leafNode).m_135782_().equals((Object)this.biolith$keyOf(ultimate).m_135782_())) {
                            penultimateDistance = ultimateDistance;
                            penultimate = ultimate;
                        }
                        ultimateDistance = nodeDistance;
                        ultimate = leafNode;
                    } else if (!this.biolith$keyOf(leafNode).m_135782_().equals((Object)this.biolith$keyOf(ultimate).m_135782_())) {
                        penultimateDistance = nodeDistance;
                        penultimate = leafNode;
                    }
                }
            }
            while (stackDepth > 0 && !stack[stackDepth].hasNext()) {
                --stackDepth;
            }
        }
        this.previousUltimateNode.set(ultimate);
        this.previousPenultimateNode.set(penultimate);
        if (penultimate == null) {
            return new BiolithFittestNodes<T>(ultimate, ultimateDistance);
        }
        return new BiolithFittestNodes<T>(ultimate, ultimateDistance, penultimate, penultimateDistance);
    }

    @NotNull
    private ResourceKey<?> biolith$keyOf(@Nullable Climate.RTree.Leaf<T> leafNode) {
        if (leafNode == null) {
            return ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)ResourceLocation.m_214293_((String)"biolith", (String)"null"));
        }
        return (ResourceKey)((Holder)leafNode.f_186948_).m_203543_().orElseThrow();
    }
}

