/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.biolith.impl.config;

import com.terraformersmc.biolith.impl.Biolith;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.saveddata.SavedData;

public class BiolithState
extends SavedData {
    private final LinkedHashMap<ResourceKey<Biome>, LinkedHashSet<ResourceKey<Biome>>> biomeReplacements = new LinkedHashMap(64);
    private final ServerLevel world;
    private final String stateId;
    private static final int STATE_VERSION = 0;

    public BiolithState(ServerLevel world) {
        this(world, world.m_220362_().m_135782_().m_135815_());
    }

    public BiolithState(ServerLevel serverWorld, String name) {
        this.world = serverWorld;
        this.stateId = "biolith_" + name + "_state";
        this.world.m_8895_().m_164855_(this.stateId, (SavedData)this);
        this.readState();
    }

    private void writeState() {
        this.m_77762_();
        this.world.m_8895_().m_78151_();
    }

    private void readState() {
        CompoundTag nbt = null;
        CompoundTag nbtState = null;
        try {
            nbt = this.world.m_8895_().m_78158_(this.stateId, 0);
        }
        catch (IOException e) {
            Biolith.LOGGER.debug("No saved state found for {}; starting anew...", (Object)this.stateId);
        }
        if (nbt != null && nbt.m_128441_("data")) {
            int nbtVersion = nbt.m_128451_("DataVersion");
            nbtState = nbt.m_128469_("data");
        }
        this.biomeReplacements.clear();
        if (nbtState != null && !nbtState.m_128456_()) {
            ListTag biomeReplacementsNbt = nbtState.m_128437_("BiomeReplacementsList", 9);
            biomeReplacementsNbt.forEach(nbtElement -> {
                ListTag replacementsNbt = (ListTag)nbtElement.m_6426_();
                ResourceLocation elementId = ResourceLocation.m_135820_((String)replacementsNbt.m_128778_(0));
                if (elementId == null) {
                    Biolith.LOGGER.warn("{}: Failed to parse target biome identifier from NBT: {}", (Object)this.stateId, (Object)replacementsNbt.m_128778_(0));
                } else if (replacementsNbt.size() < 2) {
                    Biolith.LOGGER.warn("{}: Replacements list from NBT contains no replacements: {}", (Object)this.stateId, (Object)replacementsNbt.m_128778_(0));
                } else {
                    ResourceKey target = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)elementId);
                    replacementsNbt.remove(0);
                    this.biomeReplacements.put((ResourceKey<Biome>)target, replacementsNbt.stream().map(element -> ResourceLocation.m_135820_((String)element.m_7916_())).filter(Objects::nonNull).map(id -> ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)id)).collect(Collectors.toCollection(LinkedHashSet::new)));
                    Biolith.LOGGER.debug("{}: Resolved replacements list from NBT: {} -> {}", new Object[]{this.stateId, target.m_135782_(), this.biomeReplacements.get(target).stream().map(ResourceKey::m_135782_).toList()});
                }
            });
        }
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        ListTag biomeReplacementsNbt = new ListTag();
        this.biomeReplacements.forEach((target, replacements) -> {
            ListTag replacementsNbt = new ListTag();
            replacementsNbt.add((Object)StringTag.m_129297_((String)target.m_135782_().toString()));
            replacementsNbt.addAll(replacements.stream().map(replacement -> StringTag.m_129297_((String)replacement.m_135782_().toString())).toList());
            biomeReplacementsNbt.add((Object)replacementsNbt);
        });
        Biolith.LOGGER.debug("{}: Describing biome replacemnts NBT:\n{}", (Object)this.stateId, (Object)biomeReplacementsNbt);
        nbt.m_128365_("BiomeReplacementsList", (Tag)biomeReplacementsNbt);
        return nbt;
    }

    public Stream<ResourceKey<Biome>> getBiomeReplacements(ResourceKey<Biome> target) {
        if (this.biomeReplacements.containsKey(target)) {
            return this.biomeReplacements.get(target).stream();
        }
        return Stream.empty();
    }

    public void addBiomeReplacements(ResourceKey<Biome> target, Stream<ResourceKey<Biome>> replacements) {
        if (this.biomeReplacements.containsKey(target)) {
            replacements.forEachOrdered(this.biomeReplacements.get(target)::add);
        } else {
            this.biomeReplacements.put(target, replacements.collect(Collectors.toCollection(LinkedHashSet::new)));
        }
        this.m_77762_();
    }
}

