/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.biolith.impl.biomeperimeters;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.terraformersmc.biolith.api.biomeperimeters.BiomePerimeters;
import com.terraformersmc.biolith.impl.Biolith;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntMaps;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import it.unimi.dsi.fastutil.ints.Int2ReferenceMaps;
import it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Hashtable;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction8;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BiomePerimetersImpl
implements BiomePerimeters {
    private static final Hashtable<Biome, BiomePerimetersImpl> instances = new Hashtable(4);
    private final Biome biome;
    private final int cardinalHorizon;
    private final int ordinalHorizon;
    private final int checkDistance;
    public static final int MAX_HORIZON = 256;
    private static final long COMPACTION_TIMER_TICKS = 300L;
    private final LoadingCache<ChunkPos, CacheRecord> caches = CacheBuilder.newBuilder().maximumSize(4096L).expireAfterAccess(30L, TimeUnit.SECONDS).weakValues().build((CacheLoader)new CacheLoader<ChunkPos, CacheRecord>(){

        @NotNull
        public CacheRecord load(@NotNull ChunkPos key) {
            return new CacheRecord();
        }
    });
    private static final int MAX_THREAD_LOCAL_CACHE_SIZE = 128;
    private final ThreadLocal<Object2ObjectLinkedOpenHashMap<ChunkPos, CacheRecord>> threadLocalCaches = ThreadLocal.withInitial(Object2ObjectLinkedOpenHashMap::new);

    private CacheRecord getCache(Object2ObjectLinkedOpenHashMap<ChunkPos, CacheRecord> threadLocal, ChunkPos pos) {
        CacheRecord cached = (CacheRecord)threadLocal.getAndMoveToFirst((Object)pos);
        if (cached != null) {
            return cached;
        }
        CacheRecord newOne = (CacheRecord)this.caches.getUnchecked((Object)pos);
        threadLocal.putAndMoveToFirst((Object)pos, (Object)newOne);
        if (threadLocal.size() > 128) {
            threadLocal.removeLast();
        }
        return newOne;
    }

    BiomePerimetersImpl(Biome biome) {
        this(biome, 64);
    }

    BiomePerimetersImpl(Biome biome, int horizon) {
        if (horizon < 1 || horizon > 256) {
            Biolith.LOGGER.debug("BiomePerimetersImpl horizon must be in the range [1,{}]: {}", (Object)256, (Object)horizon);
            horizon = 256;
        }
        this.biome = biome;
        this.cardinalHorizon = horizon;
        this.ordinalHorizon = (int)((double)horizon / Math.sqrt(2.0));
        this.checkDistance = (int)((float)horizon * 0.89f);
    }

    @Override
    public int getPerimeterDistance(BiomeManager biomeAccess, BlockPos pos) {
        int cached;
        float minimum = this.cardinalHorizon + 1;
        Object2ObjectLinkedOpenHashMap<ChunkPos, CacheRecord> threadLocalCache = this.threadLocalCaches.get();
        for (Direction8 direction : Direction8.values()) {
            if (this.checkBiome(biomeAccess, pos.m_7918_(direction.m_235697_(), 0, direction.m_235698_()), threadLocalCache)) continue;
            return 0;
        }
        CacheRecord cache = this.getCache(threadLocalCache, new ChunkPos(pos));
        int idx = CacheRecord.getIndex(pos);
        if (cache.biomeCache.containsKey(idx) && (cached = cache.biomeCache.get(idx)) > 0) {
            return cached;
        }
        block1: for (Direction8 direction : Direction8.values()) {
            int horizon = direction.ordinal() % 2 == 0 ? this.cardinalHorizon : this.ordinalHorizon;
            int dx = direction.m_235697_();
            int dz = direction.m_235698_();
            block2: for (int radius = 0; radius < horizon; ++radius) {
                BlockPos iterPos = pos.m_7918_(dx * radius, 0, dz * radius);
                CacheRecord cache2 = this.getCache(threadLocalCache, new ChunkPos(iterPos));
                if (!cache2.perimeters.containsKey(CacheRecord.getIndex(iterPos)) && this.checkBiome(biomeAccess, iterPos.m_7918_(dx, 0, dz), threadLocalCache)) continue;
                int localMinimum = this.checkPerimeter(biomeAccess, pos, iterPos, direction, threadLocalCache);
                if (localMinimum >= 0) {
                    minimum = Math.min(minimum, (float)localMinimum);
                    continue block1;
                }
                ++radius;
                while (radius < horizon) {
                    if (this.checkBiome(biomeAccess, pos.m_7918_(dx * radius, 0, dz * radius), threadLocalCache)) {
                        ++radius;
                        continue block2;
                    }
                    ++radius;
                }
            }
        }
        return this.rationalizeDistance(pos, minimum, threadLocalCache);
    }

    private int checkPerimeter(BiomeManager biomeAccess, BlockPos centerPos, BlockPos perimeterPos, Direction8 direction, Object2ObjectLinkedOpenHashMap<ChunkPos, CacheRecord> threadLocalCache) {
        BiomePerimeterPoint prospectPoint;
        BlockPos prospect;
        int rotation;
        int check;
        CacheRecord perimeterPosCache = this.getCache(threadLocalCache, new ChunkPos(perimeterPos));
        int perimeterPosIndex = CacheRecord.getIndex(perimeterPos);
        BiomePerimeterPoint current = (BiomePerimeterPoint)perimeterPosCache.perimeters.computeIfAbsent(perimeterPosIndex, k -> BiomePerimeterPoint.of(perimeterPos));
        double minimum = current.getDistance(centerPos);
        int localCheckDistance = Math.min(this.checkDistance, (int)(minimum * minimum) - 1);
        Direction8 orientation = direction;
        for (check = 0; check < localCheckDistance; ++check) {
            if (current.left != null) {
                orientation = this.getEightWayRelation(current.left.pos, current.pos);
            } else {
                orientation = this.getEightWayClockwiseRotation(orientation, 5);
                for (rotation = 2; rotation < 8; ++rotation) {
                    if (this.checkBiome(biomeAccess, current.pos.m_7918_((orientation = this.getEightWayClockwiseRotation(orientation, 1)).m_235697_(), 0, orientation.m_235698_()), threadLocalCache)) continue;
                    prospect = current.pos.m_7918_((orientation = this.getEightWayClockwiseRotation(orientation, -1)).m_235697_(), 0, orientation.m_235698_());
                    prospectPoint = (BiomePerimeterPoint)this.getCache(threadLocalCache, (ChunkPos)new ChunkPos((BlockPos)prospect)).perimeters.get(CacheRecord.getIndex(prospect));
                    if (prospectPoint != null) {
                        prospectPoint.setRight(current);
                        current.setLeft(prospectPoint);
                        break;
                    }
                    current.setLeft(BiomePerimeterPoint.leftOf(prospect, current));
                    this.getCache(threadLocalCache, (ChunkPos)new ChunkPos((BlockPos)current.left.pos)).perimeters.put(CacheRecord.getIndex(current.left.pos), (Object)current.left);
                    break;
                }
            }
            if (current.left == null) break;
            if (perimeterPos.compareTo((Vec3i)current.left.pos) == 0) {
                if (check < 16) {
                    return -1;
                }
                return (int)minimum;
            }
            current = current.left;
            minimum = Math.min(minimum, current.getDistance(centerPos));
        }
        current = (BiomePerimeterPoint)perimeterPosCache.perimeters.get(perimeterPosIndex);
        orientation = direction;
        for (check = 0; check < localCheckDistance; ++check) {
            if (current.right != null) {
                orientation = this.getEightWayRelation(current.right.pos, current.pos);
            } else {
                orientation = this.getEightWayClockwiseRotation(orientation, 3);
                for (rotation = 2; rotation < 8; ++rotation) {
                    if (this.checkBiome(biomeAccess, current.pos.m_7918_((orientation = this.getEightWayClockwiseRotation(orientation, -1)).m_235697_(), 0, orientation.m_235698_()), threadLocalCache)) continue;
                    prospect = current.pos.m_7918_((orientation = this.getEightWayClockwiseRotation(orientation, 1)).m_235697_(), 0, orientation.m_235698_());
                    prospectPoint = (BiomePerimeterPoint)this.getCache(threadLocalCache, (ChunkPos)new ChunkPos((BlockPos)prospect)).perimeters.get(CacheRecord.getIndex(prospect));
                    if (prospectPoint != null) {
                        if (current.equals(prospectPoint.right)) {
                            prospectPoint.right = null;
                        } else {
                            prospectPoint.setLeft(current);
                        }
                        current.setRight(prospectPoint);
                        break;
                    }
                    current.setRight(BiomePerimeterPoint.rightOf(prospect, current));
                    this.getCache(threadLocalCache, (ChunkPos)new ChunkPos((BlockPos)current.right.pos)).perimeters.put(CacheRecord.getIndex(current.right.pos), (Object)current.right);
                    break;
                }
            }
            if (current.right == null || perimeterPos.compareTo((Vec3i)current.right.pos) == 0) break;
            current = current.right;
            minimum = Math.min(minimum, current.getDistance(centerPos));
        }
        return (int)minimum;
    }

    private Direction8 getEightWayClockwiseRotation(Direction8 direction, int increment) {
        assert (increment >= -8);
        return Direction8.values()[(direction.ordinal() + increment + 8) % 8];
    }

    private Direction8 getEightWayRelation(BlockPos posA, BlockPos posB) {
        BlockPos diff = posA.m_121996_((Vec3i)posB);
        if (diff.m_123341_() < 0) {
            if (diff.m_123343_() < 0) {
                return Direction8.NORTH_WEST;
            }
            if (diff.m_123343_() > 0) {
                return Direction8.SOUTH_WEST;
            }
            return Direction8.WEST;
        }
        if (diff.m_123341_() > 0) {
            if (diff.m_123343_() < 0) {
                return Direction8.NORTH_EAST;
            }
            if (diff.m_123343_() > 0) {
                return Direction8.SOUTH_EAST;
            }
            return Direction8.EAST;
        }
        return diff.m_123343_() < 0 ? Direction8.NORTH : Direction8.SOUTH;
    }

    private boolean checkBiome(BiomeManager biomeAccess, BlockPos pos, Object2ObjectLinkedOpenHashMap<ChunkPos, CacheRecord> threadLocalCache) {
        return this.getCache(threadLocalCache, (ChunkPos)new ChunkPos((BlockPos)pos)).biomeCache.computeIfAbsent(CacheRecord.getIndex(pos), key -> ((Biome)biomeAccess.m_204214_(pos).m_203334_()).equals(this.biome) ? -1 : 0) != 0;
    }

    private int rationalizeDistance(BlockPos pos, float proposed, Object2ObjectLinkedOpenHashMap<ChunkPos, CacheRecord> threadLocalCache) {
        float lower = 0.0f;
        float upper = 256.0f;
        for (Direction8 direction : Direction8.values()) {
            BlockPos neighborPos = pos.m_7918_(direction.m_235697_(), 0, direction.m_235698_());
            int neighbor = this.getCache(threadLocalCache, (ChunkPos)new ChunkPos((BlockPos)neighborPos)).biomeCache.getOrDefault(CacheRecord.getIndex(neighborPos), -1);
            if (neighbor <= 0) continue;
            upper = Math.min(upper, (float)neighbor + 2.72f);
        }
        int distance = Math.round(Mth.m_14036_((float)proposed, (float)lower, (float)upper));
        this.getCache(threadLocalCache, (ChunkPos)new ChunkPos((BlockPos)pos)).biomeCache.put(CacheRecord.getIndex(pos), distance);
        return distance;
    }

    @NotNull
    public static synchronized BiomePerimetersImpl getOrCreateInstance(@NotNull Biome biome, int horizon) {
        return instances.computeIfAbsent(biome, key -> new BiomePerimetersImpl((Biome)key, horizon));
    }

    private static final class CacheRecord {
        private final Int2ReferenceMap<BiomePerimeterPoint> perimeters = Int2ReferenceMaps.synchronize((Int2ReferenceMap)new Int2ReferenceOpenHashMap(1024), (Object)this);
        private final Int2IntMap biomeCache = Int2IntMaps.synchronize((Int2IntMap)new Int2IntOpenHashMap(1024), (Object)this);

        private CacheRecord() {
        }

        public void clear() {
            this.perimeters.clear();
            this.biomeCache.clear();
        }

        public static int getIndex(int x, int y, int z) {
            return x & 0xF | (z & 0xF) << 4 | (short)y << 8;
        }

        public static int getIndex(BlockPos pos) {
            return CacheRecord.getIndex(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        }
    }

    public static final class BiomePerimeterPoint
    implements Cloneable {
        final BlockPos pos;
        BiomePerimeterPoint left;
        BiomePerimeterPoint right;

        public BiomePerimeterPoint(@NotNull BlockPos pos, @Nullable BiomePerimeterPoint left, @Nullable BiomePerimeterPoint right) {
            this.pos = pos.m_7949_();
            this.left = left;
            this.right = right;
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        public static BiomePerimeterPoint of(@NotNull BlockPos pos) {
            return new BiomePerimeterPoint(pos, null, null);
        }

        public static BiomePerimeterPoint rightOf(@NotNull BlockPos pos, BiomePerimeterPoint left) {
            return new BiomePerimeterPoint(pos, left, null);
        }

        public static BiomePerimeterPoint leftOf(@NotNull BlockPos pos, BiomePerimeterPoint right) {
            return new BiomePerimeterPoint(pos, null, right);
        }

        public static BiomePerimeterPoint of(@NotNull BlockPos pos, BiomePerimeterPoint left, BiomePerimeterPoint right) {
            return new BiomePerimeterPoint(pos, left, right);
        }

        public void setLeft(@NotNull BiomePerimeterPoint left) {
            assert (this.left == null);
            this.left = left;
        }

        public void setRight(@NotNull BiomePerimeterPoint right) {
            assert (this.right == null);
            this.right = right;
        }

        @NotNull
        public BlockPos getPos() {
            return this.pos.m_122032_();
        }

        @Nullable
        public BiomePerimeterPoint getLeft() {
            try {
                return (BiomePerimeterPoint)this.left.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        @Nullable
        public BiomePerimeterPoint getRight() {
            try {
                return (BiomePerimeterPoint)this.right.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        public double getDistance(@NotNull BlockPos pos) {
            return Math.sqrt(this.pos.m_123331_((Vec3i)pos));
        }

        public int getTaxicab(@NotNull Vec3i pos) {
            return this.pos.m_123333_(pos);
        }
    }
}

