/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.biolith.impl.biome;

import com.terraformersmc.biolith.api.biome.SubBiomeMatcher;
import com.terraformersmc.biolith.impl.biome.BiolithFittestNodes;
import com.terraformersmc.biolith.impl.biome.DimensionBiomePlacement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2fc;

public class SubBiomeMatcherImpl
extends SubBiomeMatcher {
    private final List<SubBiomeMatcher.Criterion> criteria = new ArrayList<SubBiomeMatcher.Criterion>(8);

    SubBiomeMatcherImpl() {
    }

    public static SubBiomeMatcherImpl of(SubBiomeMatcher.Criterion ... criteria) {
        SubBiomeMatcherImpl matcher = new SubBiomeMatcherImpl();
        for (SubBiomeMatcher.Criterion criterion : criteria) {
            matcher.addCriterion(criterion);
        }
        return matcher;
    }

    @Override
    public SubBiomeMatcherImpl addCriterion(SubBiomeMatcher.Criterion criterion) {
        if (!this.criteria.contains(criterion)) {
            this.criteria.add(criterion);
        }
        return this;
    }

    @Override
    public void sort() {
        this.criteria.sort(Comparator.comparingInt(criterion -> criterion.target().ordinal()));
    }

    @Override
    public boolean matches(BiolithFittestNodes<Holder<Biome>> fittestNodes, DimensionBiomePlacement biomePlacement, Climate.TargetPoint noisePoint, @Nullable Vector2fc replacementRange, float replacementNoise) {
        Climate.Parameter[] parameters = fittestNodes.ultimate().f_186956_;
        for (SubBiomeMatcher.Criterion criterion : this.criteria) {
            switch (criterion.target()) {
                case ALTERNATE: {
                    if (!criterion.checkBiome(SubBiomeMatcher.CriterionTargets.ALTERNATE, fittestNodes, biomePlacement, replacementNoise)) break;
                    return false;
                }
                case CENTER: {
                    if (!criterion.checkReplacement(SubBiomeMatcher.CriterionTargets.CENTER, fittestNodes, noisePoint, replacementRange, replacementNoise)) break;
                    return false;
                }
                case EDGE: {
                    if (!criterion.checkReplacement(SubBiomeMatcher.CriterionTargets.EDGE, fittestNodes, noisePoint, replacementRange, replacementNoise)) break;
                    return false;
                }
                case NEIGHBOR: {
                    if (!criterion.checkBiome(SubBiomeMatcher.CriterionTargets.NEIGHBOR, fittestNodes, biomePlacement, replacementNoise)) break;
                    return false;
                }
                case CONTINENTALNESS: {
                    if (!criterion.checkRange(criterion.type(), parameters[SubBiomeMatcher.ParameterListIndex.CONTINENTALNESS.ordinal()], noisePoint.f_187005_())) break;
                    return false;
                }
                case DEPTH: {
                    if (!criterion.checkRange(criterion.type(), parameters[SubBiomeMatcher.ParameterListIndex.DEPTH.ordinal()], noisePoint.f_187007_())) break;
                    return false;
                }
                case EROSION: {
                    if (!criterion.checkRange(criterion.type(), parameters[SubBiomeMatcher.ParameterListIndex.EROSION.ordinal()], noisePoint.f_187006_())) break;
                    return false;
                }
                case HUMIDITY: {
                    if (!criterion.checkRange(criterion.type(), parameters[SubBiomeMatcher.ParameterListIndex.HUMIDITY.ordinal()], noisePoint.f_187004_())) break;
                    return false;
                }
                case ORIGINAL: {
                    if (!criterion.checkBiome(SubBiomeMatcher.CriterionTargets.ORIGINAL, fittestNodes, biomePlacement, replacementNoise)) break;
                    return false;
                }
                case PEAKS_VALLEYS: {
                    long weirdnessMin = parameters[SubBiomeMatcher.ParameterListIndex.WEIRDNESS.ordinal()].f_186813_();
                    long weirdnessMax = parameters[SubBiomeMatcher.ParameterListIndex.WEIRDNESS.ordinal()].f_186814_();
                    long point1 = SubBiomeMatcherImpl.pvFromWeirdness(weirdnessMin);
                    long point2 = SubBiomeMatcherImpl.pvFromWeirdness(weirdnessMax);
                    long pvMin = (float)weirdnessMin < 0.0f && (float)weirdnessMax > 0.0f ? -10000L : Math.min(point1, point2);
                    long pvMax = (float)weirdnessMin < -6666.6665f && (float)weirdnessMax > -6666.6665f || (float)weirdnessMin < 6666.6665f && (float)weirdnessMax > 6666.6665f ? 10000L : Math.max(point1, point2);
                    Climate.Parameter pvRange = new Climate.Parameter(pvMin, pvMax);
                    if (!criterion.checkRange(criterion.type(), pvRange, SubBiomeMatcherImpl.pvFromWeirdness(noisePoint.f_187008_()))) break;
                    return false;
                }
                case TEMPERATURE: {
                    if (!criterion.checkRange(criterion.type(), parameters[SubBiomeMatcher.ParameterListIndex.TEMPERATURE.ordinal()], noisePoint.f_187003_())) break;
                    return false;
                }
                case WEIRDNESS: {
                    if (!criterion.checkRange(criterion.type(), parameters[SubBiomeMatcher.ParameterListIndex.WEIRDNESS.ordinal()], noisePoint.f_187008_())) break;
                    return false;
                }
            }
        }
        return true;
    }

    protected static long pvFromWeirdness(long weirdness) {
        return 10000L - Math.abs(Math.abs(weirdness * 3L) - 20000L);
    }

    public record Criterion(SubBiomeMatcher.CriterionTargets target, SubBiomeMatcher.CriterionTypes type, ResourceKey<Biome> biome, ResourceKey<Biome> secondary, TagKey<Biome> biomeTag, float min, float max, boolean invert) implements SubBiomeMatcher.Criterion
    {
        public Criterion {
            switch (type) {
                case BIOME: {
                    if (target == SubBiomeMatcher.CriterionTargets.ALTERNATE || target == SubBiomeMatcher.CriterionTargets.NEIGHBOR || target == SubBiomeMatcher.CriterionTargets.ORIGINAL) break;
                    throw new IllegalArgumentException("Criterion type BIOME must have targets ALTERNATE, NEIGHBOR, or ORIGINAL.");
                }
                case RATIO: {
                    if (target == SubBiomeMatcher.CriterionTargets.CENTER || target == SubBiomeMatcher.CriterionTargets.EDGE) break;
                    throw new IllegalArgumentException("Criterion type RATIO must have targets CENTER or EDGE.");
                }
                case DISTANCE: 
                case VALUE: {
                    if (target != SubBiomeMatcher.CriterionTargets.CENTER && target != SubBiomeMatcher.CriterionTargets.EDGE && target != SubBiomeMatcher.CriterionTargets.NEIGHBOR && target != SubBiomeMatcher.CriterionTargets.ORIGINAL) break;
                    throw new IllegalArgumentException("Criterion types DISTANCE and VALUE cannot have targets ALTERNATE, CENTER, EDGE, NEIGHBOR, or ORIGINAL.");
                }
            }
        }

        public static Criterion ofRange(SubBiomeMatcher.CriterionTargets target, SubBiomeMatcher.CriterionTypes type, float min, float max, boolean invert) {
            return new Criterion(target, type, null, null, null, min, max, invert);
        }

        public static Criterion ofMin(SubBiomeMatcher.CriterionTargets target, SubBiomeMatcher.CriterionTypes type, float min) {
            return new Criterion(target, type, null, null, null, min, Float.MAX_VALUE, false);
        }

        public static Criterion ofMax(SubBiomeMatcher.CriterionTargets target, SubBiomeMatcher.CriterionTypes type, float max) {
            return new Criterion(target, type, null, null, null, Float.MIN_VALUE, max, false);
        }

        public static Criterion ofBiome(SubBiomeMatcher.CriterionTargets target, ResourceKey<Biome> biome, boolean invert) {
            return new Criterion(target, SubBiomeMatcher.CriterionTypes.BIOME, biome, null, null, Float.MIN_VALUE, Float.MAX_VALUE, invert);
        }

        public static Criterion ofBiome(SubBiomeMatcher.CriterionTargets target, TagKey<Biome> biomeTag, boolean invert) {
            return new Criterion(target, SubBiomeMatcher.CriterionTypes.BIOME, null, null, biomeTag, Float.MIN_VALUE, Float.MAX_VALUE, invert);
        }

        public static Criterion ofAlternate(SubBiomeMatcher.CriterionTargets target, ResourceKey<Biome> biome, ResourceKey<Biome> alternateBiome, boolean invert) {
            return new Criterion(target, SubBiomeMatcher.CriterionTypes.BIOME, biome, alternateBiome, null, Float.MIN_VALUE, Float.MAX_VALUE, invert);
        }

        @Override
        public boolean checkBiome(SubBiomeMatcher.CriterionTargets target, BiolithFittestNodes<Holder<Biome>> fittestNodes, DimensionBiomePlacement biomePlacement, float replacementNoise) {
            Holder<Biome> comparable = null;
            if (target == SubBiomeMatcher.CriterionTargets.ORIGINAL) {
                comparable = (Holder<Biome>)fittestNodes.ultimate().f_186948_;
            } else if (target == SubBiomeMatcher.CriterionTargets.NEIGHBOR) {
                if (fittestNodes.penultimate() != null) {
                    comparable = (Holder)fittestNodes.penultimate().f_186948_;
                }
            } else if (target == SubBiomeMatcher.CriterionTargets.ALTERNATE) {
                DimensionBiomePlacement.ReplacementRequestSet requests = biomePlacement.replacementRequests.get(this.secondary);
                DimensionBiomePlacement.ReplacementRequest request = null;
                if (requests != null) {
                    request = requests.selectReplacement(replacementNoise);
                }
                if (request == null || request.biome().equals(DimensionBiomePlacement.VANILLA_PLACEHOLDER)) {
                    return this.invert == (this.biome != null && this.biome.equals(this.secondary));
                }
                comparable = request.biomeEntry();
            }
            return this.invert == (comparable != null && (this.biome != null && comparable.m_203565_(this.biome) || this.biomeTag != null && comparable.m_203656_(this.biomeTag)));
        }

        @Override
        public boolean checkRange(SubBiomeMatcher.CriterionTypes type, Climate.Parameter range, long value) {
            float comparable = Float.MAX_VALUE;
            if (type == SubBiomeMatcher.CriterionTypes.DISTANCE) {
                comparable = Climate.m_186796_((long)(value - Criterion.parameterCenter(range)));
            } else if (type == SubBiomeMatcher.CriterionTypes.VALUE) {
                comparable = Climate.m_186796_((long)value);
            }
            return this.invert == (comparable >= this.min() && comparable <= this.max());
        }

        @Override
        public boolean checkReplacement(SubBiomeMatcher.CriterionTargets target, BiolithFittestNodes<Holder<Biome>> fittestNodes, Climate.TargetPoint noisePoint, @Nullable Vector2fc replacementRange, float replacementNoise) {
            float comparable = Float.MAX_VALUE;
            if (target == SubBiomeMatcher.CriterionTargets.CENTER) {
                comparable = Mth.m_14116_((float)Criterion.getSquaredDistance(Criterion.parametersCenterPoint(fittestNodes.ultimate().f_186956_), noisePoint)) / 10000.0f;
                if (replacementRange != null) {
                    if (replacementRange.x() <= 0.0f) {
                        if (replacementRange.y() < 1.0f) {
                            comparable = Math.max(replacementNoise, comparable);
                        }
                    } else {
                        comparable = replacementRange.y() >= 1.0f ? Math.max(1.0f - replacementNoise, comparable) : Math.max(Math.abs(replacementNoise - (replacementRange.x() + replacementRange.y()) / 2.0f), comparable);
                    }
                }
            } else if (target == SubBiomeMatcher.CriterionTargets.EDGE) {
                comparable = fittestNodes.penultimate() == null ? 1.0f : (fittestNodes.penultimateDistance() == 0L ? 0.0f : (float)(fittestNodes.penultimateDistance() - fittestNodes.ultimateDistance()) / (float)fittestNodes.penultimateDistance());
                if (replacementRange != null) {
                    if (replacementRange.x() <= 0.0f) {
                        if (replacementRange.y() < 1.0f) {
                            comparable = Math.min(replacementRange.y() - replacementNoise, comparable);
                        }
                    } else {
                        comparable = replacementRange.y() >= 1.0f ? Math.min(replacementNoise - replacementRange.x(), comparable) : Math.min(Math.min(replacementNoise - replacementRange.x(), replacementRange.y() - replacementNoise), comparable);
                    }
                }
            }
            return this.invert == (comparable >= this.min() && comparable <= this.max());
        }

        static long parameterCenter(Climate.Parameter range) {
            return (range.f_186813_() + range.f_186814_()) / 2L;
        }

        static Climate.TargetPoint parametersCenterPoint(Climate.Parameter[] parameters) {
            return new Climate.TargetPoint(Criterion.parameterCenter(parameters[0]), Criterion.parameterCenter(parameters[1]), Criterion.parameterCenter(parameters[2]), Criterion.parameterCenter(parameters[3]), Criterion.parameterCenter(parameters[4]), Criterion.parameterCenter(parameters[5]));
        }

        static long getSquaredDistance(Climate.TargetPoint point1, Climate.TargetPoint point2) {
            return Mth.m_184643_((long)(point1.f_187003_() - point2.f_187003_())) + Mth.m_184643_((long)(point1.f_187004_() - point2.f_187004_())) + Mth.m_184643_((long)(point1.f_187005_() - point2.f_187005_())) + Mth.m_184643_((long)(point1.f_187006_() - point2.f_187006_())) + Mth.m_184643_((long)(point1.f_187007_() - point2.f_187007_())) + Mth.m_184643_((long)(point1.f_187008_() - point2.f_187008_()));
        }
    }
}

