/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.biolith.impl.biome;

import com.mojang.datafixers.util.Pair;
import com.terraformersmc.biolith.impl.biome.BiomeCoordinator;
import com.terraformersmc.biolith.impl.biome.DimensionBiomePlacement;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;

public class OverworldBiomePlacement
extends DimensionBiomePlacement {
    @Override
    protected double getLocalNoise(int x, int y, int z) {
        double localNoise = this.replacementNoise.sample((double)(x + this.seedlets[0]) / 1024.0, (double)(z + this.seedlets[1]) / 1024.0);
        localNoise += (double)this.replacementNoise.sample((double)(x + this.seedlets[2]) / 256.0, (double)(z + this.seedlets[3]) / 256.0) / 8.0;
        localNoise += (double)this.replacementNoise.sample((double)(x + this.seedlets[4]) / 64.0, (double)(z + this.seedlets[5]) / 64.0) / 16.0;
        localNoise += (double)this.replacementNoise.sample((double)(x + this.seedlets[6]) / 16.0, (double)(z + this.seedlets[7]) / 16.0) / 32.0;
        localNoise = this.normalize(localNoise / 1.21875);
        return localNoise;
    }

    @Override
    public void writeBiomeEntries(Consumer<Pair<Climate.ParameterPoint, Holder<Biome>>> parameters) {
        this.biomesInjected = true;
        HolderGetter<Biome> biomeEntryGetter = BiomeCoordinator.getBiomeLookupOrThrow();
        this.placementRequests.forEach(pair -> parameters.accept(pair.mapSecond(arg_0 -> ((HolderGetter)biomeEntryGetter).m_255043_(arg_0))));
        this.replacementRequests.values().stream().flatMap(requestSet -> requestSet.requests.stream()).map(DimensionBiomePlacement.ReplacementRequest::biome).distinct().forEach(biome -> {
            if (!biome.equals(VANILLA_PLACEHOLDER)) {
                parameters.accept(Pair.of((Object)OUT_OF_RANGE, (Object)biomeEntryGetter.m_255043_(biome)));
            }
        });
        this.subBiomeRequests.values().stream().flatMap(requestSet -> requestSet.requests.stream()).map(DimensionBiomePlacement.SubBiomeRequest::biome).distinct().forEach(biome -> parameters.accept(Pair.of((Object)OUT_OF_RANGE, (Object)biomeEntryGetter.m_255043_(biome))));
    }

    @Override
    public void writeBiomeParameters(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> parameters) {
        this.biomesInjected = true;
        this.placementRequests.forEach(parameters);
        this.replacementRequests.values().stream().flatMap(requestSet -> requestSet.requests.stream()).map(DimensionBiomePlacement.ReplacementRequest::biome).distinct().forEach(biome -> {
            if (!biome.equals(VANILLA_PLACEHOLDER)) {
                parameters.accept(Pair.of((Object)OUT_OF_RANGE, (Object)biome));
            }
        });
        this.subBiomeRequests.values().stream().flatMap(requestSet -> requestSet.requests.stream()).map(DimensionBiomePlacement.SubBiomeRequest::biome).distinct().forEach(biome -> parameters.accept(Pair.of((Object)OUT_OF_RANGE, (Object)biome)));
    }
}

