/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.biolith.impl.biome;

import com.mojang.datafixers.util.Pair;
import com.terraformersmc.biolith.impl.biome.BiomeCoordinator;
import com.terraformersmc.biolith.impl.biome.DimensionBiomePlacement;
import com.terraformersmc.biolith.impl.config.BiolithState;
import com.terraformersmc.terraform.noise.OpenSimplexNoise2;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;

public class EndBiomePlacement
extends DimensionBiomePlacement {
    private final Climate.ParameterPoint noiseSmallEndIslands = new Climate.ParameterPoint(DEFAULT_PARAMETER, DEFAULT_PARAMETER, DEFAULT_PARAMETER, Climate.Parameter.m_186822_((float)-1.0f, (float)-0.21875f), DEFAULT_PARAMETER, DEFAULT_PARAMETER, 0L);
    private final Climate.ParameterPoint noiseEndBarrens = new Climate.ParameterPoint(DEFAULT_PARAMETER, DEFAULT_PARAMETER, DEFAULT_PARAMETER, Climate.Parameter.m_186822_((float)-0.21875f, (float)-0.0625f), DEFAULT_PARAMETER, DEFAULT_PARAMETER, 0L);
    private final Climate.ParameterPoint noiseEndMidlands = new Climate.ParameterPoint(DEFAULT_PARAMETER, DEFAULT_PARAMETER, DEFAULT_PARAMETER, Climate.Parameter.m_186822_((float)-0.0625f, (float)0.25f), DEFAULT_PARAMETER, DEFAULT_PARAMETER, 0L);
    private final Climate.ParameterPoint noiseEndHighlands = new Climate.ParameterPoint(DEFAULT_PARAMETER, DEFAULT_PARAMETER, DEFAULT_PARAMETER, Climate.Parameter.m_186822_((float)0.25f, (float)1.0f), DEFAULT_PARAMETER, DEFAULT_PARAMETER, 0L);
    public Climate.RTree.Leaf<Holder<Biome>> nodeSmallEndIslands;
    public Climate.RTree.Leaf<Holder<Biome>> nodeEndBarrens;
    public Climate.RTree.Leaf<Holder<Biome>> nodeEndMidlands;
    public Climate.RTree.Leaf<Holder<Biome>> nodeEndHighlands;
    public OpenSimplexNoise2 humidityNoise;
    public OpenSimplexNoise2 temperatureNoise;
    public OpenSimplexNoise2 weirdnessNoise;

    @Override
    protected void serverReplaced(BiolithState state, long seed) {
        super.serverReplaced(state, seed);
        HolderGetter<Biome> biomeEntryGetter = BiomeCoordinator.getBiomeLookupOrThrow();
        this.nodeSmallEndIslands = new Climate.RTree.Leaf(this.noiseSmallEndIslands, (Object)biomeEntryGetter.m_255043_(Biomes.f_48162_));
        this.nodeEndBarrens = new Climate.RTree.Leaf(this.noiseEndBarrens, (Object)biomeEntryGetter.m_255043_(Biomes.f_48165_));
        this.nodeEndMidlands = new Climate.RTree.Leaf(this.noiseEndMidlands, (Object)biomeEntryGetter.m_255043_(Biomes.f_48163_));
        this.nodeEndHighlands = new Climate.RTree.Leaf(this.noiseEndHighlands, (Object)biomeEntryGetter.m_255043_(Biomes.f_48164_));
        this.humidityNoise = new OpenSimplexNoise2((long)this.seedlets[7]);
        this.temperatureNoise = new OpenSimplexNoise2((long)this.seedlets[5]);
        this.weirdnessNoise = new OpenSimplexNoise2((long)this.seedlets[3]);
    }

    @Override
    protected double getLocalNoise(int x, int y, int z) {
        double localNoise = this.replacementNoise.sample((double)(x + this.seedlets[0]) / 256.0, (double)(z + this.seedlets[1]) / 256.0);
        localNoise += (double)this.replacementNoise.sample((double)(x + this.seedlets[2]) / 64.0, (double)(z + this.seedlets[3]) / 64.0) / 4.0;
        localNoise += (double)this.replacementNoise.sample((double)(x + this.seedlets[4]) / 16.0, (double)(z + this.seedlets[5]) / 16.0) / 16.0;
        localNoise += (double)this.replacementNoise.sample((double)(x + this.seedlets[6]) / 4.0, (double)(z + this.seedlets[7]) / 4.0) / 32.0;
        localNoise = this.normalize(localNoise / 1.3125);
        return localNoise;
    }

    @Override
    public void writeBiomeEntries(Consumer<Pair<Climate.ParameterPoint, Holder<Biome>>> parameters) {
        this.biomesInjected = true;
        HolderGetter<Biome> biomeEntryGetter = BiomeCoordinator.getBiomeLookupOrThrow();
        this.placementRequests.forEach(pair -> parameters.accept(pair.mapSecond(arg_0 -> ((HolderGetter)biomeEntryGetter).m_255043_(arg_0))));
        this.replacementRequests.values().stream().flatMap(requestSet -> requestSet.requests.stream()).map(DimensionBiomePlacement.ReplacementRequest::biome).distinct().forEach(biome -> {
            if (!biome.equals(VANILLA_PLACEHOLDER)) {
                parameters.accept(Pair.of((Object)OUT_OF_RANGE, (Object)biomeEntryGetter.m_255043_(biome)));
            }
        });
        this.subBiomeRequests.values().stream().flatMap(requestSet -> requestSet.requests.stream()).map(DimensionBiomePlacement.SubBiomeRequest::biome).distinct().forEach(biome -> parameters.accept(Pair.of((Object)OUT_OF_RANGE, (Object)biomeEntryGetter.m_255043_(biome))));
    }

    @Override
    public void writeBiomeParameters(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> parameters) {
        this.biomesInjected = true;
        this.placementRequests.forEach(parameters);
        this.replacementRequests.values().stream().flatMap(requestSet -> requestSet.requests.stream()).map(DimensionBiomePlacement.ReplacementRequest::biome).distinct().forEach(biome -> {
            if (!biome.equals(VANILLA_PLACEHOLDER)) {
                parameters.accept(Pair.of((Object)OUT_OF_RANGE, (Object)biome));
            }
        });
        this.subBiomeRequests.values().stream().flatMap(requestSet -> requestSet.requests.stream()).map(DimensionBiomePlacement.SubBiomeRequest::biome).distinct().forEach(biome -> parameters.accept(Pair.of((Object)OUT_OF_RANGE, (Object)biome)));
    }
}

