/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.biolith.impl.biome;

import com.mojang.datafixers.util.Pair;
import com.terraformersmc.biolith.api.biome.SubBiomeMatcher;
import com.terraformersmc.biolith.impl.Biolith;
import com.terraformersmc.biolith.impl.biome.BiolithFittestNodes;
import com.terraformersmc.biolith.impl.biome.BiomeCoordinator;
import com.terraformersmc.biolith.impl.config.BiolithState;
import com.terraformersmc.terraform.noise.OpenSimplexNoise2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2f;
import org.joml.Vector2fc;

public abstract class DimensionBiomePlacement {
    protected boolean biomesInjected = false;
    protected BiolithState state;
    protected OpenSimplexNoise2 replacementNoise;
    protected int[] seedlets = new int[8];
    protected Random seedRandom;
    protected final Collection<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> placementRequests = new HashSet<Pair<Climate.ParameterPoint, ResourceKey<Biome>>>(256);
    protected final HashMap<ResourceKey<Biome>, ReplacementRequestSet> replacementRequests = new HashMap(256);
    protected final HashMap<ResourceKey<Biome>, SubBiomeRequestSet> subBiomeRequests = new HashMap(256);
    public static final Climate.Parameter DEFAULT_PARAMETER = Climate.Parameter.m_186822_((float)-1.0f, (float)1.0f);
    public static final Climate.ParameterPoint OUT_OF_RANGE = Climate.m_186788_((float)3.01f, (float)3.01f, (float)3.01f, (float)3.01f, (float)3.01f, (float)3.01f, (float)3.01f);
    public static final ResourceKey<Biome> VANILLA_PLACEHOLDER = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)ResourceLocation.m_214293_((String)"biolith", (String)"vanilla"));

    protected void serverReplaced(BiolithState state, long seed) {
        this.state = state;
        this.replacementNoise = new OpenSimplexNoise2(seed);
        this.seedRandom = new Random(seed);
        this.replacementRequests.forEach((biomeKey, requestSet) -> requestSet.complete(BiomeCoordinator.getBiomeLookupOrThrow()));
        this.subBiomeRequests.forEach((biomeKey, requestSet) -> requestSet.complete(BiomeCoordinator.getBiomeLookupOrThrow()));
        this.seedlets[0] = (int)(seed & 0xFFL);
        this.seedlets[1] = (int)(seed >> 8 & 0xFFL);
        this.seedlets[2] = (int)(seed >> 16 & 0xFFL);
        this.seedlets[3] = (int)(seed >> 24 & 0xFFL);
        this.seedlets[4] = (int)(seed >> 32 & 0xFFL);
        this.seedlets[5] = (int)(seed >> 40 & 0xFFL);
        this.seedlets[6] = (int)(seed >> 48 & 0xFFL);
        this.seedlets[7] = (int)(seed >> 56 & 0xFFL);
    }

    public void addPlacement(ResourceKey<Biome> biome, Climate.ParameterPoint noisePoint) {
        if (this.biomesInjected) {
            Biolith.LOGGER.error("Biolith's BiomePlacement.addPlacement() called too late for biome: {}", (Object)biome.m_135782_());
        } else {
            this.placementRequests.add((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)noisePoint, biome));
        }
    }

    public void addReplacement(ResourceKey<Biome> target, ResourceKey<Biome> biome, double rate) {
        if (this.biomesInjected) {
            Biolith.LOGGER.error("Biolith's BiomePlacement.addReplacement() called too late for biome: {}", (Object)biome.m_135782_());
        } else {
            this.replacementRequests.computeIfAbsent(target, x$0 -> new ReplacementRequestSet((ResourceKey<Biome>)x$0)).addRequest(biome, rate);
        }
    }

    public void addSubBiome(ResourceKey<Biome> target, ResourceKey<Biome> biome, SubBiomeMatcher matcher) {
        if (this.biomesInjected) {
            Biolith.LOGGER.error("Biolith's BiomePlacement.addSubBiome() called too late for biome: {}", (Object)biome.m_135782_());
        } else {
            this.subBiomeRequests.computeIfAbsent(target, x$0 -> new SubBiomeRequestSet((ResourceKey<Biome>)x$0)).addRequest(biome, matcher);
        }
    }

    public Holder<Biome> getReplacement(int x, int y, int z, Climate.TargetPoint noisePoint, BiolithFittestNodes<Holder<Biome>> fittestNodes) {
        Record request;
        Holder<Biome> biomeEntry = (Holder<Biome>)fittestNodes.ultimate().f_186948_;
        ResourceKey<Biome> biomeKey = (ResourceKey<Biome>)biomeEntry.m_203543_().orElseThrow();
        double localNoise = -1.0;
        Vector2f localRange = null;
        if (this.replacementRequests.containsKey(biomeKey)) {
            localNoise = this.getLocalNoise(x, y, z);
            request = this.replacementRequests.get(biomeKey).selectReplacement(localNoise);
            if (request != null) {
                localRange = ((ReplacementRequest)request).range();
                if (!((ReplacementRequest)request).biome().equals(VANILLA_PLACEHOLDER)) {
                    biomeEntry = ((ReplacementRequest)request).biomeEntry();
                    biomeKey = ((ReplacementRequest)request).biome();
                }
            }
        }
        if (this.subBiomeRequests.containsKey(biomeKey)) {
            if (localNoise < 0.0) {
                localNoise = this.getLocalNoise(x, y, z);
            }
            if ((request = this.subBiomeRequests.get(biomeKey).selectSubBiome(fittestNodes, noisePoint, (Vector2fc)localRange, localNoise)) != null) {
                biomeEntry = ((SubBiomeRequest)request).biomeEntry();
                biomeKey = ((SubBiomeRequest)request).biome();
            }
        }
        return biomeEntry;
    }

    public abstract void writeBiomeEntries(Consumer<Pair<Climate.ParameterPoint, Holder<Biome>>> var1);

    public abstract void writeBiomeParameters(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> var1);

    protected abstract double getLocalNoise(int var1, int var2, int var3);

    protected double normalize(double value) {
        return Mth.m_14008_((double)(value * 0.5375 + 0.5), (double)0.0, (double)1.0);
    }

    protected class ReplacementRequestSet {
        ResourceKey<Biome> target;
        List<ReplacementRequest> requests = new ArrayList<ReplacementRequest>(8);

        ReplacementRequestSet(ResourceKey<Biome> target) {
            this.target = target;
        }

        void addRequest(ResourceKey<Biome> biome, double rate) {
            this.addRequest(ReplacementRequest.of(biome, rate));
        }

        void addRequest(ReplacementRequest request) {
            if (this.requests.contains(request)) {
                Biolith.LOGGER.info("Ignoring request for duplicate biome replacement: {}", request.biome);
            } else {
                this.requests.add(request);
            }
        }

        @Nullable
        public ReplacementRequest selectReplacement(double localNoise) {
            for (ReplacementRequest request : this.requests) {
                if (!(request.end > localNoise)) continue;
                return request;
            }
            return null;
        }

        void complete(HolderGetter<Biome> biomeEntryGetter) {
            double maxRate = 0.0;
            this.requests = new ArrayList<ReplacementRequest>(this.requests);
            this.requests.removeIf(request -> request.biome.equals(VANILLA_PLACEHOLDER));
            double locus = 0.0;
            for (ReplacementRequest request2 : this.requests) {
                locus += request2.rate;
                if (!(request2.rate > maxRate)) continue;
                maxRate = request2.rate;
            }
            double vanilla = Mth.m_14008_((double)(1.0 - maxRate), (double)0.0, (double)1.0);
            double scale = locus + vanilla;
            if (vanilla > 0.0) {
                this.requests.add(ReplacementRequest.of(VANILLA_PLACEHOLDER, vanilla));
            }
            Collections.shuffle(this.requests, DimensionBiomePlacement.this.seedRandom);
            DimensionBiomePlacement.this.state.addBiomeReplacements(this.target, this.requests.stream().map(ReplacementRequest::biome));
            List<ResourceKey<Biome>> sortOrder = DimensionBiomePlacement.this.state.getBiomeReplacements(this.target).toList();
            this.requests.sort(Comparator.comparingInt(request -> sortOrder.indexOf(request.biome)));
            locus = 0.0;
            for (int i = 0; i < this.requests.size(); ++i) {
                ReplacementRequest request3 = this.requests.get(i);
                this.requests.set(i, request3.complete(biomeEntryGetter, locus, locus += request3.rate / scale));
            }
            this.requests = List.copyOf(this.requests);
        }
    }

    protected class SubBiomeRequestSet {
        ResourceKey<Biome> target;
        List<SubBiomeRequest> requests = new ArrayList<SubBiomeRequest>(8);

        SubBiomeRequestSet(ResourceKey<Biome> target) {
            this.target = target;
        }

        void addRequest(ResourceKey<Biome> biome, SubBiomeMatcher matcher) {
            this.addRequest(SubBiomeRequest.of(biome, matcher));
        }

        void addRequest(SubBiomeRequest request) {
            if (this.requests.contains(request)) {
                Biolith.LOGGER.info("Ignoring request for duplicate sub-biome: {} -> {}", this.target, request.biome);
            } else {
                this.requests.add(request);
            }
        }

        @Nullable
        public SubBiomeRequest selectSubBiome(BiolithFittestNodes<Holder<Biome>> fittestNodes, Climate.TargetPoint noisePoint, @Nullable Vector2fc localRange, double localNoise) {
            for (SubBiomeRequest request : this.requests) {
                if (!request.matcher().matches(fittestNodes, DimensionBiomePlacement.this, noisePoint, localRange, (float)localNoise)) continue;
                return request;
            }
            return null;
        }

        void complete(HolderGetter<Biome> biomeEntryGetter) {
            this.requests = new ArrayList<SubBiomeRequest>(this.requests);
            this.requests = this.requests.stream().map(request -> request.complete(biomeEntryGetter)).sorted(Comparator.comparing(request -> request.biome.m_135782_())).toList();
        }
    }

    protected record ReplacementRequest(ResourceKey<Biome> biome, double rate, Holder<Biome> biomeEntry, double start, double end) {
        public ReplacementRequest {
            rate = Mth.m_14008_((double)rate, (double)0.0, (double)1.0);
        }

        static ReplacementRequest of(ResourceKey<Biome> biome, double rate) {
            return new ReplacementRequest(biome, rate, null, 0.0, 0.0);
        }

        public Vector2f range() {
            return new Vector2f((float)this.start, this.end > 0.9999 ? 1.0f : (float)this.end);
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof ReplacementRequest) {
                ReplacementRequest request = (ReplacementRequest)object;
                return request.biome.equals(this.biome) && request.rate == this.rate;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.biome.hashCode();
        }

        ReplacementRequest complete(HolderGetter<Biome> biomeEntryGetter, double start, double end) {
            if (this.biome.equals(VANILLA_PLACEHOLDER)) {
                return new ReplacementRequest(this.biome, this.rate, null, start, end);
            }
            return new ReplacementRequest(this.biome, this.rate, (Holder<Biome>)biomeEntryGetter.m_255043_(this.biome), start, end);
        }
    }

    protected record SubBiomeRequest(ResourceKey<Biome> biome, SubBiomeMatcher matcher, Holder<Biome> biomeEntry) {
        static SubBiomeRequest of(ResourceKey<Biome> biome, SubBiomeMatcher matcher) {
            return new SubBiomeRequest(biome, matcher, null);
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof SubBiomeRequest) {
                SubBiomeRequest request = (SubBiomeRequest)object;
                return request.biome.equals(this.biome) && request.matcher.equals(this.matcher);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.biome.hashCode();
        }

        SubBiomeRequest complete(HolderGetter<Biome> biomeEntryGetter) {
            return new SubBiomeRequest(this.biome, this.matcher, (Holder<Biome>)biomeEntryGetter.m_255043_(this.biome));
        }
    }
}

