/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.biolith.impl.biome;

import com.terraformersmc.biolith.impl.Biolith;
import com.terraformersmc.biolith.impl.biome.DimensionBiomePlacement;
import com.terraformersmc.biolith.impl.biome.EndBiomePlacement;
import com.terraformersmc.biolith.impl.biome.NetherBiomePlacement;
import com.terraformersmc.biolith.impl.biome.OverworldBiomePlacement;
import com.terraformersmc.biolith.impl.config.BiolithState;
import com.terraformersmc.biolith.impl.surface.SurfaceRuleCollector;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.levelgen.SurfaceRules;
import org.jetbrains.annotations.Nullable;
import terrablender.api.SurfaceRuleManager;

public class BiomeCoordinator {
    public static final DimensionBiomePlacement END = new EndBiomePlacement();
    public static final DimensionBiomePlacement NETHER = new NetherBiomePlacement();
    public static final DimensionBiomePlacement OVERWORLD = new OverworldBiomePlacement();
    private static boolean registeredWithTerrablender = false;
    private static BiolithState END_STATE;
    private static BiolithState NETHER_STATE;
    private static BiolithState OVERWORLD_STATE;
    private static boolean serverStarted;
    protected static RegistryAccess.Frozen registryManager;

    public static void setRegistryManager(LayeredRegistryAccess<RegistryLayer> combinedDynamicRegistries) {
        registryManager = combinedDynamicRegistries.m_247579_();
    }

    @Nullable
    public static RegistryAccess.Frozen getRegistryManager() {
        return registryManager;
    }

    public static Optional<HolderLookup.RegistryLookup<Biome>> getBiomeLookup() {
        RegistryAccess.Frozen registryManager = BiomeCoordinator.getRegistryManager();
        if (registryManager == null) {
            return Optional.empty();
        }
        return registryManager.m_254861_(Registries.f_256952_);
    }

    public static HolderGetter<Biome> getBiomeLookupOrThrow() {
        return (HolderGetter)BiomeCoordinator.getBiomeLookup().orElseThrow();
    }

    public static void handleServerStarting(MinecraftServer server) {
        if (registryManager == null) {
            registryManager = server.m_247573_().m_247579_();
        }
        if (Biolith.COMPAT_TERRABLENDER) {
            BiomeCoordinator.registerWithTerrablender();
        }
        if (serverStarted) {
            Biolith.LOGGER.warn("Received notification of server start-up but it should already be running!  O.o");
        } else {
            serverStarted = true;
        }
    }

    public static void handleWorldStarting(ServerLevel world) {
        if (!serverStarted) {
            Biolith.LOGGER.error("New world '{}' created when server is not running!", (Object)world.m_46472_().m_135782_());
        }
        if (BuiltinDimensionTypes.f_223540_.equals(world.m_220362_())) {
            END_STATE = new BiolithState(world, "end");
            END.serverReplaced(END_STATE, world.m_7328_());
        } else if (BuiltinDimensionTypes.f_223539_.equals(world.m_220362_())) {
            NETHER_STATE = new BiolithState(world, "nether");
            NETHER.serverReplaced(NETHER_STATE, world.m_7328_());
        } else if (BuiltinDimensionTypes.f_223538_.equals(world.m_220362_())) {
            OVERWORLD_STATE = new BiolithState(world, "overworld");
            OVERWORLD.serverReplaced(OVERWORLD_STATE, world.m_7328_());
        } else {
            Biolith.LOGGER.info("Ignoring world '{}'; unknown dimension type: {}", (Object)world.m_46472_().m_135782_(), (Object)world.m_220362_().m_135782_());
        }
    }

    public static void handleServerStopped(MinecraftServer server) {
        serverStarted = false;
        registryManager = null;
        END_STATE = null;
        NETHER_STATE = null;
        OVERWORLD_STATE = null;
    }

    private static void registerWithTerrablender() {
        if (!registeredWithTerrablender) {
            Map.of(SurfaceRuleCollector.OVERWORLD, SurfaceRuleManager.RuleCategory.OVERWORLD, SurfaceRuleCollector.NETHER, SurfaceRuleManager.RuleCategory.NETHER).forEach((biolithRules, terrablenderRuleCategory) -> {
                if (biolithRules.getRuleCount() > 0) {
                    for (ResourceLocation ruleOwner : biolithRules.getRuleOwners()) {
                        if (biolithRules.getRuleCount(ruleOwner) <= 0) continue;
                        SurfaceRuleManager.addSurfaceRules((SurfaceRuleManager.RuleCategory)terrablenderRuleCategory, (String)ruleOwner.m_135827_(), (SurfaceRules.RuleSource)biolithRules.get(ruleOwner));
                    }
                }
            });
            registeredWithTerrablender = true;
        }
    }

    static {
        serverStarted = false;
    }
}

