/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.biolith.api.biome;

import com.terraformersmc.biolith.impl.biome.BiolithFittestNodes;
import com.terraformersmc.biolith.impl.biome.DimensionBiomePlacement;
import com.terraformersmc.biolith.impl.biome.SubBiomeMatcherImpl;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2fc;

public abstract class SubBiomeMatcher {
    public static final Criterion NEAR_BORDER = Criterion.ofMax(CriterionTargets.EDGE, CriterionTypes.RATIO, 0.2f);
    public static final Criterion NEAR_INTERIOR = Criterion.ofMax(CriterionTargets.CENTER, CriterionTypes.RATIO, 0.2f);
    public static final SubBiomeMatcher BEACHSIDE = SubBiomeMatcher.of(NEAR_BORDER, Criterion.ofBiome(CriterionTargets.NEIGHBOR, (TagKey<Biome>)BiomeTags.f_207604_, false));
    public static final SubBiomeMatcher OCEANSIDE = SubBiomeMatcher.of(NEAR_BORDER, Criterion.ofBiome(CriterionTargets.NEIGHBOR, (TagKey<Biome>)BiomeTags.f_207603_, false));
    public static final SubBiomeMatcher RIVERSIDE = SubBiomeMatcher.of(NEAR_BORDER, Criterion.ofBiome(CriterionTargets.NEIGHBOR, (TagKey<Biome>)BiomeTags.f_207605_, false));

    public static SubBiomeMatcher of(Criterion ... criteria) {
        return SubBiomeMatcherImpl.of(criteria);
    }

    public abstract SubBiomeMatcher addCriterion(Criterion var1);

    public abstract void sort();

    public abstract boolean matches(BiolithFittestNodes<Holder<Biome>> var1, DimensionBiomePlacement var2, Climate.TargetPoint var3, @Nullable Vector2fc var4, float var5);

    public static interface Criterion {
        public CriterionTargets target();

        public CriterionTypes type();

        public static Criterion ofRange(CriterionTargets target, CriterionTypes type, float min, float max, boolean invert) {
            return new SubBiomeMatcherImpl.Criterion(target, type, null, null, null, min, max, invert);
        }

        public static Criterion ofMin(CriterionTargets target, CriterionTypes type, float min) {
            return new SubBiomeMatcherImpl.Criterion(target, type, null, null, null, min, Float.MAX_VALUE, false);
        }

        public static Criterion ofMax(CriterionTargets target, CriterionTypes type, float max) {
            return new SubBiomeMatcherImpl.Criterion(target, type, null, null, null, Float.MIN_VALUE, max, false);
        }

        public static Criterion ofBiome(CriterionTargets target, ResourceKey<Biome> biome, boolean invert) {
            return new SubBiomeMatcherImpl.Criterion(target, CriterionTypes.BIOME, biome, null, null, Float.MIN_VALUE, Float.MAX_VALUE, invert);
        }

        public static Criterion ofBiome(CriterionTargets target, TagKey<Biome> biomeTag, boolean invert) {
            return new SubBiomeMatcherImpl.Criterion(target, CriterionTypes.BIOME, null, null, biomeTag, Float.MIN_VALUE, Float.MAX_VALUE, invert);
        }

        public static Criterion ofAlternate(CriterionTargets target, ResourceKey<Biome> biome, ResourceKey<Biome> alternateBiome, boolean invert) {
            return new SubBiomeMatcherImpl.Criterion(target, CriterionTypes.BIOME, biome, alternateBiome, null, Float.MIN_VALUE, Float.MAX_VALUE, invert);
        }

        public boolean checkBiome(CriterionTargets var1, BiolithFittestNodes<Holder<Biome>> var2, DimensionBiomePlacement var3, float var4);

        public boolean checkRange(CriterionTypes var1, Climate.Parameter var2, long var3);

        public boolean checkReplacement(CriterionTargets var1, BiolithFittestNodes<Holder<Biome>> var2, Climate.TargetPoint var3, @Nullable Vector2fc var4, float var5);
    }

    public static enum CriterionTargets {
        CONTINENTALNESS,
        DEPTH,
        EROSION,
        HUMIDITY,
        TEMPERATURE,
        WEIRDNESS,
        ALTERNATE,
        ORIGINAL,
        NEIGHBOR,
        PEAKS_VALLEYS,
        CENTER,
        EDGE;

    }

    public static enum CriterionTypes {
        BIOME,
        DISTANCE,
        RATIO,
        VALUE;

    }

    public static enum ParameterListIndex {
        TEMPERATURE,
        HUMIDITY,
        CONTINENTALNESS,
        EROSION,
        DEPTH,
        WEIRDNESS,
        OFFSET;

    }
}

