/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.calio.screen;

import java.awt.Desktop;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public class MissingConnectorModDependencyScreen
extends class_437 {
    private final List<class_2561> lines = new ArrayList<class_2561>();
    private final String titleLine;
    private final String subtitleLine;
    private double scrollOffset = 0.0;

    public MissingConnectorModDependencyScreen(class_2561 content, String titleLine, String subtitleLine) {
        super(class_2561.method_30163((String)"Exception"));
        this.titleLine = titleLine;
        this.subtitleLine = subtitleLine;
        String raw = content.getString();
        if (raw.contains("\n")) {
            for (String ln : raw.split("\\r?\\n")) {
                this.lines.add((class_2561)class_2561.method_43470((String)ln));
            }
        } else {
            this.lines.add(content);
        }
    }

    public MissingConnectorModDependencyScreen(List<class_2561> lines, String titleLine, String subtitleLine) {
        super(class_2561.method_30163((String)"Exception"));
        this.titleLine = titleLine;
        this.subtitleLine = subtitleLine;
        this.lines.addAll(lines);
    }

    protected void method_25426() {
        super.method_25426();
        int buttonWidth = 160;
        int buttonHeight = 20;
        int spacing = 8;
        int totalWidth = 496;
        int startX = (this.field_22789 - 496) / 2;
        int y = this.field_22790 - 35;
        class_4185 modsBtn = class_4185.method_46430((class_2561)class_2561.method_30163((String)"Open Mods Folder"), btn -> {
            try {
                Path mods = FabricLoader.getInstance().getGameDir().resolve("mods");
                this.openPath(mods);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }).method_46433(startX + 160 + 8, y).method_46437(160, 20).method_46431();
        this.method_37063((class_364)modsBtn);
    }

    private void openPath(Path p) throws Exception {
        File f = p.toFile();
        if (!f.exists()) {
            File parent = f.getParentFile();
            if (parent != null && parent.exists()) {
                this.openFile(parent);
            }
            return;
        }
        this.openFile(f);
    }

    private void openFile(File f) throws Exception {
        if (Desktop.isDesktopSupported()) {
            Desktop.getDesktop().open(f);
        } else {
            String os = System.getProperty("os.name").toLowerCase();
            if (os.contains("mac")) {
                Runtime.getRuntime().exec(new String[]{"open", f.getAbsolutePath()});
            } else if (os.contains("nix") || os.contains("nux")) {
                Runtime.getRuntime().exec(new String[]{"xdg-open", f.getAbsolutePath()});
            } else if (os.contains("win")) {
                Runtime.getRuntime().exec(new String[]{"cmd", "/c", "start", "\"\"", f.getAbsolutePath()});
            } else {
                throw new UnsupportedOperationException("Cannot open file on this OS: " + os);
            }
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        int topPadding;
        int leftPadding;
        this.method_25420(context);
        class_327 tr = this.field_22793;
        int centreX = this.field_22789 / 2;
        int y = 15;
        int titleWidth = tr.method_1727(this.titleLine);
        context.method_27535(tr, class_2561.method_30163((String)this.titleLine), centreX - titleWidth / 2, y, 0xFF5555);
        Objects.requireNonNull(tr);
        int subtitleWidth = tr.method_1727(this.subtitleLine);
        context.method_27535(tr, class_2561.method_30163((String)this.subtitleLine), centreX - subtitleWidth / 2, y += 9 + 2, 0xFF5555);
        Objects.requireNonNull(tr);
        y += 9 + 6;
        int areaX = leftPadding = 20;
        int areaY = topPadding = 50;
        int rightPadding = 20;
        int areaWidth = this.field_22789 - leftPadding - rightPadding;
        int bottomButtonAreaHeight = 50;
        int areaHeight = this.field_22790 - topPadding - bottomButtonAreaHeight - 10;
        context.method_25294(areaX - 4, areaY - 4, areaX + areaWidth + 4, areaY + areaHeight + 4, -2013265920);
        this.drawRectOutline(context, areaX - 4, areaY - 4, areaX + areaWidth + 4, areaY + areaHeight + 4, -13421773);
        ArrayList wrappedLines = new ArrayList();
        for (class_2561 line : this.lines) {
            wrappedLines.addAll(tr.method_1728((class_5348)line, areaWidth));
        }
        Objects.requireNonNull(tr);
        int fh = 9;
        int maxVisibleLines = Math.max(1, areaHeight / fh);
        double maxScroll = Math.max(0, wrappedLines.size() - maxVisibleLines);
        this.scrollOffset = Math.max(0.0, Math.min(this.scrollOffset, maxScroll));
        int startLine = (int)Math.floor(this.scrollOffset);
        int endLine = Math.min(wrappedLines.size(), startLine + maxVisibleLines);
        context.method_44379(areaX, areaY, areaX + areaWidth, areaY + areaHeight);
        int drawY = areaY;
        for (int i = startLine; i < endLine; ++i) {
            context.method_35720(tr, (class_5481)wrappedLines.get(i), areaX, drawY, 0xFFFFFF);
            drawY += fh;
        }
        context.method_44380();
        super.method_25394(context, mouseX, mouseY, delta);
    }

    private void drawRectOutline(class_332 ctx, int x1, int y1, int x2, int y2, int color) {
        ctx.method_25294(x1, y1, x2, y1 + 1, color);
        ctx.method_25294(x1, y2 - 1, x2, y2, color);
        ctx.method_25294(x1, y1, x1 + 1, y2, color);
        ctx.method_25294(x2 - 1, y1, x2, y2, color);
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        this.scrollOffset -= amount * 3.0;
        return true;
    }

    public boolean method_25421() {
        return false;
    }
}

