/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.calio.registry;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import io.github.apace100.calio.ClassUtil;
import io.github.apace100.calio.data.MultiJsonDataLoader;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.calio.data.SerializableDataTypes;
import io.github.apace100.calio.network.CalioNetworking;
import io.github.apace100.calio.registry.DataObject;
import io.github.apace100.calio.registry.DataObjectFactory;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_151;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataObjectRegistry<T extends DataObject<T>> {
    private static final HashMap<class_2960, DataObjectRegistry<?>> REGISTRIES = new HashMap();
    private static final Set<class_2960> AUTO_SYNC_SET = new HashSet<class_2960>();
    private final class_2960 registryId;
    private final Class<T> objectClass;
    private final HashMap<class_2960, T> idToEntry = new HashMap();
    private final HashMap<T, class_2960> entryToId = new HashMap();
    private final HashMap<class_2960, T> staticEntries = new HashMap();
    private final String factoryFieldName;
    private final DataObjectFactory<T> defaultFactory;
    private final HashMap<class_2960, DataObjectFactory<T>> factoriesById = new HashMap();
    private final HashMap<DataObjectFactory<T>, class_2960> factoryToId = new HashMap();
    private SerializableDataType<T> dataType;
    private SerializableDataType<List<T>> listDataType;
    private SerializableDataType<T> registryDataType;
    private SerializableDataType<Supplier<T>> lazyDataType;
    private final Function<JsonElement, JsonElement> jsonPreprocessor;
    private Loader loader;

    private DataObjectRegistry(class_2960 registryId, Class<T> objectClass, String factoryFieldName, DataObjectFactory<T> defaultFactory, Function<JsonElement, JsonElement> jsonPreprocessor) {
        this.registryId = registryId;
        this.objectClass = objectClass;
        this.factoryFieldName = factoryFieldName;
        this.defaultFactory = defaultFactory;
        this.jsonPreprocessor = jsonPreprocessor;
    }

    private DataObjectRegistry(class_2960 registryId, Class<T> objectClass, String factoryFieldName, DataObjectFactory<T> defaultFactory, Function<JsonElement, JsonElement> jsonPreprocessor, String dataFolder, boolean useLoadingPriority, BiConsumer<class_2960, Exception> errorHandler) {
        this(registryId, objectClass, factoryFieldName, defaultFactory, jsonPreprocessor);
        this.loader = new Loader(dataFolder, useLoadingPriority, errorHandler);
    }

    public IdentifiableResourceReloadListener getLoader() {
        return this.loader;
    }

    public class_2960 getRegistryId() {
        return this.registryId;
    }

    public class_2960 getId(T entry) {
        return this.entryToId.get(entry);
    }

    public DataObjectFactory<T> getFactory(class_2960 id) {
        return this.factoriesById.get(id);
    }

    public class_2960 getFactoryId(DataObjectFactory<T> factory) {
        return this.factoryToId.get(factory);
    }

    public void registerFactory(class_2960 id, DataObjectFactory<T> factory) {
        this.factoriesById.put(id, factory);
        this.factoryToId.put(factory, id);
    }

    public void register(class_2960 id, T entry) {
        this.idToEntry.put(id, entry);
        this.entryToId.put(entry, id);
    }

    public void registerStatic(class_2960 id, T entry) {
        this.staticEntries.put(id, entry);
        this.register(id, entry);
    }

    public void write(class_2540 buf) {
        buf.writeInt(this.idToEntry.size() - this.staticEntries.size());
        for (Map.Entry<class_2960, T> entry : this.idToEntry.entrySet()) {
            if (this.staticEntries.containsKey(entry.getKey())) continue;
            buf.method_10812(entry.getKey());
            this.writeDataObject(buf, (DataObject)entry.getValue());
        }
    }

    public void writeDataObject(class_2540 buf, T t) {
        DataObjectFactory<T> factory = t.getFactory();
        buf.method_10812(this.factoryToId.get(factory));
        SerializableData.Instance data = factory.toData(t);
        factory.getData().write(buf, data);
    }

    public void receive(class_2540 buf) {
        this.receive(buf, Runnable::run);
    }

    public void receive(class_2540 buf, Consumer<Runnable> scheduler) {
        int entryCount = buf.readInt();
        HashMap<class_2960, T> entries = new HashMap<class_2960, T>(entryCount);
        for (int i = 0; i < entryCount; ++i) {
            class_2960 entryId = buf.method_10810();
            T entry = this.receiveDataObject(buf);
            entries.put(entryId, entry);
        }
        scheduler.accept(() -> {
            this.clear();
            entries.forEach(this::register);
        });
    }

    public T receiveDataObject(class_2540 buf) {
        class_2960 factoryId = buf.method_10810();
        DataObjectFactory<T> factory = this.getFactory(factoryId);
        SerializableData.Instance data = factory.getData().read(buf);
        return (T)((DataObject)factory.fromData(data));
    }

    public T readDataObject(JsonElement element) {
        DataObjectFactory<T> factory;
        if (this.jsonPreprocessor != null) {
            element = this.jsonPreprocessor.apply(element);
        }
        if (!element.isJsonObject()) {
            throw new JsonParseException("Could not read data object of type \"" + this.registryId + "\": expected a json object.");
        }
        JsonObject jsonObject = element.getAsJsonObject();
        if (!jsonObject.has(this.factoryFieldName) && this.defaultFactory == null) {
            throw new JsonParseException("Could not read data object of type \"" + this.registryId + "\": no factory identifier provided (expected key: \"" + this.factoryFieldName + "\").");
        }
        if (jsonObject.has(this.factoryFieldName)) {
            String type = class_3518.method_15265((JsonObject)jsonObject, (String)this.factoryFieldName);
            class_2960 factoryId = null;
            try {
                factoryId = new class_2960(type);
            }
            catch (class_151 e) {
                throw new JsonParseException("Could not read data object of type \"" + this.registryId + "\": invalid factory identifier (id: \"" + factoryId + "\").", (Throwable)e);
            }
            if (!this.factoriesById.containsKey(factoryId)) {
                throw new JsonParseException("Could not read data object of type \"" + this.registryId + "\": unknown factory (id: \"" + factoryId + "\").");
            }
            factory = this.getFactory(factoryId);
        } else {
            factory = this.defaultFactory;
        }
        SerializableData.Instance data = factory.getData().read(jsonObject);
        return (T)((DataObject)factory.fromData(data));
    }

    public void sync(class_3222 player) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10812(this.registryId);
        this.write(buf);
        ServerPlayNetworking.send((class_3222)player, (class_2960)CalioNetworking.SYNC_DATA_OBJECT_REGISTRY, (class_2540)buf);
    }

    public void clear() {
        this.idToEntry.clear();
        this.entryToId.clear();
        this.staticEntries.forEach(this::register);
    }

    @Nullable
    public T get(class_2960 id) {
        return (T)((DataObject)this.idToEntry.get(id));
    }

    public Set<class_2960> getIds() {
        return this.idToEntry.keySet();
    }

    public boolean containsId(class_2960 id) {
        return this.idToEntry.containsKey(id);
    }

    @NotNull
    public Iterator<T> iterator() {
        return this.idToEntry.values().iterator();
    }

    public SerializableDataType<T> dataType() {
        if (this.dataType == null) {
            this.dataType = this.createDataType();
        }
        return this.dataType;
    }

    public SerializableDataType<List<T>> listDataType() {
        if (this.dataType == null) {
            this.dataType = this.createDataType();
        }
        if (this.listDataType == null) {
            this.listDataType = SerializableDataType.list(this.dataType);
        }
        return this.listDataType;
    }

    public SerializableDataType<T> registryDataType() {
        if (this.registryDataType == null) {
            this.registryDataType = this.createRegistryDataType();
        }
        return this.registryDataType;
    }

    public SerializableDataType<Supplier<T>> lazyDataType() {
        if (this.lazyDataType == null) {
            this.lazyDataType = this.createLazyDataType();
        }
        return this.lazyDataType;
    }

    public SerializableDataType<Supplier<T>> createLazyDataType() {
        return SerializableDataType.wrap(ClassUtil.castClass(Supplier.class), SerializableDataTypes.IDENTIFIER, lazy -> this.getId((DataObject)lazy.get()), id -> () -> this.get((class_2960)id));
    }

    private SerializableDataType<T> createDataType() {
        return new SerializableDataType<DataObject>(this.objectClass, this::writeDataObject, this::receiveDataObject, this::readDataObject);
    }

    private SerializableDataType<T> createRegistryDataType() {
        return SerializableDataType.wrap(this.objectClass, SerializableDataTypes.IDENTIFIER, this::getId, this::get);
    }

    public static DataObjectRegistry<?> getRegistry(class_2960 registryId) {
        return REGISTRIES.get(registryId);
    }

    public static void performAutoSync(class_3222 player) {
        for (class_2960 registryId : AUTO_SYNC_SET) {
            DataObjectRegistry<?> registry = DataObjectRegistry.getRegistry(registryId);
            registry.sync(player);
        }
    }

    private class Loader
    extends MultiJsonDataLoader
    implements IdentifiableResourceReloadListener {
        private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        private static final HashMap<class_2960, Integer> LOADING_PRIORITIES = new HashMap();
        private final boolean useLoadingPriority;
        private final BiConsumer<class_2960, Exception> errorHandler;

        public Loader(String dataFolder, boolean useLoadingPriority, BiConsumer<class_2960, Exception> errorHandler) {
            super(GSON, dataFolder);
            this.useLoadingPriority = useLoadingPriority;
            this.errorHandler = errorHandler;
        }

        protected void apply(Map<class_2960, List<JsonElement>> data, class_3300 manager, class_3695 profiler) {
            DataObjectRegistry.this.clear();
            LOADING_PRIORITIES.clear();
            data.forEach((id, jel) -> {
                for (JsonElement je : jel) {
                    try {
                        SerializableData.CURRENT_NAMESPACE = id.method_12836();
                        SerializableData.CURRENT_PATH = id.method_12832();
                        JsonObject jo = je.getAsJsonObject();
                        Object t = DataObjectRegistry.this.readDataObject(je);
                        if (this.useLoadingPriority) {
                            int loadingPriority = class_3518.method_15282((JsonObject)jo, (String)"loading_priority", (int)0);
                            if (DataObjectRegistry.this.containsId((class_2960)id) && LOADING_PRIORITIES.get(id) >= loadingPriority) continue;
                            LOADING_PRIORITIES.put((class_2960)id, loadingPriority);
                            DataObjectRegistry.this.register((class_2960)id, t);
                            continue;
                        }
                        DataObjectRegistry.this.register((class_2960)id, t);
                    }
                    catch (Exception e) {
                        if (this.errorHandler == null) continue;
                        this.errorHandler.accept((class_2960)id, e);
                    }
                }
            });
        }

        public class_2960 getFabricId() {
            return DataObjectRegistry.this.registryId;
        }
    }

    public static class Builder<T extends DataObject<T>> {
        private final class_2960 registryId;
        private final Class<T> objectClass;
        private String factoryFieldName = "type";
        private boolean autoSync = false;
        private DataObjectFactory<T> defaultFactory;
        private Function<JsonElement, JsonElement> jsonPreprocessor;
        private String dataFolder;
        private boolean readFromData = false;
        private boolean useLoadingPriority;
        private BiConsumer<class_2960, Exception> errorHandler;

        public Builder(class_2960 registryId, Class<T> objectClass) {
            this.registryId = registryId;
            this.objectClass = objectClass;
            if (REGISTRIES.containsKey(registryId)) {
                throw new IllegalArgumentException("A data object registry with id \"" + registryId + "\" already exists.");
            }
        }

        public Builder<T> autoSync() {
            this.autoSync = true;
            return this;
        }

        public Builder<T> defaultFactory(DataObjectFactory<T> factory) {
            this.defaultFactory = factory;
            return this;
        }

        public Builder<T> jsonPreprocessor(Function<JsonElement, JsonElement> nonJsonObjectHandler) {
            this.jsonPreprocessor = nonJsonObjectHandler;
            return this;
        }

        public Builder<T> factoryFieldName(String factoryFieldName) {
            this.factoryFieldName = factoryFieldName;
            return this;
        }

        public Builder<T> readFromData(String dataFolder, boolean useLoadingPriority) {
            this.readFromData = true;
            this.dataFolder = dataFolder;
            this.useLoadingPriority = useLoadingPriority;
            return this;
        }

        public Builder<T> dataErrorHandler(BiConsumer<class_2960, Exception> handler) {
            this.errorHandler = handler;
            return this;
        }

        public DataObjectRegistry<T> buildAndRegister() {
            DataObjectRegistry<T> registry = this.readFromData ? new DataObjectRegistry<T>(this.registryId, this.objectClass, this.factoryFieldName, this.defaultFactory, this.jsonPreprocessor, this.dataFolder, this.useLoadingPriority, this.errorHandler) : new DataObjectRegistry<T>(this.registryId, this.objectClass, this.factoryFieldName, this.defaultFactory, this.jsonPreprocessor);
            REGISTRIES.put(this.registryId, registry);
            if (this.autoSync) {
                AUTO_SYNC_SET.add(this.registryId);
            }
            return registry;
        }
    }
}

