/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.calio.mixin.integration.connector;

import io.github.apace100.calio.screen.MissingConnectorModDependencyScreen;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_5250;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_442.class})
public class TitleScreenMixin {
    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void openScreen(CallbackInfo ci) {
        List<class_2561> errorText;
        if (FabricLoader.getInstance().isModLoaded("connectormod") && !(errorText = TitleScreenMixin.buildConnectorDependencyText()).isEmpty()) {
            String subtitle = errorText.size() == 1 ? "1 error has occurred during loading" : errorText.size() + " errors have occured during loading";
            class_310.method_1551().method_1507((class_437)new MissingConnectorModDependencyScreen(errorText, "Error loading mods", subtitle));
        }
    }

    @Unique
    private static List<class_2561> buildConnectorDependencyText() {
        ArrayList<class_2561> lines = new ArrayList<class_2561>();
        FabricLoader.getInstance().getAllMods().forEach(mod -> {
            String modId = mod.getMetadata().getId();
            CustomValue value = mod.getMetadata().getCustomValue("connector-depends");
            if (value != null && value.getType() == CustomValue.CvType.OBJECT) {
                CustomValue.CvObject obj = value.getAsObject();
                obj.forEach(customValueEntry -> {
                    String depId = (String)customValueEntry.getKey();
                    if (!FabricLoader.getInstance().isModLoaded(depId)) {
                        String version;
                        CustomValue depVal = (CustomValue)customValueEntry.getValue();
                        String displayName = null;
                        if (depVal.getType() == CustomValue.CvType.STRING) {
                            version = depVal.getAsString();
                        } else if (depVal.getType() == CustomValue.CvType.OBJECT) {
                            CustomValue.CvObject depObj = depVal.getAsObject();
                            String string = version = depObj.containsKey("version") ? depObj.get("version").getAsString() : "unknown";
                            if (depObj.containsKey("name")) {
                                displayName = depObj.get("name").getAsString();
                            }
                        } else {
                            version = "unknown";
                        }
                        class_5250 line = class_2561.method_43470((String)"Mod ").method_10852((class_2561)class_2561.method_43470((String)modId).method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" requires ")).method_10852((class_2561)class_2561.method_43470((String)depId).method_27692(class_124.field_1065));
                        if (displayName != null && !displayName.isEmpty()) {
                            line = line.method_10852((class_2561)class_2561.method_43470((String)(" (" + displayName + ")")).method_27692(class_124.field_1080));
                        }
                        line = line.method_10852((class_2561)class_2561.method_43470((String)(" " + version)).method_27692(class_124.field_1056));
                        lines.add((class_2561)line);
                    }
                });
            }
        });
        return lines;
    }
}

