/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.calio.data;

import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.internal.LazilyParsedNumber;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.apace100.calio.ClassUtil;
import io.github.apace100.calio.SerializationHelper;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.calio.util.ArgumentWrapper;
import io.github.apace100.calio.util.StatusEffectChance;
import io.github.apace100.calio.util.TagLike;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1310;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_151;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1887;
import net.minecraft.class_1927;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2203;
import net.minecraft.class_2248;
import net.minecraft.class_2259;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3445;
import net.minecraft.class_3448;
import net.minecraft.class_3518;
import net.minecraft.class_3611;
import net.minecraft.class_3959;
import net.minecraft.class_4174;
import net.minecraft.class_5321;
import net.minecraft.class_5636;
import net.minecraft.class_5712;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8110;

public final class SerializableDataTypes {
    public static final SerializableDataType<Integer> INT = new SerializableDataType<Integer>(Integer.class, class_2540::writeInt, class_2540::readInt, JsonElement::getAsInt);
    public static final SerializableDataType<List<Integer>> INTS = SerializableDataType.list(INT);
    public static final SerializableDataType<Boolean> BOOLEAN = new SerializableDataType<Boolean>(Boolean.class, class_2540::writeBoolean, class_2540::readBoolean, JsonElement::getAsBoolean);
    public static final SerializableDataType<Float> FLOAT = new SerializableDataType<Float>(Float.class, class_2540::writeFloat, class_2540::readFloat, JsonElement::getAsFloat);
    public static final SerializableDataType<List<Float>> FLOATS = SerializableDataType.list(FLOAT);
    public static final SerializableDataType<Double> DOUBLE = new SerializableDataType<Double>(Double.class, class_2540::writeDouble, class_2540::readDouble, JsonElement::getAsDouble);
    public static final SerializableDataType<List<Double>> DOUBLES = SerializableDataType.list(DOUBLE);
    public static final SerializableDataType<String> STRING = new SerializableDataType<String>(String.class, class_2540::method_10814, buf -> buf.method_10800(Short.MAX_VALUE), JsonElement::getAsString);
    public static final SerializableDataType<List<String>> STRINGS = SerializableDataType.list(STRING);
    public static final SerializableDataType<Number> NUMBER = new SerializableDataType<Number>(Number.class, (buf, number) -> {
        if (number instanceof Double) {
            buf.writeByte(0);
            buf.writeDouble(number.doubleValue());
        } else if (number instanceof Float) {
            buf.writeByte(1);
            buf.writeFloat(number.floatValue());
        } else if (number instanceof Integer) {
            buf.writeByte(2);
            buf.writeInt(number.intValue());
        } else if (number instanceof Long) {
            buf.writeByte(3);
            buf.writeLong(number.longValue());
        } else {
            buf.writeByte(4);
            buf.method_10814(number.toString());
        }
    }, buf -> {
        byte type = buf.readByte();
        switch (type) {
            case 0: {
                return buf.readDouble();
            }
            case 1: {
                return Float.valueOf(buf.readFloat());
            }
            case 2: {
                return buf.readInt();
            }
            case 3: {
                return buf.readLong();
            }
            case 4: {
                return new LazilyParsedNumber(buf.method_19772());
            }
        }
        throw new RuntimeException("Could not receive number, unexpected type id \"" + type + "\" (allowed range: [0-4])");
    }, je -> {
        if (je.isJsonPrimitive()) {
            JsonPrimitive primitive = je.getAsJsonPrimitive();
            if (primitive.isNumber()) {
                return primitive.getAsNumber();
            }
            if (primitive.isBoolean()) {
                return primitive.getAsBoolean() ? 1 : 0;
            }
        }
        throw new JsonParseException("Expected a primitive");
    });
    public static final SerializableDataType<List<Number>> NUMBERS = SerializableDataType.list(NUMBER);
    public static final SerializableDataType<class_243> VECTOR = new SerializableDataType<class_243>(class_243.class, (packetByteBuf, vector3d) -> {
        packetByteBuf.writeDouble(vector3d.field_1352);
        packetByteBuf.writeDouble(vector3d.field_1351);
        packetByteBuf.writeDouble(vector3d.field_1350);
    }, packetByteBuf -> new class_243(packetByteBuf.readDouble(), packetByteBuf.readDouble(), packetByteBuf.readDouble()), jsonElement -> {
        if (jsonElement.isJsonObject()) {
            JsonObject jo = jsonElement.getAsJsonObject();
            return new class_243(class_3518.method_34915((JsonObject)jo, (String)"x", (double)0.0), class_3518.method_34915((JsonObject)jo, (String)"y", (double)0.0), class_3518.method_34915((JsonObject)jo, (String)"z", (double)0.0));
        }
        throw new JsonParseException("Expected an object with x, y, and z fields.");
    });
    public static final SerializableDataType<class_2960> IDENTIFIER = new SerializableDataType<class_2960>(class_2960.class, class_2540::method_10812, class_2540::method_10810, json -> {
        Object idString = json.getAsString();
        if (((String)idString).contains(":")) {
            String[] idSplit = ((String)idString).split(":");
            if (idSplit.length != 2) {
                throw new class_151("Incorrect number of `:` in identifier: \"" + (String)idString + "\".");
            }
            if (idSplit[0].contains("*")) {
                if (SerializableData.CURRENT_NAMESPACE != null) {
                    idSplit[0] = idSplit[0].replace("*", SerializableData.CURRENT_NAMESPACE);
                } else {
                    throw new class_151("Identifier may not contain a `*` in the namespace when read here.");
                }
            }
            if (idSplit[1].contains("*")) {
                if (SerializableData.CURRENT_PATH != null) {
                    idSplit[1] = idSplit[1].replace("*", SerializableData.CURRENT_PATH);
                } else {
                    throw new class_151("Identifier may only contain a `*` in the path inside of powers.");
                }
            }
            idString = idSplit[0] + ":" + idSplit[1];
        } else if (((String)idString).contains("*")) {
            if (SerializableData.CURRENT_PATH != null) {
                idString = ((String)idString).replace("*", SerializableData.CURRENT_PATH);
            } else {
                throw new class_151("Identifier may only contain a `*` in the path inside of powers.");
            }
        }
        return new class_2960((String)idString);
    });
    public static final SerializableDataType<List<class_2960>> IDENTIFIERS = SerializableDataType.list(IDENTIFIER);
    public static final SerializableDataType<class_1887> ENCHANTMENT = SerializableDataType.registry(class_1887.class, class_7923.field_41176);
    public static SerializableDataType<class_5321<class_1937>> DIMENSION = SerializableDataType.registryKey(class_7924.field_41223);
    public static final SerializableDataType<class_1320> ATTRIBUTE = SerializableDataType.registry(class_1320.class, class_7923.field_41190);
    public static final SerializableDataType<class_1322.class_1323> MODIFIER_OPERATION = SerializableDataType.enumValue(class_1322.class_1323.class);
    public static final SerializableDataType<class_1322> ATTRIBUTE_MODIFIER = SerializableDataType.compound(class_1322.class, new SerializableData().add("name", STRING, "Unnamed attribute modifier").add("operation", MODIFIER_OPERATION).add("value", DOUBLE), data -> new class_1322(data.getString("name"), data.getDouble("value"), (class_1322.class_1323)data.get("operation")), (serializableData, modifier) -> {
        SerializableData.Instance inst = (SerializableData)serializableData.new SerializableData.Instance();
        inst.set("name", modifier.method_6185());
        inst.set("value", modifier.method_6186());
        inst.set("operation", modifier.method_6182());
        return inst;
    });
    public static final SerializableDataType<List<class_1322>> ATTRIBUTE_MODIFIERS = SerializableDataType.list(ATTRIBUTE_MODIFIER);
    public static final SerializableDataType<class_1792> ITEM = SerializableDataType.registry(class_1792.class, class_7923.field_41178);
    public static final SerializableDataType<class_1291> STATUS_EFFECT = SerializableDataType.registry(class_1291.class, class_7923.field_41174);
    public static final SerializableDataType<List<class_1291>> STATUS_EFFECTS = SerializableDataType.list(STATUS_EFFECT);
    public static final SerializableDataType<class_1293> STATUS_EFFECT_INSTANCE = new SerializableDataType<class_1293>(class_1293.class, SerializationHelper::writeStatusEffect, SerializationHelper::readStatusEffect, SerializationHelper::readStatusEffect);
    public static final SerializableDataType<List<class_1293>> STATUS_EFFECT_INSTANCES = SerializableDataType.list(STATUS_EFFECT_INSTANCE);
    public static final SerializableDataType<class_6862<class_1792>> ITEM_TAG = SerializableDataType.tag(class_7924.field_41197);
    public static final SerializableDataType<class_6862<class_3611>> FLUID_TAG = SerializableDataType.tag(class_7924.field_41270);
    public static final SerializableDataType<class_6862<class_2248>> BLOCK_TAG = SerializableDataType.tag(class_7924.field_41254);
    public static final SerializableDataType<class_6862<class_1299<?>>> ENTITY_TAG = SerializableDataType.tag(class_7924.field_41266);
    public static final SerializableDataType<class_1856.class_1859> INGREDIENT_ENTRY = SerializableDataType.compound(ClassUtil.castClass(class_1856.class_1859.class), new SerializableData().add("item", ITEM, null).add("tag", ITEM_TAG, null), dataInstance -> {
        boolean itemPresent;
        boolean tagPresent = dataInstance.isPresent("tag");
        if (tagPresent == (itemPresent = dataInstance.isPresent("item"))) {
            throw new JsonParseException("An ingredient entry is either a tag or an item, " + (tagPresent ? "not both" : "one has to be provided."));
        }
        if (tagPresent) {
            class_6862 tag = (class_6862)dataInstance.get("tag");
            return new class_1856.class_1858(tag);
        }
        return new class_1856.class_1857(new class_1799((class_1935)((class_1792)dataInstance.get("item"))));
    }, (data, entry) -> data.read(entry.method_8109()));
    public static final SerializableDataType<List<class_1856.class_1859>> INGREDIENT_ENTRIES = SerializableDataType.list(INGREDIENT_ENTRY);
    public static final SerializableDataType<class_1856> INGREDIENT = new SerializableDataType<class_1856>(class_1856.class, (buffer, ingredient) -> ingredient.method_8088(buffer), class_1856::method_8086, jsonElement -> {
        List<class_1856.class_1859> entryList = INGREDIENT_ENTRIES.read((JsonElement)jsonElement);
        return class_1856.method_8092(entryList.stream());
    });
    public static final SerializableDataType<class_1856> VANILLA_INGREDIENT = new SerializableDataType<class_1856>(class_1856.class, (buffer, ingredient) -> ingredient.method_8088(buffer), class_1856::method_8086, class_1856::method_52177);
    public static final SerializableDataType<class_2248> BLOCK = SerializableDataType.registry(class_2248.class, class_7923.field_41175);
    public static final SerializableDataType<class_2680> BLOCK_STATE = SerializableDataType.wrap(class_2680.class, STRING, class_2259::method_9685, string -> {
        try {
            return class_2259.method_41957((class_7225)class_7923.field_41175.method_46771(), (String)string, (boolean)false).comp_622();
        }
        catch (CommandSyntaxException e) {
            throw new JsonParseException((Throwable)e);
        }
    });
    public static final SerializableDataType<class_5321<class_8110>> DAMAGE_TYPE = SerializableDataType.registryKey(class_7924.field_42534);
    public static final SerializableDataType<class_1310> ENTITY_GROUP = SerializableDataType.mapped(class_1310.class, HashBiMap.create((Map)ImmutableMap.of((Object)"default", (Object)class_1310.field_6290, (Object)"undead", (Object)class_1310.field_6289, (Object)"arthropod", (Object)class_1310.field_6293, (Object)"illager", (Object)class_1310.field_6291, (Object)"aquatic", (Object)class_1310.field_6292)));
    public static final SerializableDataType<class_1304> EQUIPMENT_SLOT = SerializableDataType.enumValue(class_1304.class);
    public static final SerializableDataType<class_3414> SOUND_EVENT = SerializableDataType.registry(class_3414.class, class_7923.field_41172);
    public static final SerializableDataType<class_1299<?>> ENTITY_TYPE = SerializableDataType.registry(ClassUtil.castClass(class_1299.class), class_7923.field_41177);
    public static final SerializableDataType<class_2396<?>> PARTICLE_TYPE = SerializableDataType.registry(ClassUtil.castClass(class_2396.class), class_7923.field_41180);
    public static final SerializableDataType<class_2394> PARTICLE_EFFECT = SerializableDataType.compound(class_2394.class, new SerializableData().add("type", PARTICLE_TYPE).add("params", STRING, ""), dataInstance -> {
        class_2396 particleType = (class_2396)dataInstance.get("type");
        class_2394.class_2395 factory = particleType.method_10298();
        class_2394 effect = null;
        try {
            effect = factory.method_10296(particleType, new StringReader(" " + dataInstance.getString("params")));
        }
        catch (CommandSyntaxException e) {
            throw new RuntimeException(e);
        }
        return effect;
    }, (serializableData, particleEffect) -> {
        SerializableData.Instance data = (SerializableData)serializableData.new SerializableData.Instance();
        data.set("type", particleEffect.method_10295());
        String params = particleEffect.method_10293();
        int spaceIndex = params.indexOf(32);
        params = spaceIndex > -1 ? params.substring(spaceIndex + 1) : "";
        data.set("params", params);
        return data;
    });
    public static final SerializableDataType<class_2394> PARTICLE_EFFECT_OR_TYPE = new SerializableDataType<class_2394>(class_2394.class, PARTICLE_EFFECT::send, PARTICLE_EFFECT::receive, jsonElement -> {
        if (jsonElement.isJsonPrimitive() && jsonElement.getAsJsonPrimitive().isString()) {
            class_2396<?> type = PARTICLE_TYPE.read((JsonElement)jsonElement);
            if (type instanceof class_2394) {
                return (class_2394)type;
            }
            throw new RuntimeException("Expected either a string with a parameter-less particle effect, or an object.");
        }
        if (jsonElement.isJsonObject()) {
            return PARTICLE_EFFECT.read((JsonElement)jsonElement);
        }
        throw new RuntimeException("Expected either a string with a parameter-less particle effect, or an object.");
    });
    public static final SerializableDataType<class_2487> NBT = new SerializableDataType<class_2487>(class_2487.class, class_2540::method_10794, class_2540::method_10798, jsonElement -> {
        if (!(jsonElement.isJsonObject() || jsonElement.isJsonPrimitive() && jsonElement.getAsJsonPrimitive().isString())) {
            throw new JsonSyntaxException("Expected either a string or an object.");
        }
        try {
            String stringifiedJsonElement = jsonElement.isJsonObject() ? jsonElement.getAsJsonObject().toString() : jsonElement.getAsJsonPrimitive().getAsString();
            return new class_2522(new StringReader(stringifiedJsonElement)).method_10727();
        }
        catch (CommandSyntaxException e) {
            throw new JsonSyntaxException("Could not parse NBT: " + e.getMessage());
        }
    });
    public static final SerializableDataType<class_1799> ITEM_STACK = SerializableDataType.compound(class_1799.class, new SerializableData().add("item", ITEM).add("amount", INT, 1).add("tag", NBT, null), data -> {
        class_1799 stack = new class_1799((class_1935)((class_1792)data.get("item")), data.getInt("amount"));
        if (data.isPresent("tag")) {
            stack.method_7980((class_2487)data.get("tag"));
        }
        return stack;
    }, (serializableData, itemStack) -> {
        SerializableData.Instance data = (SerializableData)serializableData.new SerializableData.Instance();
        data.set("item", itemStack.method_7909());
        data.set("amount", itemStack.method_7947());
        data.set("tag", itemStack.method_7985() ? itemStack.method_7969() : null);
        return data;
    });
    public static final SerializableDataType<List<class_1799>> ITEM_STACKS = SerializableDataType.list(ITEM_STACK);
    public static final SerializableDataType<class_2561> TEXT = new SerializableDataType<class_2561>(class_2561.class, (buffer, text) -> buffer.method_10814(class_2561.class_2562.method_10867((class_2561)text)), buffer -> class_2561.class_2562.method_10877((String)buffer.method_10800(Short.MAX_VALUE)), class_2561.class_2562::method_10872);
    public static final SerializableDataType<List<class_2561>> TEXTS = SerializableDataType.list(TEXT);
    public static final SerializableDataType<class_1860> RECIPE = new SerializableDataType<class_1860>(class_1860.class, (buffer, recipe) -> {
        buffer.method_10812(class_7923.field_41189.method_10221((Object)recipe.method_8119()));
        buffer.method_10812(recipe.method_8114());
        recipe.method_8119().method_8124(buffer, recipe);
    }, buffer -> {
        class_2960 recipeSerializerId = buffer.method_10810();
        class_2960 recipeId = buffer.method_10810();
        class_1865 serializer = (class_1865)class_7923.field_41189.method_10223(recipeSerializerId);
        return serializer.method_8122(recipeId, buffer);
    }, jsonElement -> {
        if (!jsonElement.isJsonObject()) {
            throw new RuntimeException("Expected recipe to be a JSON object.");
        }
        JsonObject json = jsonElement.getAsJsonObject();
        class_2960 recipeSerializerId = class_2960.method_12829((String)class_3518.method_15265((JsonObject)json, (String)"type"));
        class_2960 recipeId = class_2960.method_12829((String)class_3518.method_15265((JsonObject)json, (String)"id"));
        class_1865 serializer = (class_1865)class_7923.field_41189.method_10223(recipeSerializerId);
        return serializer.method_8121(recipeId, json);
    });
    public static final SerializableDataType<class_5712> GAME_EVENT = SerializableDataType.registry(class_5712.class, class_7923.field_41171);
    public static final SerializableDataType<List<class_5712>> GAME_EVENTS = SerializableDataType.list(GAME_EVENT);
    public static final SerializableDataType<class_6862<class_5712>> GAME_EVENT_TAG = SerializableDataType.tag(class_7924.field_41273);
    public static final SerializableDataType<class_3611> FLUID = SerializableDataType.registry(class_3611.class, class_7923.field_41173);
    public static final SerializableDataType<class_5636> CAMERA_SUBMERSION_TYPE = SerializableDataType.enumValue(class_5636.class);
    public static final SerializableDataType<class_1268> HAND = SerializableDataType.enumValue(class_1268.class);
    public static final SerializableDataType<EnumSet<class_1268>> HAND_SET = SerializableDataType.enumSet(class_1268.class, HAND);
    public static final SerializableDataType<EnumSet<class_1304>> EQUIPMENT_SLOT_SET = SerializableDataType.enumSet(class_1304.class, EQUIPMENT_SLOT);
    public static final SerializableDataType<class_1269> ACTION_RESULT = SerializableDataType.enumValue(class_1269.class);
    public static final SerializableDataType<class_1839> USE_ACTION = SerializableDataType.enumValue(class_1839.class);
    public static final SerializableDataType<StatusEffectChance> STATUS_EFFECT_CHANCE = SerializableDataType.compound(StatusEffectChance.class, new SerializableData().add("effect", STATUS_EFFECT_INSTANCE).add("chance", FLOAT, Float.valueOf(1.0f)), data -> {
        StatusEffectChance sec = new StatusEffectChance();
        sec.statusEffectInstance = (class_1293)data.get("effect");
        sec.chance = data.getFloat("chance");
        return sec;
    }, (data, csei) -> {
        SerializableData.Instance inst = (SerializableData)data.new SerializableData.Instance();
        inst.set("effect", csei.statusEffectInstance);
        inst.set("chance", Float.valueOf(csei.chance));
        return inst;
    });
    public static final SerializableDataType<List<StatusEffectChance>> STATUS_EFFECT_CHANCES = SerializableDataType.list(STATUS_EFFECT_CHANCE);
    public static final SerializableDataType<class_4174> FOOD_COMPONENT = SerializableDataType.compound(class_4174.class, new SerializableData().add("hunger", INT).add("saturation", FLOAT).add("meat", BOOLEAN, false).add("always_edible", BOOLEAN, false).add("snack", BOOLEAN, false).add("effect", STATUS_EFFECT_CHANCE, null).add("effects", STATUS_EFFECT_CHANCES, null), data -> {
        class_4174.class_4175 builder = new class_4174.class_4175().method_19238(data.getInt("hunger")).method_19237(data.getFloat("saturation"));
        if (data.getBoolean("meat")) {
            builder.method_19236();
        }
        if (data.getBoolean("always_edible")) {
            builder.method_19240();
        }
        if (data.getBoolean("snack")) {
            builder.method_19241();
        }
        data.ifPresent("effect", sec -> builder.method_19239(sec.statusEffectInstance, sec.chance));
        data.ifPresent("effects", secs -> secs.forEach(sec -> builder.method_19239(sec.statusEffectInstance, sec.chance)));
        return builder.method_19242();
    }, (data, fc) -> {
        SerializableData.Instance inst = (SerializableData)data.new SerializableData.Instance();
        inst.set("hunger", fc.method_19230());
        inst.set("saturation", Float.valueOf(fc.method_19231()));
        inst.set("meat", fc.method_19232());
        inst.set("always_edible", fc.method_19233());
        inst.set("snack", fc.method_19234());
        inst.set("effect", null);
        LinkedList statusEffectChances = new LinkedList();
        fc.method_19235().forEach(pair -> {
            StatusEffectChance sec = new StatusEffectChance();
            sec.statusEffectInstance = (class_1293)pair.getFirst();
            sec.chance = ((Float)pair.getSecond()).floatValue();
            statusEffectChances.add(sec);
        });
        if (statusEffectChances.size() > 0) {
            inst.set("effects", statusEffectChances);
        } else {
            inst.set("effects", null);
        }
        return inst;
    });
    public static final SerializableDataType<class_2350> DIRECTION = SerializableDataType.enumValue(class_2350.class);
    public static final SerializableDataType<EnumSet<class_2350>> DIRECTION_SET = SerializableDataType.enumSet(class_2350.class, DIRECTION);
    public static final SerializableDataType<Class<?>> CLASS = SerializableDataType.wrap(ClassUtil.castClass(Class.class), STRING, Class::getName, str -> {
        try {
            return Class.forName(str);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Specified class does not exist: \"" + str + "\".");
        }
    });
    public static final SerializableDataType<class_3959.class_3960> SHAPE_TYPE = SerializableDataType.enumValue(class_3959.class_3960.class);
    public static final SerializableDataType<class_3959.class_242> FLUID_HANDLING = SerializableDataType.enumValue(class_3959.class_242.class);
    public static final SerializableDataType<class_1927.class_4179> DESTRUCTION_TYPE = SerializableDataType.enumValue(class_1927.class_4179.class);
    public static final SerializableDataType<class_2350.class_2351> AXIS = SerializableDataType.enumValue(class_2350.class_2351.class);
    public static final SerializableDataType<EnumSet<class_2350.class_2351>> AXIS_SET = SerializableDataType.enumSet(class_2350.class_2351.class, AXIS);
    public static final SerializableDataType<ArgumentWrapper<class_2203.class_2209>> NBT_PATH = SerializableDataType.argumentType(class_2203.method_9360());
    public static final SerializableDataType<class_3959.class_3960> RAYCAST_SHAPE_TYPE = SerializableDataType.enumValue(class_3959.class_3960.class);
    public static final SerializableDataType<class_3959.class_242> RAYCAST_FLUID_HANDLING = SerializableDataType.enumValue(class_3959.class_242.class);
    public static final SerializableDataType<class_3445<?>> STAT = SerializableDataType.compound(ClassUtil.castClass(class_3445.class), new SerializableData().add("type", SerializableDataType.registry(ClassUtil.castClass(class_3448.class), class_7923.field_41193)).add("id", IDENTIFIER), data -> {
        class_2960 statId;
        class_3448 statType = (class_3448)data.get("type");
        class_2378 statRegistry = statType.method_14959();
        if (statRegistry.method_10250(statId = (class_2960)data.get("id"))) {
            Object statObject = statRegistry.method_10223(statId);
            return statType.method_14956(statObject);
        }
        throw new IllegalArgumentException("Desired stat \"" + statId + "\" does not exist in stat type ");
    }, (data, stat) -> {
        SerializableData.Instance inst = (SerializableData)data.new SerializableData.Instance();
        inst.set("type", stat.method_14949());
        class_2378 reg = stat.method_14949().method_14959();
        class_2960 statId = reg.method_10221(stat.method_14951());
        inst.set("id", statId);
        return inst;
    });
    public static final SerializableDataType<class_6862<class_1959>> BIOME_TAG = SerializableDataType.tag(class_7924.field_41236);
    public static final SerializableDataType<TagLike<class_1792>> ITEM_TAG_LIKE = SerializableDataType.tagLike(class_7923.field_41178);
    public static final SerializableDataType<TagLike<class_2248>> BLOCK_TAG_LIKE = SerializableDataType.tagLike(class_7923.field_41175);
    public static final SerializableDataType<TagLike<class_1299<?>>> ENTITY_TYPE_TAG_LIKE = SerializableDataType.tagLike(class_7923.field_41177);
}

