/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.calio.data;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.apace100.calio.data.DataException;
import io.github.apace100.calio.data.SerializableDataType;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1322;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class SerializableData {
    public static String CURRENT_NAMESPACE;
    public static String CURRENT_PATH;
    private final LinkedHashMap<String, Field<?>> dataFields = new LinkedHashMap();

    public SerializableData add(String name, SerializableDataType<?> type) {
        this.dataFields.put(name, new Field(type));
        return this;
    }

    public <T> SerializableData add(String name, SerializableDataType<T> type, T defaultValue) {
        this.dataFields.put(name, new Field<T>(type, defaultValue));
        return this;
    }

    public <T> SerializableData addFunctionedDefault(String name, SerializableDataType<T> type, Function<Instance, T> defaultFunction) {
        this.dataFields.put(name, new Field<T>(type, defaultFunction));
        return this;
    }

    public void write(class_2540 buffer, Instance instance) {
        this.dataFields.forEach((name, field) -> {
            try {
                boolean isPresent;
                boolean bl = isPresent = instance.get((String)name) != null;
                if (field.hasDefault && field.defaultValue == null) {
                    buffer.writeBoolean(isPresent);
                }
                if (isPresent) {
                    field.dataType.send(buffer, instance.get((String)name));
                }
            }
            catch (DataException e) {
                throw e.prepend((String)name);
            }
            catch (Exception e) {
                throw new DataException(DataException.Phase.WRITING, (String)name, e);
            }
        });
    }

    public Instance read(class_2540 buffer) {
        Instance instance = new Instance();
        this.dataFields.forEach((name, field) -> {
            try {
                boolean isPresent = true;
                if (field.hasDefault && field.defaultValue == null) {
                    isPresent = buffer.readBoolean();
                }
                instance.set((String)name, isPresent ? field.dataType.receive(buffer) : null);
            }
            catch (DataException e) {
                throw e.prepend((String)name);
            }
            catch (Exception e) {
                throw new DataException(DataException.Phase.RECEIVING, (String)name, e);
            }
        });
        return instance;
    }

    public Instance read(JsonObject jsonObject) {
        Instance instance = new Instance();
        this.dataFields.forEach((name, field) -> {
            try {
                if (!jsonObject.has(name)) {
                    if (!field.hasDefault()) throw new JsonSyntaxException("JSON requires field: " + name);
                    instance.set((String)name, field.getDefault(instance));
                    return;
                } else {
                    instance.set((String)name, field.dataType.read(jsonObject.get(name)));
                }
                return;
            }
            catch (DataException e) {
                throw e.prepend((String)name);
            }
            catch (Exception e) {
                throw new DataException(DataException.Phase.READING, (String)name, e);
            }
        });
        return instance;
    }

    public SerializableData copy() {
        SerializableData copy = new SerializableData();
        copy.dataFields.putAll(this.dataFields);
        return copy;
    }

    public Iterable<String> getFieldNames() {
        return ImmutableSet.copyOf(this.dataFields.keySet());
    }

    public Field<?> getField(String fieldName) {
        if (!this.dataFields.containsKey(fieldName)) {
            throw new IllegalArgumentException("SerializableData contains no field with name \"" + fieldName + "\".");
        }
        return this.dataFields.get(fieldName);
    }

    public static class Field<T> {
        private final SerializableDataType<T> dataType;
        private final T defaultValue;
        private final Function<Instance, T> defaultFunction;
        private final boolean hasDefault;
        private final boolean hasDefaultFunction;

        public Field(SerializableDataType<T> dataType) {
            this.dataType = dataType;
            this.defaultValue = null;
            this.defaultFunction = null;
            this.hasDefault = false;
            this.hasDefaultFunction = false;
        }

        public Field(SerializableDataType<T> dataType, T defaultValue) {
            this.dataType = dataType;
            this.defaultValue = defaultValue;
            this.defaultFunction = null;
            this.hasDefault = true;
            this.hasDefaultFunction = false;
        }

        public Field(SerializableDataType<T> dataType, Function<Instance, T> defaultFunction) {
            this.dataType = dataType;
            this.defaultValue = null;
            this.defaultFunction = defaultFunction;
            this.hasDefault = false;
            this.hasDefaultFunction = true;
        }

        public boolean hasDefault() {
            return this.hasDefault || this.hasDefaultFunction;
        }

        public T getDefault(Instance dataInstance) {
            if (this.hasDefaultFunction) {
                return this.defaultFunction.apply(dataInstance);
            }
            if (this.hasDefault) {
                return this.defaultValue;
            }
            throw new IllegalStateException("Tried to access default value of serializable data entry, when no default was provided.");
        }

        public SerializableDataType<T> getDataType() {
            return this.dataType;
        }
    }

    public class Instance {
        private HashMap<String, Object> data = new HashMap();

        public boolean isPresent(String name) {
            if (SerializableData.this.dataFields.containsKey(name)) {
                Field<?> field = SerializableData.this.dataFields.get(name);
                if (field.hasDefault && field.defaultValue == null) {
                    return this.get(name) != null;
                }
            }
            return this.data.containsKey(name);
        }

        public <T> void ifPresent(String name, Consumer<T> consumer) {
            if (this.isPresent(name)) {
                T o;
                T t = o = this.get(name);
                consumer.accept(t);
            }
        }

        public void set(String name, Object value) {
            this.data.put(name, value);
        }

        public <T> T get(String name) {
            if (!this.data.containsKey(name)) {
                throw new RuntimeException("Tried to get field \"" + name + "\" from data, which did not exist.");
            }
            return (T)this.data.get(name);
        }

        public int getInt(String name) {
            return (Integer)this.get(name);
        }

        public boolean getBoolean(String name) {
            return (Boolean)this.get(name);
        }

        public float getFloat(String name) {
            return ((Float)this.get(name)).floatValue();
        }

        public double getDouble(String name) {
            return (Double)this.get(name);
        }

        public String getString(String name) {
            return (String)this.get(name);
        }

        public class_2960 getId(String name) {
            return (class_2960)this.get(name);
        }

        public class_1322 getModifier(String name) {
            return (class_1322)this.get(name);
        }
    }
}

