/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.mobtimizations;

import com.corosus.coroutil.util.CU;
import com.corosus.mobtimizations.MobtimizationEntityFields;
import com.corosus.mobtimizations.config.ConfigFeatures;
import com.corosus.mobtimizations.config.ConfigFeaturesCustomization;
import com.corosus.modconfig.ConfigMod;
import com.corosus.modconfig.IConfigCategory;
import com.mojang.logging.LogUtils;
import java.io.File;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import org.slf4j.Logger;

public class Mobtimizations {
    public static final String MODID = "mobtimizations";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static boolean modActive = true;
    public static boolean testSpawningActive = false;
    private static int cancels = 0;

    public Mobtimizations() {
        new File("./config/mobtimizations").mkdirs();
        ConfigMod.addConfigFile((String)MODID, (IConfigCategory)new ConfigFeatures());
        ConfigMod.addConfigFile((String)MODID, (IConfigCategory)new ConfigFeaturesCustomization());
    }

    public static int getCancels() {
        return cancels;
    }

    public static void incCancel() {
        if (++cancels == Integer.MAX_VALUE) {
            cancels = 0;
        }
    }

    public static boolean rollPercentChance(float percent) {
        if (percent == 0.0f) {
            return false;
        }
        return CU.rand().nextFloat() <= percent / 100.0f;
    }

    public static boolean canAvoidHazards(Mob mob) {
        if (!modActive) {
            return true;
        }
        if (ConfigFeatures.optimizationMonsterHazardAvoidingPathfollowing) {
            return !(mob instanceof Monster);
        }
        return true;
    }

    public static boolean canCrushEggs() {
        if (!modActive) {
            return true;
        }
        if (ConfigFeatures.optimizationZombieSearchAndDestroyTurtleEgg) {
            return Mobtimizations.rollPercentChance(ConfigFeaturesCustomization.zombieSearchAndDestroyTurtleEggPercentChance);
        }
        return true;
    }

    public static boolean canRecomputePath() {
        if (!modActive) {
            return true;
        }
        return !ConfigFeatures.optimizationMobRepathfinding;
    }

    public static boolean canVillageRaid() {
        if (!modActive) {
            return true;
        }
        if (ConfigFeatures.optimizationZombieVillageRaid) {
            return Mobtimizations.rollPercentChance(ConfigFeaturesCustomization.zombieVillageRaidPercentChance);
        }
        return true;
    }

    public static boolean canTarget(Mob mob) {
        if (!modActive) {
            return true;
        }
        if (ConfigFeatures.optimizationMobEnemyTargeting) {
            if (Mobtimizations.useReducedRates(mob)) {
                return Mobtimizations.rollPercentChance(ConfigFeaturesCustomization.mobEnemyTargetingReducedRatePercentChance);
            }
            return true;
        }
        return true;
    }

    public static boolean canWander(Mob mob) {
        if (!modActive) {
            return true;
        }
        if (ConfigFeatures.optimizationMobWandering) {
            if (!Mobtimizations.rollPercentChance(ConfigFeaturesCustomization.mobWanderingPercentChance)) {
                return false;
            }
            float multiplier = Mobtimizations.useReducedRates(mob) ? (float)ConfigFeaturesCustomization.mobWanderingReducedRateMultiplier : 1.0f;
            long lastWander = ((MobtimizationEntityFields)mob).getlastWanderTime();
            if ((float)lastWander + (float)ConfigFeaturesCustomization.mobWanderingDelay * multiplier > (float)mob.m_9236_().m_46467_()) {
                return false;
            }
            ((MobtimizationEntityFields)mob).setlastWanderTime(mob.m_9236_().m_46467_());
            return true;
        }
        return true;
    }

    public static boolean useReducedRates(Mob mob) {
        if (!ConfigFeatures.playerProximityReducedRate) {
            return false;
        }
        long lastPlayerScan = ((MobtimizationEntityFields)mob).getlastPlayerScanTime();
        if (lastPlayerScan + (long)ConfigFeaturesCustomization.playerProximityReducedRatePlayerScanRate > mob.m_9236_().m_46467_()) {
            return ((MobtimizationEntityFields)mob).isplayerInRange();
        }
        boolean playerInRangeBool = Mobtimizations.checkIfPlayerInRange(mob);
        ((MobtimizationEntityFields)mob).setplayerInRange(playerInRangeBool);
        ((MobtimizationEntityFields)mob).setlastPlayerScanTime(mob.m_9236_().m_46467_());
        return !playerInRangeBool;
    }

    private static boolean checkIfPlayerInRange(Mob mob) {
        for (Player player : mob.m_9236_().m_6907_()) {
            if (!(player.m_20280_((Entity)mob) < (double)(ConfigFeaturesCustomization.playerProximityReducedRateRangeCutoff * ConfigFeaturesCustomization.playerProximityReducedRateRangeCutoff))) continue;
            return true;
        }
        return false;
    }

    public static BlockPathTypes getBlockPathTypeStatic(BlockGetter p_77605_, BlockPos.MutableBlockPos p_77606_) {
        int i = p_77606_.m_123341_();
        int j = p_77606_.m_123342_();
        int k = p_77606_.m_123343_();
        BlockPathTypes blockpathtypes = WalkNodeEvaluator.m_77643_((BlockGetter)p_77605_, (BlockPos)p_77606_);
        if (blockpathtypes == BlockPathTypes.OPEN && j >= p_77605_.m_141937_() + 1) {
            BlockPathTypes blockpathtypes1 = WalkNodeEvaluator.m_77643_((BlockGetter)p_77605_, (BlockPos)p_77606_.m_122178_(i, j - 1, k));
            BlockPathTypes blockPathTypes = blockpathtypes = blockpathtypes1 != BlockPathTypes.WALKABLE && blockpathtypes1 != BlockPathTypes.OPEN && blockpathtypes1 != BlockPathTypes.WATER && blockpathtypes1 != BlockPathTypes.LAVA ? BlockPathTypes.WALKABLE : BlockPathTypes.OPEN;
            if (blockpathtypes1 == BlockPathTypes.DAMAGE_FIRE) {
                blockpathtypes = BlockPathTypes.DAMAGE_FIRE;
            }
            if (blockpathtypes1 == BlockPathTypes.DAMAGE_OTHER) {
                blockpathtypes = BlockPathTypes.DAMAGE_OTHER;
            }
            if (blockpathtypes1 == BlockPathTypes.STICKY_HONEY) {
                blockpathtypes = BlockPathTypes.STICKY_HONEY;
            }
            if (blockpathtypes1 == BlockPathTypes.POWDER_SNOW) {
                blockpathtypes = BlockPathTypes.DANGER_POWDER_SNOW;
            }
            if (blockpathtypes1 == BlockPathTypes.DAMAGE_CAUTIOUS) {
                blockpathtypes = BlockPathTypes.DAMAGE_CAUTIOUS;
            }
        }
        return blockpathtypes;
    }
}

