/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.gtbcs_geomancy_plus.entity.projectiles.resonate_pillar;

import com.gametechbc.gtbcs_geomancy_plus.util.GGParticleHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ResonatePillarParticleManager {
    private static final double PILLAR_WIDTH = 1.0;
    private static final double PILLAR_HEIGHT = 3.0;

    public static void playWaterfallCascade(Level level, Vec3 pillarPos, int age, double radiusMultiplier) {
        if (level.f_46443_) {
            int particlesPerTick = 4;
            for (int i = 0; i < particlesPerTick; ++i) {
                double startHeight = 3.2;
                double angle = level.f_46441_.m_188500_() * 2.0 * Math.PI;
                double baseRadius = (0.4 + level.f_46441_.m_188500_() * 0.3) * radiusMultiplier;
                double offsetX = Math.cos(angle) * baseRadius;
                double offsetZ = Math.sin(angle) * baseRadius;
                double fallProgress = ((double)age * 2.0 + (double)(i * 10)) % 80.0 / 80.0;
                double currentHeight = startHeight - fallProgress * 3.5;
                if (!(currentHeight > -0.3)) continue;
                double particleX = pillarPos.f_82479_ + offsetX;
                double particleY = pillarPos.f_82480_ + currentHeight;
                double particleZ = pillarPos.f_82481_ + offsetZ;
                double driftStrength = 0.01 / Math.max(radiusMultiplier, 1.0);
                double velocityX = -offsetX * driftStrength;
                double velocityY = -0.06;
                double velocityZ = -offsetZ * driftStrength;
                level.m_7106_(GGParticleHelper.PILLAR_GREEN_PASSIVE_ENCHANT, particleX, particleY, particleZ, velocityX, velocityY, velocityZ);
            }
        }
    }
}

