/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.gtbcs_geomancy_plus.entity.projectiles.chunker;

import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityFallingBlock;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import com.gametechbc.gtbcs_geomancy_plus.api.entity.IResonanceEntity;
import com.gametechbc.gtbcs_geomancy_plus.api.init.GGSchools;
import com.gametechbc.gtbcs_geomancy_plus.entity.projectiles.resonate_pillar.ResonatePillarEntity;
import com.gametechbc.gtbcs_geomancy_plus.init.GGEntities;
import com.gametechbc.gtbcs_geomancy_plus.init.GGSpells;
import com.gametechbc.spelllib.entity.misc.GSLScreenShakeEntity;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.entity.mobs.AntiMagicSusceptible;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ChunkerEntity
extends Entity
implements GeoEntity,
AntiMagicSusceptible,
IResonanceEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Float> DATA_DAMAGE = SynchedEntityData.m_135353_(ChunkerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> DATA_AGE = SynchedEntityData.m_135353_(ChunkerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_MAX_AGE = SynchedEntityData.m_135353_(ChunkerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private Vec3 lastPosition = Vec3.f_82478_;
    private int stuckCounter = 0;
    private int lastStuckCheck = 0;
    private UUID summonerUUID;
    private LivingEntity cachedSummoner;
    private final RawAnimation IDLE_ROLL_ANIMATION = RawAnimation.begin().thenLoop("idle_roll");
    private final AnimationController<ChunkerEntity> controller = new AnimationController((GeoAnimatable)this, "boulder_roll_controller", 0, this::animationPredicate);

    public ChunkerEntity(EntityType<? extends Entity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public ChunkerEntity(Level level, LivingEntity summoner) {
        this((EntityType<? extends Entity>)((EntityType)GGEntities.CHUNKER.get()), level);
        this.setSummoner(summoner);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_DAMAGE, (Object)Float.valueOf(5.0f));
        this.f_19804_.m_135372_(DATA_AGE, (Object)0);
        this.f_19804_.m_135372_(DATA_MAX_AGE, (Object)110);
    }

    public void m_7380_(CompoundTag tag) {
        tag.m_128350_("Damage", this.getDamage());
        tag.m_128405_("Age", this.getAge());
        tag.m_128405_("MaxAge", this.getMaxAge());
        if (this.summonerUUID != null) {
            tag.m_128362_("Summoner", this.summonerUUID);
        }
    }

    public void m_7378_(CompoundTag tag) {
        if (tag.m_128441_("Age")) {
            this.setAge(tag.m_128451_("Age"));
        }
        if (tag.m_128441_("MaxAge")) {
            this.setMaxAge(tag.m_128451_("MaxAge"));
        }
        if (tag.m_128441_("Damage")) {
            this.setDamage(tag.m_128457_("Damage"));
        }
        if (tag.m_128403_("Summoner")) {
            this.summonerUUID = tag.m_128342_("Summoner");
        }
    }

    public int getAge() {
        return (Integer)this.f_19804_.m_135370_(DATA_AGE);
    }

    public void setAge(int age) {
        this.f_19804_.m_135381_(DATA_AGE, (Object)age);
    }

    public int getMaxAge() {
        return (Integer)this.f_19804_.m_135370_(DATA_MAX_AGE);
    }

    public void setMaxAge(int maxAge) {
        this.f_19804_.m_135381_(DATA_MAX_AGE, (Object)maxAge);
    }

    public void setDamage(float damage) {
        this.f_19804_.m_135381_(DATA_DAMAGE, (Object)Float.valueOf(damage));
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DATA_DAMAGE)).floatValue();
    }

    public void setSummoner(@Nullable LivingEntity owner) {
        if (owner != null) {
            this.summonerUUID = owner.m_20148_();
            this.cachedSummoner = owner;
        }
    }

    public LivingEntity getSummoner() {
        if (this.cachedSummoner != null && this.cachedSummoner.m_6084_()) {
            return this.cachedSummoner;
        }
        if (this.summonerUUID != null && this.m_9236_() instanceof ServerLevel) {
            Entity entity = ((ServerLevel)this.m_9236_()).m_8791_(this.summonerUUID);
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity;
                this.cachedSummoner = livingEntity = (LivingEntity)entity;
            }
            return this.cachedSummoner;
        }
        return null;
    }

    @Override
    public float getResonanceMultiplier() {
        return 0.8f;
    }

    @Override
    public void onResonanceShockwave(ResonatePillarEntity pillar, ResonatePillarEntity.Stage stage, LivingEntity owner, LivingEntity target, Level world, Vec3 resonancePosition, float resonanceRadius, double distanceFromSource, float baseDamage, float finalDamage) {
        IResonanceEntity.super.onResonanceShockwave(pillar, stage, owner, target, world, resonancePosition, resonanceRadius, distanceFromSource, baseDamage, finalDamage);
        Vec3 targetPosition = target.m_20182_();
        Vec3 pullDirection = resonancePosition.m_82546_(targetPosition).m_82541_();
        double maxPullStrength = 2.5;
        double stageReduction = 1.0 - (double)stage.value * 0.1;
        double distanceReduction = Math.max(0.3, 1.0 - distanceFromSource / (double)resonanceRadius);
        double pullStrength = maxPullStrength * stageReduction * distanceReduction;
        Vec3 pullMotion = new Vec3(pullDirection.f_82479_ * pullStrength, 0.2 + pullStrength * 0.1, pullDirection.f_82481_ * pullStrength);
        Vec3 currentMotion = target.m_20184_();
        target.m_20256_(currentMotion.m_82549_(pullMotion));
        target.f_19864_ = true;
    }

    @Override
    public boolean canResonateWith(ResonatePillarEntity pillar) {
        LivingEntity pillarOwner = pillar.getSummoner();
        LivingEntity thisOwner = this.getSummoner();
        return pillarOwner != null && thisOwner != null && pillarOwner.m_20148_().equals(thisOwner.m_20148_());
    }

    @Override
    public Vector3f getResonanceParticleColor() {
        return ((SchoolType)GGSchools.GEO.get()).getTargetingColor();
    }

    public void m_8119_() {
        super.m_8119_();
        int currentAge = this.getAge();
        this.setAge(currentAge + 1);
        int age = this.getAge();
        int maxAge = this.getMaxAge();
        float forwardSpeed = 0.25f;
        Vec3 forward = this.m_20154_().m_82541_().m_82490_((double)forwardSpeed);
        double currentY = this.m_20184_().f_82480_;
        double newY = this.applyCustomGravityWithAntiStuck(currentY);
        this.m_20334_(forward.f_82479_, newY, forward.f_82481_);
        this.f_19812_ = true;
        this.m_6478_(MoverType.SELF, this.m_20184_());
        if (!this.m_9236_().f_46443_ && this.f_19797_ % 3 == 0) {
            LivingEntity owner = this.getSummoner();
            AABB boundingBox = this.m_20191_();
            this.m_9236_().m_45976_(LivingEntity.class, boundingBox).stream().filter(entity -> entity.m_6084_() && entity.m_19879_() != this.m_19879_() && entity != owner).filter(entity -> owner == null || !this.isAlly(owner, (LivingEntity)entity) && !this.isTamed((LivingEntity)entity)).forEach(entity -> {
                DamageSources.applyDamage((Entity)entity, (float)this.getDamage(), (DamageSource)((AbstractSpell)GGSpells.CHUNKER_SPELL.get()).getDamageSource((Entity)this, (Entity)owner));
                Vec3 knockbackDirection = entity.m_20182_().m_82546_(this.m_20182_()).m_82541_();
                double knockbackStrength = 1.2;
                entity.m_20256_(entity.m_20184_().m_82520_(knockbackDirection.f_82479_ * knockbackStrength, 0.3, knockbackDirection.f_82481_ * knockbackStrength));
                entity.f_19812_ = true;
            });
        }
        if (!this.m_9236_().f_46443_) {
            this.spawnTrailParticles();
            if (this.f_19797_ == 1 || this.f_19797_ % 60 == 0) {
                this.m_5496_((SoundEvent)MMSounds.EFFECT_GEOMANCY_RUMBLE_LOOP.get(), 2.0f, 1.0f);
            }
        }
        if (!this.m_9236_().f_46443_ && this.f_19797_ % 5 == 0) {
            GSLScreenShakeEntity.createScreenShake((Level)this.m_9236_(), (Vec3)this.m_20182_(), (float)10.0f, (float)0.008f, (int)4, (int)0, (int)2, (boolean)true);
        }
        if (age >= maxAge) {
            this.m_5496_((SoundEvent)MMSounds.EFFECT_GEOMANCY_BREAK_LARGE_1.get(), 4.0f, 1.0f);
            if (!this.m_9236_().f_46443_) {
                this.spawnDiscardBlast();
                GSLScreenShakeEntity.createScreenShake((Level)this.m_9236_(), (Vec3)this.m_20182_(), (float)10.0f, (float)0.025f, (int)10, (int)0, (int)5, (boolean)false);
                this.spawnFallingBlockBlast();
            }
            this.m_146870_();
        }
    }

    private double applyCustomGravityWithAntiStuck(double currentY) {
        boolean isStuck = this.checkIfStuck();
        double distanceToGround = this.getDistanceToGround();
        if (isStuck && distanceToGround <= 2.0) {
            double upwardBoost = 0.15 + (double)this.stuckCounter * 0.02;
            return Math.min(currentY + upwardBoost, 0.4);
        }
        if (distanceToGround <= 0.5) {
            if (currentY < -0.1) {
                return Math.max(currentY * 0.8, -0.05);
            }
            if (currentY > 0.1) {
                return Math.min(currentY * 0.8, 0.05);
            }
            return currentY * 0.9;
        }
        double gravity = -0.08;
        double terminalVelocity = -2.0;
        double newY = currentY + gravity;
        return Math.max(newY, terminalVelocity);
    }

    private boolean checkIfStuck() {
        double expectedMovement;
        if (this.f_19797_ - this.lastStuckCheck < 2) {
            return this.stuckCounter > 0;
        }
        this.lastStuckCheck = this.f_19797_;
        Vec3 currentPos = this.m_20182_();
        double horizontalMovement = Math.sqrt(Math.pow(currentPos.f_82479_ - this.lastPosition.f_82479_, 2.0) + Math.pow(currentPos.f_82481_ - this.lastPosition.f_82481_, 2.0));
        if (horizontalMovement < (expectedMovement = 0.35)) {
            ++this.stuckCounter;
            if (this.hasBlockInFront()) {
                this.stuckCounter += 2;
            }
        } else {
            this.stuckCounter = Math.max(0, this.stuckCounter - 2);
        }
        this.lastPosition = currentPos;
        this.stuckCounter = Math.min(this.stuckCounter, 15);
        return this.stuckCounter > 3;
    }

    private boolean hasBlockInFront() {
        Vec3 lookDirection = this.m_20154_();
        Vec3 checkPos = this.m_20182_().m_82549_(lookDirection.m_82490_(1.0));
        BlockPos blockPos = BlockPos.m_274446_((Position)checkPos);
        BlockState blockState = this.m_9236_().m_8055_(blockPos);
        return !blockState.m_60795_() && blockState.m_60804_((BlockGetter)this.m_9236_(), blockPos);
    }

    private double getDistanceToGround() {
        BlockPos entityPos = this.m_20183_();
        Level level = this.m_9236_();
        for (int y = 0; y <= 3; ++y) {
            BlockPos checkPos = entityPos.m_6625_(y);
            BlockState blockState = level.m_8055_(checkPos);
            if (blockState.m_60795_() || !blockState.m_60804_((BlockGetter)level, checkPos)) continue;
            double blockTop = (double)checkPos.m_123342_() + 1.0;
            double entityBottom = this.m_20186_();
            return Math.max(0.0, entityBottom - blockTop);
        }
        return 4.0;
    }

    private void spawnTrailParticles() {
        double d5;
        double d4;
        double d3;
        double d2;
        double d1;
        double d0;
        AABB boundingBox = this.m_20191_();
        Vec3 velocity = this.m_20184_();
        int dirtParticleCount = 5 + this.f_19796_.m_188503_(3);
        for (int i = 0; i < dirtParticleCount; ++i) {
            double d02 = boundingBox.f_82288_ + (boundingBox.f_82291_ - boundingBox.f_82288_) * this.f_19796_.m_188500_();
            double d12 = boundingBox.f_82289_ + (boundingBox.f_82292_ - boundingBox.f_82289_) * 0.3;
            double d22 = boundingBox.f_82290_ + (boundingBox.f_82293_ - boundingBox.f_82290_) * this.f_19796_.m_188500_();
            double d32 = -velocity.f_82479_ * 0.5 + (this.f_19796_.m_188500_() - 0.5) * 0.2;
            double d42 = this.f_19796_.m_188500_() * 0.1 + 0.02;
            double d52 = -velocity.f_82481_ * 0.5 + (this.f_19796_.m_188500_() - 0.5) * 0.2;
            MagicManager.spawnParticles((Level)this.m_9236_(), (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50493_.m_49966_()), (double)d02, (double)d12, (double)d22, (int)1, (double)d32, (double)d42, (double)d52, (double)0.0, (boolean)false);
        }
        int dustCount = 2 + this.f_19796_.m_188503_(2);
        for (int i = 0; i < dustCount; ++i) {
            double d03 = this.m_20185_() - velocity.f_82479_ * (1.0 + this.f_19796_.m_188500_()) + (this.f_19796_.m_188500_() - 0.5) * 1.5;
            double d13 = boundingBox.f_82289_ + 0.1 + this.f_19796_.m_188500_() * 0.5;
            double d23 = this.m_20189_() - velocity.f_82481_ * (1.0 + this.f_19796_.m_188500_()) + (this.f_19796_.m_188500_() - 0.5) * 1.5;
            double d33 = (this.f_19796_.m_188500_() - 0.5) * 0.03;
            double d43 = this.f_19796_.m_188500_() * 0.02 + 0.01;
            double d53 = (this.f_19796_.m_188500_() - 0.5) * 0.03;
            MagicManager.spawnParticles((Level)this.m_9236_(), (ParticleOptions)ParticleTypes.f_123759_, (double)d03, (double)d13, (double)d23, (int)1, (double)d33, (double)d43, (double)d53, (double)0.0, (boolean)false);
        }
        if (this.f_19797_ % 2 == 0) {
            int impactCount = 3 + this.f_19796_.m_188503_(2);
            for (int i = 0; i < impactCount; ++i) {
                d0 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * (boundingBox.f_82291_ - boundingBox.f_82288_);
                d1 = boundingBox.f_82289_ - 0.1;
                d2 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * (boundingBox.f_82293_ - boundingBox.f_82290_);
                d3 = (this.f_19796_.m_188500_() - 0.5) * 0.15;
                d4 = this.f_19796_.m_188500_() * 0.08 + 0.02;
                d5 = (this.f_19796_.m_188500_() - 0.5) * 0.15;
                MagicManager.spawnParticles((Level)this.m_9236_(), (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50129_.m_49966_()), (double)d0, (double)d1, (double)d2, (int)1, (double)d3, (double)d4, (double)d5, (double)0.0, (boolean)false);
            }
        }
        if (this.f_19797_ % 2 == 0) {
            int stoneCount = 3 + this.f_19796_.m_188503_(2);
            for (int i = 0; i < stoneCount; ++i) {
                d0 = boundingBox.f_82288_ + (boundingBox.f_82291_ - boundingBox.f_82288_) * this.f_19796_.m_188500_();
                d1 = boundingBox.f_82289_ + (boundingBox.f_82292_ - boundingBox.f_82289_) * 0.4;
                d2 = boundingBox.f_82290_ + (boundingBox.f_82293_ - boundingBox.f_82290_) * this.f_19796_.m_188500_();
                d3 = -velocity.f_82479_ * 0.3 + (this.f_19796_.m_188500_() - 0.5) * 0.1;
                d4 = this.f_19796_.m_188500_() * 0.06 + 0.01;
                d5 = -velocity.f_82481_ * 0.3 + (this.f_19796_.m_188500_() - 0.5) * 0.1;
                BlockState stoneBlock = this.f_19796_.m_188499_() ? Blocks.f_50652_.m_49966_() : Blocks.f_49994_.m_49966_();
                MagicManager.spawnParticles((Level)this.m_9236_(), (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, stoneBlock), (double)d0, (double)d1, (double)d2, (int)1, (double)d3, (double)d4, (double)d5, (double)0.0, (boolean)false);
            }
        }
    }

    private void spawnDiscardBlast() {
        float blastRadius = 5.0f;
        for (int i = 0; i < 30; ++i) {
            double d0 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * (double)blastRadius * 2.0;
            double d1 = this.m_20186_() + this.f_19796_.m_188500_() * (double)blastRadius;
            double d2 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * (double)blastRadius * 2.0;
            double d3 = (this.f_19796_.m_188500_() - 0.5) * 0.5;
            double d4 = this.f_19796_.m_188500_() * 0.4 + 0.1;
            double d5 = (this.f_19796_.m_188500_() - 0.5) * 0.5;
            MagicManager.spawnParticles((Level)this.m_9236_(), (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50493_.m_49966_()), (double)d0, (double)d1, (double)d2, (int)1, (double)d3, (double)d4, (double)d5, (double)0.0, (boolean)false);
        }
    }

    private void spawnFallingBlockBlast() {
        AABB boundingBox = this.m_20191_();
        Vec3 center = boundingBox.m_82399_();
        int particleCount = 10;
        for (int i = 0; i < particleCount; ++i) {
            double d3 = (this.f_19796_.m_188500_() - 0.5) * 1.2;
            double d4 = this.f_19796_.m_188500_() + 0.3;
            double d5 = (this.f_19796_.m_188500_() - 0.5) * 1.2;
            int duration = 80 + this.f_19796_.m_188503_(41);
            EntityFallingBlock fallingBlock = new EntityFallingBlock((EntityType)EntityHandler.FALLING_BLOCK.get(), this.m_9236_(), duration, Blocks.f_50493_.m_49966_());
            fallingBlock.m_6034_(center.f_82479_, center.f_82480_, center.f_82481_);
            fallingBlock.m_20334_(d3, d4, d5);
            this.m_9236_().m_7967_((Entity)fallingBlock);
        }
    }

    public void onAntiMagic(MagicData playerMagicData) {
        this.m_146870_();
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_5829_() {
        return true;
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean m_20068_() {
        return false;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        return false;
    }

    private boolean isAlly(LivingEntity owner, LivingEntity target) {
        return owner.m_5647_() != null && owner.m_5647_().m_83536_(target.m_5647_());
    }

    private boolean isTamed(LivingEntity target) {
        if (target instanceof TamableAnimal) {
            TamableAnimal tamableAnimal = (TamableAnimal)target;
            return tamableAnimal.m_21824_();
        }
        return false;
    }

    private PlayState animationPredicate(AnimationState<ChunkerEntity> event) {
        event.getController().setAnimation(this.IDLE_ROLL_ANIMATION);
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{this.controller});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

