/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.gtbcs_geomancy_plus.effects;

import com.gametechbc.gtbcs_geomancy_plus.api.init.GGSchools;
import com.gametechbc.gtbcs_geomancy_plus.init.GGSpells;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class TremorStepEffect
extends MobEffect {
    private static final int TREMOR_INTERVAL_TICKS = 8;

    public TremorStepEffect() {
        super(MobEffectCategory.BENEFICIAL, 9127187);
        this.m_19472_(Attributes.f_22279_, "6320e690-8dad-4fc6-828b-e0ea75e521b3", 0.025, AttributeModifier.Operation.MULTIPLY_BASE);
    }

    public void m_6742_(LivingEntity livingEntity, int amplifier) {
        Player player;
        if (!livingEntity.m_9236_().f_46443_ && livingEntity instanceof Player && (player = (Player)livingEntity).m_20142_() && player.f_19797_ % 8 == 0) {
            this.triggerTremorShockwave(player, amplifier);
        }
    }

    private void triggerTremorShockwave(Player player, int amplifier) {
        Level level = player.m_9236_();
        double radius = 5.5;
        AABB boundingBox = new AABB(player.m_20185_() - radius, player.m_20186_() - radius, player.m_20189_() - radius, player.m_20185_() + radius, player.m_20186_() + radius, player.m_20189_() + radius);
        List nearbyEntities = level.m_6443_(LivingEntity.class, boundingBox, entity -> entity != player && (double)entity.m_20270_((Entity)player) <= radius);
        for (LivingEntity target : nearbyEntities) {
            if (!((float)amplifier > 0.0f)) continue;
            DamageSources.applyDamage((Entity)target, (float)amplifier, (DamageSource)((AbstractSpell)GGSpells.TREMOR_STEP_SPELL.get()).getDamageSource((Entity)player, (Entity)player));
            target.f_19802_ = 0;
        }
        MagicManager.spawnParticles((Level)level, (ParticleOptions)new BlastwaveParticleOptions(((SchoolType)GGSchools.GEO.get()).getTargetingColor(), (float)radius), (double)player.m_20185_(), (double)(player.m_20186_() + (double)0.165f), (double)player.m_20189_(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)false);
        this.spawnBlockDiggingParticles(level, player, radius);
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)SoundRegistry.EARTHQUAKE_IMPACT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    private void spawnBlockDiggingParticles(Level level, Player player, double radius) {
        RandomSource random = level.m_213780_();
        int particleCount = 35;
        block0: for (int i = 0; i < particleCount; ++i) {
            double angle = random.m_188500_() * Math.PI * 2.0;
            double distance = random.m_188500_() * radius;
            double x = player.m_20185_() + Math.cos(angle) * distance;
            double z = player.m_20189_() + Math.sin(angle) * distance;
            double y = player.m_20186_();
            BlockPos groundPos = new BlockPos((int)x, (int)y, (int)z);
            for (int j = 0; j < 3; ++j) {
                BlockPos checkPos = groundPos.m_6625_(j);
                BlockState groundBlock = level.m_8055_(checkPos);
                if (groundBlock.m_60795_() || groundBlock.m_60799_() == RenderShape.INVISIBLE) continue;
                double particleX = x + (random.m_188500_() * 2.0 - 1.0) * 0.5;
                double particleY = (double)checkPos.m_123342_() + 1.03;
                double particleZ = z + (random.m_188500_() * 2.0 - 1.0) * 0.5;
                double velocityX = random.m_188583_() * 0.07;
                double velocityY = Math.abs(random.m_188583_() * 0.1);
                double velocityZ = random.m_188583_() * 0.07;
                MagicManager.spawnParticles((Level)level, (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, groundBlock), (double)particleX, (double)particleY, (double)particleZ, (int)1, (double)velocityX, (double)velocityY, (double)velocityZ, (double)0.03, (boolean)false);
                continue block0;
            }
        }
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }
}

