/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.skill.bonus.item;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import daripher.skilltree.client.tooltip.TooltipHelper;
import daripher.skilltree.client.widget.editor.SkillTreeEditor;
import daripher.skilltree.init.PSTItemBonuses;
import daripher.skilltree.skill.bonus.item.ItemBonus;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public final class PotionDurationBonus
implements ItemBonus<PotionDurationBonus> {
    private float multiplier;

    public PotionDurationBonus(float multiplier) {
        this.multiplier = multiplier;
    }

    @Override
    public boolean canMerge(ItemBonus<?> other) {
        if (!(other instanceof PotionDurationBonus)) {
            return false;
        }
        PotionDurationBonus otherBonus = (PotionDurationBonus)other;
        return this.multiplier == otherBonus.multiplier;
    }

    @Override
    public PotionDurationBonus merge(ItemBonus<?> other) {
        if (!(other instanceof PotionDurationBonus)) {
            throw new IllegalArgumentException();
        }
        PotionDurationBonus otherBonus = (PotionDurationBonus)other;
        return new PotionDurationBonus(this.multiplier + otherBonus.multiplier);
    }

    @Override
    public PotionDurationBonus copy() {
        return new PotionDurationBonus(this.multiplier);
    }

    @Override
    public PotionDurationBonus multiply(double multiplier) {
        return new PotionDurationBonus((float)(multiplier * multiplier));
    }

    @Override
    public ItemBonus.Serializer getSerializer() {
        return (ItemBonus.Serializer)PSTItemBonuses.POTION_DURATION.get();
    }

    @Override
    public MutableComponent getTooltip() {
        return TooltipHelper.getSkillBonusTooltip(this.getDescriptionId(), (double)this.multiplier, AttributeModifier.Operation.MULTIPLY_BASE);
    }

    @Override
    public boolean isPositive() {
        return this.multiplier > 0.0f;
    }

    @Override
    public void addEditorWidgets(SkillTreeEditor editor, int index, Consumer<ItemBonus<?>> consumer) {
        editor.addLabel(0, 0, "Multiplier", ChatFormatting.GREEN);
        editor.increaseHeight(19);
        editor.addNumericTextField(0, 0, 50, 14, this.getMultiplier()).setNumericResponder(value -> this.selectMultiplier(consumer, (Double)value));
        editor.increaseHeight(19);
    }

    private void selectMultiplier(Consumer<ItemBonus<?>> consumer, Double value) {
        this.setMultiplier(value.floatValue());
        consumer.accept(this);
    }

    public void setMultiplier(float multiplier) {
        this.multiplier = multiplier;
    }

    public float getMultiplier() {
        return this.multiplier;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        PotionDurationBonus that = (PotionDurationBonus)obj;
        return Float.floatToIntBits(this.multiplier) == Float.floatToIntBits(that.multiplier);
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.multiplier));
    }

    public static class Serializer
    implements ItemBonus.Serializer {
        @Override
        public ItemBonus<?> deserialize(JsonObject json) throws JsonParseException {
            float multiplier = json.get("multiplier").getAsFloat();
            return new PotionDurationBonus(multiplier);
        }

        @Override
        public void serialize(JsonObject json, ItemBonus<?> bonus) {
            if (!(bonus instanceof PotionDurationBonus)) {
                throw new IllegalArgumentException();
            }
            PotionDurationBonus aBonus = (PotionDurationBonus)bonus;
            json.addProperty("multiplier", (Number)Float.valueOf(aBonus.multiplier));
        }

        @Override
        public ItemBonus<?> deserialize(CompoundTag tag) {
            float multiplier = tag.m_128457_("multiplier");
            return new PotionDurationBonus(multiplier);
        }

        @Override
        public CompoundTag serialize(ItemBonus<?> bonus) {
            if (!(bonus instanceof PotionDurationBonus)) {
                throw new IllegalArgumentException();
            }
            PotionDurationBonus aBonus = (PotionDurationBonus)bonus;
            CompoundTag tag = new CompoundTag();
            tag.m_128350_("multiplier", aBonus.multiplier);
            return tag;
        }

        @Override
        public ItemBonus<?> deserialize(FriendlyByteBuf buf) {
            return new PotionDurationBonus(buf.readFloat());
        }

        @Override
        public void serialize(FriendlyByteBuf buf, ItemBonus<?> bonus) {
            if (!(bonus instanceof PotionDurationBonus)) {
                throw new IllegalArgumentException();
            }
            PotionDurationBonus aBonus = (PotionDurationBonus)bonus;
            buf.writeFloat(aBonus.multiplier);
        }

        @Override
        public ItemBonus<?> createDefaultInstance() {
            return new PotionDurationBonus(0.1f);
        }
    }
}

