/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.client.widget.group;

import daripher.skilltree.client.widget.group.WidgetGroup;
import java.awt.geom.Rectangle2D;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import org.jetbrains.annotations.NotNull;

public class ScrollableZoomableWidgetGroup<T extends AbstractWidget>
extends WidgetGroup<T> {
    protected float scrollSpeedX;
    protected float scrollSpeedY;
    protected float scrollX;
    protected float scrollY;
    protected int maxScrollX;
    protected int maxScrollY;
    private float zoom = 1.0f;

    public ScrollableZoomableWidgetGroup(int pX, int pY, int pWidth, int pHeight) {
        super(pX, pY, pWidth, pHeight);
    }

    @Override
    protected void m_87963_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.updateScroll(partialTick);
        graphics.m_280588_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.m_5711_(), this.m_252907_() + this.m_93694_());
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(this.scrollX, this.scrollY, 0.0f);
        for (AbstractWidget widget : this.widgets) {
            graphics.m_280168_().m_85836_();
            double widgetCenterX = (float)widget.m_252754_() + (float)widget.m_5711_() / 2.0f;
            double widgetCenterY = (float)widget.m_252907_() + (float)widget.m_93694_() / 2.0f;
            graphics.m_280168_().m_85837_(widgetCenterX, widgetCenterY, 0.0);
            graphics.m_280168_().m_85841_(this.zoom, this.zoom, 1.0f);
            graphics.m_280168_().m_85837_(-widgetCenterX, -widgetCenterY, 0.0);
            widget.m_88315_(graphics, mouseX, mouseY, partialTick);
            graphics.m_280168_().m_85849_();
        }
        graphics.m_280168_().m_85849_();
        graphics.m_280618_();
    }

    @Override
    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (button != 2) {
            return false;
        }
        if (this.maxScrollX > 0) {
            this.scrollSpeedX += (float)(dragX * 0.25);
        }
        if (this.maxScrollY > 0) {
            this.scrollSpeedY += (float)(dragY * 0.25);
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    @Override
    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (delta > 0.0 && this.zoom < 2.0f) {
            this.zoom += 0.05f;
        }
        if (delta < 0.0 && this.zoom > 0.25f) {
            this.zoom -= 0.05f;
        }
        this.rebuildFunc.run();
        return true;
    }

    @Nullable
    public T getWidgetAt(double mouseX, double mouseY) {
        mouseX -= (double)this.scrollX;
        mouseY -= (double)this.scrollY;
        for (AbstractWidget widget : this.widgets) {
            Rectangle2D.Double widgetArea = this.getWidgetArea(widget);
            if (!widgetArea.contains(mouseX, mouseY)) continue;
            return (T)widget;
        }
        return null;
    }

    @NotNull
    protected Rectangle2D.Double getWidgetArea(T widget) {
        double width = (float)widget.m_5711_() * this.zoom;
        double height = (float)widget.m_93694_() * this.zoom;
        double x = (double)widget.m_252754_() + (double)widget.m_5711_() / 2.0 - width / 2.0;
        double y = (double)widget.m_252907_() + (double)widget.m_93694_() / 2.0 - height / 2.0;
        return new Rectangle2D.Double(x, y, width, height);
    }

    private void updateScroll(float partialTick) {
        this.scrollX += this.scrollSpeedX * partialTick;
        this.scrollX = Math.max((float)(-this.maxScrollX) * this.zoom, Math.min((float)this.maxScrollX * this.zoom, this.scrollX));
        this.scrollSpeedX *= 0.8f;
        this.scrollY += this.scrollSpeedY * partialTick;
        this.scrollY = Math.max((float)(-this.maxScrollY) * this.zoom, Math.min((float)this.maxScrollY * this.zoom, this.scrollY));
        this.scrollSpeedY *= 0.8f;
    }

    public void setMaxScrollX(int maxScrollX) {
        this.maxScrollX = maxScrollX;
    }

    public void setMaxScrollY(int maxScrollY) {
        this.maxScrollY = maxScrollY;
    }

    public int getMaxScrollX() {
        return this.maxScrollX;
    }

    public int getMaxScrollY() {
        return this.maxScrollY;
    }

    public float getScrollX() {
        return this.scrollX;
    }

    public float getScrollY() {
        return this.scrollY;
    }

    public float getZoom() {
        return this.zoom;
    }
}

