/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.client.hud;

import daripher.skilltree.item.ItemHelper;
import daripher.skilltree.item.quiver.QuiverItem;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;

@Mod.EventBusSubscriber(modid="skilltree", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public enum QuiverHud implements IGuiOverlay
{
    INSTANCE;

    private static final ResourceLocation WIDGETS_LOCATION;

    @SubscribeEvent
    public static void register(RegisterGuiOverlaysEvent event) {
        event.registerBelowAll("quiver_contents", (IGuiOverlay)INSTANCE);
    }

    public void render(ForgeGui gui, GuiGraphics graphics, float partialTick, int screenWidth, int screenHeight) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Objects.requireNonNull(player);
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(inv -> {
            Optional curio = inv.findFirstCurio(ItemHelper::isQuiver);
            if (curio.isEmpty()) {
                return;
            }
            ItemStack quiver = ((SlotResult)curio.get()).stack();
            if (quiver.m_41619_()) {
                return;
            }
            this.renderArrows(gui, graphics, partialTick, screenWidth, screenHeight, quiver, player);
        });
    }

    private void renderArrows(ForgeGui gui, GuiGraphics graphics, float partialTick, int screenWidth, int screenHeight, ItemStack quiver, LocalPlayer player) {
        int slotX;
        if (!QuiverItem.containsArrows(quiver)) {
            return;
        }
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        HumanoidArm offhand = player.m_5737_().m_20828_();
        int center = screenWidth / 2;
        ItemStack arrows = QuiverItem.getArrows(quiver);
        int slotY = screenHeight - 16 - 3;
        boolean hasOffhandItem = !player.m_21206_().m_41619_();
        int arrowsCount = QuiverItem.getArrowsCount(quiver);
        if (offhand == HumanoidArm.LEFT) {
            slotX = center - 91 - 29 - (hasOffhandItem ? 29 : 0);
            graphics.m_280218_(WIDGETS_LOCATION, slotX, screenHeight - 23, 24, 22, 29, 24);
        } else {
            slotX = center + 91 + (hasOffhandItem ? 29 : 0);
            graphics.m_280218_(WIDGETS_LOCATION, slotX, screenHeight - 23, 53, 22, 29, 24);
        }
        gui.setupOverlayRenderState(true, false);
        if (offhand == HumanoidArm.LEFT) {
            slotX = center - 91 - 29 - (hasOffhandItem ? 29 : 0);
            this.renderSlot(graphics, slotX + 3, slotY, partialTick, (Player)player, arrows, 1, arrowsCount);
        } else {
            slotX = center + 91 + (hasOffhandItem ? 29 : 0);
            this.renderSlot(graphics, slotX + 10, slotY, partialTick, (Player)player, arrows, 1, arrowsCount);
        }
    }

    private void renderSlot(GuiGraphics graphics, int x, int y, float partialTick, Player player, ItemStack stack, int seed, int count) {
        if (stack.m_41619_()) {
            return;
        }
        float f = (float)stack.m_41612_() - partialTick;
        if (f > 0.0f) {
            float f1 = 1.0f + f / 5.0f;
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_((float)(x + 8), (float)(y + 12), 0.0f);
            graphics.m_280168_().m_85841_(1.0f / f1, f1 / 2.0f + 0.5f, 1.0f);
            graphics.m_280168_().m_252880_((float)(-x - 8), (float)(-y - 12), 0.0f);
        }
        graphics.m_280638_((LivingEntity)player, stack, x, y, seed);
        if (f > 0.0f) {
            graphics.m_280168_().m_85849_();
        }
        graphics.m_280302_(Minecraft.m_91087_().f_91062_, stack, x, y, "" + count);
    }

    static {
        WIDGETS_LOCATION = new ResourceLocation("textures/gui/widgets.png");
    }
}

