/*
 * Decompiled with CFR 0.152.
 */
package zank.mods.fast_event;

import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import net.minecraftforge.eventbus.api.IEventListener;

public class EventListenerFactory {
    public static IEventListener createRawListener(MethodHandles.Lookup lookup, Method method, Object instance) {
        boolean isStatic = Modifier.isStatic(method.getModifiers());
        MethodHandle listenerFactory = EventListenerFactory.createListenerFactory(lookup, method, isStatic, instance);
        try {
            return isStatic ? listenerFactory.invokeExact() : listenerFactory.invokeExact(instance);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private static MethodHandle createListenerFactory(MethodHandles.Lookup lookup, Method callback, boolean isStatic, Object instance) {
        try {
            MethodHandle handle = lookup.unreflect(callback);
            MethodType factoryType = isStatic ? Constants.RETURNS_IT : Constants.RETURNS_IT.insertParameterTypes(0, instance.getClass());
            MethodHandle factoryHandle = LambdaMetafactory.metafactory(lookup, Constants.METHOD_NAME, factoryType, Constants.METHOD_TYPE, handle, MethodType.methodType(Void.TYPE, handle.type().parameterType(isStatic ? 0 : 1))).getTarget();
            return isStatic ? factoryHandle : factoryHandle.asType(factoryType.changeParameterType(0, Object.class));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static interface Constants {
        public static final Class<?> CLAZZ = IEventListener.class;
        public static final Method METHOD = CLAZZ.getMethods()[0];
        public static final String METHOD_NAME = METHOD.getName();
        public static final MethodType METHOD_TYPE = MethodType.methodType(METHOD.getReturnType(), METHOD.getParameterTypes());
        public static final MethodType RETURNS_IT = MethodType.methodType(CLAZZ);
    }
}

