/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.config.client.gui.structure;

import com.faboslav.structurify.common.config.StructurifyConfig;
import com.faboslav.structurify.common.config.data.StructureLikeData;
import com.faboslav.structurify.common.config.data.structure.OverlapCheckData;
import com.faboslav.structurify.common.util.LanguageUtil;
import dev.isxander.yacl3.api.LabelOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionAddable;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public final class OverlapCheckOptions {
    public static void addOverlapCheckOptions(OptionAddable builder, StructurifyConfig config, String id) {
        Map<String, StructureLikeData> structureLikeData;
        String namespace;
        boolean isNamespace = !id.contains(":");
        boolean isEnabledForNamespace = config.getStructureNamespaceData().get(id.split(":")[0]).getOverlapCheckData().isExcludedFromOverlapPrevention();
        if (isNamespace) {
            namespace = id;
            structureLikeData = config.getStructureNamespaceData();
        } else {
            namespace = id.split(":")[0];
            structureLikeData = config.getStructureData();
        }
        OverlapCheckData overlapCheckData = ((StructureLikeData)structureLikeData.get(id)).getOverlapCheckData();
        MutableComponent title = Component.m_237115_((String)"gui.structurify.structures.overlap_check_group.title");
        if (isNamespace) {
            title = Component.m_237113_((String)("\u201e" + LanguageUtil.translateId(null, namespace).getString() + "\u201c ")).m_7220_((Component)title);
        }
        title = Component.m_237113_((String)"\n").m_7220_((Component)title);
        builder.option((Option)LabelOption.create((Component)title.m_130938_(style -> style.m_131136_(Boolean.valueOf(true)))));
        boolean isStructureOverlapPreventionEnabled = config.preventStructureOverlap;
        Option excludeFromOverlapPreventionOption = Option.createBuilder().name((Component)Component.m_237115_((String)"gui.structurify.structures.structure.exclude_from_overlap_prevention.title")).description(OptionDescription.of((Component[])new Component[]{Component.m_237110_((String)"gui.structurify.structures.structure.exclude_from_overlap_prevention.description", (Object[])new Object[]{namespace, id})})).available(isStructureOverlapPreventionEnabled && !isEnabledForNamespace).binding((Object)OverlapCheckData.IS_EXCLUDED_FROM_OVERLAP_PREVENTION_DEFAULT_VALUE, overlapCheckData::isExcludedFromOverlapPrevention, overlapCheckData::excludeFromOverlapPrevention).controller(opt -> ((BooleanControllerBuilder)BooleanControllerBuilder.create((Option)opt).formatValue(val -> val != false ? Component.m_237115_((String)"gui.structurify.label.yes") : Component.m_237115_((String)"gui.structurify.label.no"))).coloured(true)).build();
        builder.option(excludeFromOverlapPreventionOption);
    }
}

