/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.config.client.api.option;

import com.google.common.collect.ImmutableList;
import dev.isxander.yacl3.api.ListOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class InvisibleOptionGroup
implements OptionGroup {
    @NotNull
    private final Component name;
    @NotNull
    private final OptionDescription description;
    private final ImmutableList<? extends Option<?>> options;
    private final boolean collapsed;
    private final boolean isRoot;

    public InvisibleOptionGroup(@NotNull Component name, @NotNull OptionDescription description, ImmutableList<? extends Option<?>> options, boolean collapsed, boolean isRoot) {
        this.name = name;
        this.description = description;
        this.options = options;
        this.collapsed = collapsed;
        this.isRoot = isRoot;
    }

    public Component name() {
        return this.name;
    }

    public OptionDescription description() {
        return this.description;
    }

    @NotNull
    public Component tooltip() {
        return this.description.text();
    }

    @NotNull
    public ImmutableList<? extends Option<?>> options() {
        return this.options;
    }

    public boolean collapsed() {
        return this.collapsed;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    @ApiStatus.Internal
    public static final class Builder
    implements OptionGroup.Builder {
        private Component name = Component.m_237119_();
        private OptionDescription description = OptionDescription.EMPTY;
        private final List<Option<?>> options = new ArrayList();
        private boolean collapsed = false;

        public OptionGroup.Builder name(@NotNull Component component) {
            return this;
        }

        public OptionGroup.Builder description(@NotNull OptionDescription optionDescription) {
            return this;
        }

        public Builder option(@NotNull Option<?> option) {
            Validate.notNull(option, (String)"`option` must not be null", (Object[])new Object[0]);
            this.options.add(option);
            return this;
        }

        public Builder options(@NotNull Collection<? extends Option<?>> options) {
            Validate.notEmpty(options, (String)"`options` must not be empty", (Object[])new Object[0]);
            Stream<? extends Option<?>> var10000 = options.stream();
            Objects.requireNonNull(ListOption.class);
            this.options.addAll(options);
            return this;
        }

        public Builder collapsed(boolean collapsible) {
            this.collapsed = collapsible;
            return this;
        }

        public InvisibleOptionGroup build() {
            return new InvisibleOptionGroup(this.name, this.description, ImmutableList.copyOf(this.options), this.collapsed, true);
        }
    }
}

