/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particle_effects.mixin;

import com.leclowndu93150.particle_effects.config.ParticleEffectsConfig;
import com.leclowndu93150.particle_effects.manager.ClientHandler;
import com.leclowndu93150.particle_effects.manager.ParticleEffectsManager;
import com.leclowndu93150.particle_effects.utils.ArgbUtils;
import com.leclowndu93150.particle_effects.utils.ListUtils;
import com.leclowndu93150.particle_effects.utils.PEType;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Debug(export=true)
@Mixin(value={LevelRenderer.class})
public class WorldRendererMixin {
    @Shadow
    @Nullable
    private ClientLevel f_109465_;

    @Inject(method={"levelEvent"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/phys/Vec3;atBottomCenterOf(Lnet/minecraft/core/Vec3i;)Lnet/minecraft/world/phys/Vec3;")})
    private void modifyParticleEffect(int eventId, BlockPos pos, int data, CallbackInfo ci, @Share(value="tp_effects") LocalRef<List<ParticleOptions>> localParticleEffects) {
        ClientHandler.processSplashPotionStageOne(localParticleEffects, data);
    }

    @WrapOperation(method={"levelEvent"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;addParticleInternal(Lnet/minecraft/core/particles/ParticleOptions;ZDDDDDD)Lnet/minecraft/client/particle/Particle;", ordinal=0)})
    private Particle swapParticles(LevelRenderer instance, ParticleOptions parameters, boolean alwaysSpawn, double x, double y, double z, double velocityX, double velocityY, double velocityZ, Operation<Particle> original, @Share(value="tp_effects") LocalRef<List<ParticleOptions>> localParticleEffects, @Local(argsOnly=true, ordinal=1) int color) {
        return ClientHandler.processSplashPotionStageTwo((Level)this.f_109465_, instance, parameters, alwaysSpawn, x, y, z, velocityX, velocityY, velocityZ, original, localParticleEffects, color);
    }

    @WrapOperation(method={"addParticle(Lnet/minecraft/core/particles/ParticleOptions;ZZDDDDDD)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;addParticleInternal(Lnet/minecraft/core/particles/ParticleOptions;ZZDDDDDD)Lnet/minecraft/client/particle/Particle;")})
    private Particle swapParticle(LevelRenderer instance, ParticleOptions parameters, boolean alwaysSpawn, boolean canSpawnOnMinimal, double x, double y, double z, double velocityX, double velocityY, double velocityZ, Operation<Particle> original) {
        if (!((Boolean)ParticleEffectsConfig.CLIENT.modEnabled.get()).booleanValue()) {
            return (Particle)original.call(new Object[]{instance, parameters, alwaysSpawn, canSpawnOnMinimal, x, y, z, velocityX, velocityY, velocityZ});
        }
        boolean bl = parameters.equals(ParticleTypes.f_123811_);
        boolean bl2 = parameters.equals(ParticleTypes.f_123770_);
        if (!bl && !bl2) {
            return (Particle)original.call(new Object[]{instance, parameters, alwaysSpawn, canSpawnOnMinimal, x, y, z, velocityX, velocityY, velocityZ});
        }
        int color = ArgbUtils.getArgb(bl2 ? 38 : 255, (int)(velocityX * 255.0), (int)(velocityY * 255.0), (int)(velocityZ * 255.0));
        List<ParticleOptions> list = ParticleEffectsManager.getParticleEffects(ArgbUtils.getColorWithoutAlpha(color));
        if (list == null || this.f_109465_ == null) {
            return (Particle)original.call(new Object[]{instance, parameters, alwaysSpawn, canSpawnOnMinimal, x, y, z, velocityX, velocityY, velocityZ});
        }
        ParticleOptions particleEffect = ListUtils.getRandomElement(list, this.f_109465_.m_213780_());
        if (particleEffect == null) {
            return (Particle)original.call(new Object[]{instance, parameters, alwaysSpawn, canSpawnOnMinimal, x, y, z, velocityX, velocityY, velocityZ});
        }
        ((PEType)particleEffect).particleEffects$setColor(color);
        return (Particle)original.call(new Object[]{instance, particleEffect, alwaysSpawn, canSpawnOnMinimal, x, y, z, velocityX, velocityY, velocityZ});
    }
}

