/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.spruceui.widget;

import dev.lambdaurora.spruceui.Position;
import dev.lambdaurora.spruceui.Tooltip;
import dev.lambdaurora.spruceui.Tooltipable;
import dev.lambdaurora.spruceui.border.Border;
import dev.lambdaurora.spruceui.border.EmptyBorder;
import dev.lambdaurora.spruceui.widget.AbstractSpruceWidget;
import dev.lambdaurora.spruceui.widget.WithBorder;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;

public class SpruceLabelWidget
extends AbstractSpruceWidget
implements Tooltipable,
WithBorder {
    public static final Consumer<SpruceLabelWidget> DEFAULT_ACTION = label -> {};
    private final Consumer<SpruceLabelWidget> action;
    private final int maxWidth;
    private int baseX;
    private Component text;
    private List<FormattedCharSequence> lines;
    private Component tooltip;
    private boolean centered;
    private Border border = EmptyBorder.EMPTY_BORDER;

    public SpruceLabelWidget(Position position, Component text, int maxWidth, Consumer<SpruceLabelWidget> action, boolean centered) {
        super(position);
        this.maxWidth = maxWidth;
        this.baseX = position.getRelativeX();
        this.action = action;
        this.centered = centered;
        this.setText(text);
    }

    public SpruceLabelWidget(Position position, Component text, int maxWidth, Consumer<SpruceLabelWidget> action) {
        this(position, text, maxWidth, action, false);
    }

    public SpruceLabelWidget(Position position, Component text, int maxWidth, boolean centered) {
        this(position, text, maxWidth, DEFAULT_ACTION, centered);
    }

    public SpruceLabelWidget(Position position, Component text, int maxWidth) {
        this(position, text, maxWidth, DEFAULT_ACTION);
    }

    private int getInnerX() {
        return this.getPosition().getAnchor().getX() + this.baseX;
    }

    public Component getText() {
        return this.text;
    }

    public void setText(Component text) {
        this.text = text;
        this.lines = this.client.f_91062_.m_92923_((FormattedText)text, this.maxWidth);
        int width = this.lines.stream().mapToInt(arg_0 -> ((Font)this.client.f_91062_).m_92724_(arg_0)).max().orElse(this.maxWidth);
        if (width > this.maxWidth) {
            width = this.maxWidth;
        }
        if (this.isCentered()) {
            this.position.setRelativeX(this.baseX + this.maxWidth / 2 - width / 2);
        } else {
            this.position.setRelativeX(this.baseX);
        }
        this.width = width;
        int n = this.lines.size();
        Objects.requireNonNull(this.client.f_91062_);
        this.height = n * 9 + 2;
    }

    public boolean isCentered() {
        return this.centered;
    }

    public void setCentered(boolean centered) {
        this.centered = centered;
    }

    @Override
    public Optional<Component> getTooltip() {
        return Optional.ofNullable(this.tooltip);
    }

    @Override
    public void setTooltip(@Nullable Component tooltip) {
        this.tooltip = tooltip;
    }

    @Override
    public Border getBorder() {
        return this.border;
    }

    @Override
    public void setBorder(Border border) {
        this.border = border;
    }

    public void onPress() {
        this.action.accept(this);
    }

    @Override
    public boolean requiresCursor() {
        return this.action == DEFAULT_ACTION;
    }

    @Override
    protected boolean onMouseClick(double mouseX, double mouseY, int button) {
        if (button == 0 && this.hovered) {
            this.onPress();
            return true;
        }
        return false;
    }

    @Override
    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        int y = this.getY() + 2;
        for (FormattedCharSequence line : this.lines) {
            int x = this.centered ? this.getInnerX() + this.maxWidth / 2 - this.client.f_91062_.m_92724_(line) / 2 : this.getInnerX();
            graphics.m_280649_(this.client.f_91062_, line, x, y, 0xA0A0A0, true);
            y += 9;
        }
        this.getBorder().render(graphics, this, mouseX, mouseY, delta);
        if (this.tooltip != null && !this.tooltip.getString().isEmpty()) {
            List wrappedTooltipText = this.client.f_91062_.m_92923_((FormattedText)this.tooltip, Math.max(this.width / 2, 200));
            if (this.hovered) {
                Tooltip.create(mouseX, mouseY, wrappedTooltipText).queue();
            } else if (this.focused) {
                Tooltip.create(this.getX() - 12, this.getY(), wrappedTooltipText).queue();
            }
        }
    }

    @Override
    protected Component getNarrationMessage() {
        return this.getText();
    }
}

