/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.spruceui.widget;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.lambdaurora.spruceui.Position;
import dev.lambdaurora.spruceui.widget.AbstractSpruceBooleanButtonWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;

public class SpruceCheckboxWidget
extends AbstractSpruceBooleanButtonWidget {
    private static final ResourceLocation TEXTURE = new ResourceLocation("spruceui", "textures/gui/checkbox.png");
    private boolean showCross = false;
    private boolean colored = false;

    public SpruceCheckboxWidget(Position position, int width, int height, Component message, boolean value) {
        super(position, width, height, message, value);
    }

    public SpruceCheckboxWidget(Position position, int width, int height, Component message, boolean value, boolean showMessage) {
        super(position, width, height, message, value, showMessage);
    }

    public SpruceCheckboxWidget(Position position, int width, int height, Component message, AbstractSpruceBooleanButtonWidget.PressAction action, boolean value) {
        super(position, width, height, message, action, value);
    }

    public SpruceCheckboxWidget(Position position, int width, int height, Component message, AbstractSpruceBooleanButtonWidget.PressAction action, boolean value, boolean showMessage) {
        super(position, width, height, message, action, value, showMessage);
    }

    public boolean showCross() {
        return this.showCross;
    }

    public void setShowCross(boolean showCross) {
        this.showCross = showCross;
    }

    public boolean isColored() {
        return this.colored;
    }

    public void setColored(boolean colored) {
        this.colored = colored;
    }

    @Override
    protected void renderButton(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        if (this.getValue()) {
            if (this.colored) {
                RenderSystem.setShaderColor((float)0.0f, (float)1.0f, (float)0.0f, (float)this.alpha);
            }
            graphics.m_280163_(TEXTURE, this.getX(), this.getY(), 0.0f, 40.0f, this.getHeight(), this.getHeight(), 64, 64);
        } else if (this.showCross) {
            if (this.colored) {
                RenderSystem.setShaderColor((float)1.0f, (float)0.0f, (float)0.0f, (float)this.alpha);
            }
            graphics.m_280163_(TEXTURE, this.getX(), this.getY(), 0.0f, 20.0f, this.getHeight(), this.getHeight(), 64, 64);
        }
        if (this.showMessage) {
            FormattedCharSequence message = Language.m_128107_().m_5536_(this.client.f_91062_.m_92854_((FormattedText)this.getMessage(), this.getWidth() - this.getHeight() - 4));
            graphics.m_280648_(Minecraft.m_91087_().f_91062_, message, this.getX() + this.getHeight() + 4, this.getY() + (this.getHeight() - 8) / 2, 0xE0E0E0 | Mth.m_14167_((float)(this.alpha * 255.0f)) << 24);
        }
    }

    @Override
    protected void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        graphics.m_280163_(TEXTURE, this.getX(), this.getY(), this.isFocusedOrHovered() ? 20.0f : 0.0f, 0.0f, this.getHeight(), this.getHeight(), 64, 64);
    }

    @Override
    protected Component getNarrationFocusedUsageMessage() {
        return Component.m_237115_((String)"narration.checkbox.usage.focused");
    }

    @Override
    protected Component getNarrationHoveredUsageMessage() {
        return Component.m_237115_((String)"narration.checkbox.usage.hovered");
    }
}

