/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.spruceui.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import org.jetbrains.annotations.Nullable;

public final class MultilineText {
    private final List<String> rows = new ArrayList<String>();
    private int width;

    public MultilineText(int width) {
        this.width = width;
    }

    public MultilineText(int width, @Nullable String text) {
        this(width);
        if (text == null) {
            return;
        }
        this.rows.addAll(MultilineText.wrap(text, width));
    }

    public MultilineText(int width, Collection<? extends String> lines) {
        this(width);
        this.rows.addAll(MultilineText.wrap(lines, width));
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        if (this.width != width) {
            this.width = width;
            this.recompute();
        }
    }

    public List<String> getRows() {
        return this.rows;
    }

    public List<String> getLines() {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        for (String row : this.rows) {
            stringBuilder.append(row.replace("\n", ""));
            if (!row.endsWith("\n")) continue;
            lines.add(stringBuilder.toString());
            stringBuilder = new StringBuilder();
        }
        return lines;
    }

    public void setLines(Collection<? extends String> lines) {
        this.clear();
        this.addAll(MultilineText.wrap(lines, this.width));
    }

    public String getText() {
        StringBuilder builder = new StringBuilder();
        for (String row : this.rows) {
            builder.append(row);
        }
        return builder.toString();
    }

    public void setText(String text) {
        this.clear();
        this.add(text);
    }

    public void recompute() {
        String text = this.getText();
        this.clear();
        this.add(text);
    }

    public boolean isEmpty() {
        return this.rows.isEmpty();
    }

    public int size() {
        return this.rows.size();
    }

    @Nullable
    public String get(int row) {
        return this.rows.get(row);
    }

    public void addAll(Collection<? extends String> lines) {
        this.rows.addAll(lines);
    }

    public void add(String line) {
        if (line.length() > 1) {
            this.rows.addAll(MultilineText.wrap(line, this.width));
        } else {
            this.rows.add(line);
        }
    }

    public void add(int row, String line) {
        this.rows.add(row, line);
    }

    @Nullable
    public String remove(int row) {
        if (row < 0 || row >= this.rows.size()) {
            return null;
        }
        return this.rows.remove(row);
    }

    public void replaceRow(int row, String line) {
        if (row < 0 || row >= this.rows.size()) {
            return;
        }
        this.remove(row);
        this.rows.add(row, line);
    }

    public void replaceRow(int row, Function<String, String> replacer) {
        if (row < 0 || row >= this.rows.size()) {
            return;
        }
        String line = this.get(row);
        this.replaceRow(row, replacer.apply(line));
    }

    public void clear() {
        this.rows.clear();
    }

    public static Collection<? extends String> wrap(String text, int width) {
        return MultilineText.wrap(Arrays.asList(text.split("\n")), width);
    }

    /*
     * WARNING - void declaration
     */
    public static Collection<? extends String> wrap(Collection<? extends String> text, int width) {
        Minecraft client = Minecraft.m_91087_();
        if (client == null) {
            return text;
        }
        ArrayList<Object> lines = new ArrayList<Object>();
        for (String string : text) {
            String part;
            void var5_5;
            if (string.equals("\n") || string.isEmpty()) {
                lines.add("\n");
                continue;
            }
            if (string.endsWith("\n")) {
                String string2 = string.substring(0, string.length() - 1);
            }
            while (!var5_5.isEmpty()) {
                part = client.f_91062_.m_92834_((String)var5_5, width);
                String string3 = var5_5.substring(part.length());
                lines.add(part);
            }
            part = (String)lines.remove(lines.size() - 1);
            lines.add(part + "\n");
        }
        return lines;
    }
}

