/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.spruceui.screen;

import dev.lambdaurora.spruceui.SprucePositioned;
import dev.lambdaurora.spruceui.Tooltip;
import dev.lambdaurora.spruceui.navigation.NavigationDirection;
import dev.lambdaurora.spruceui.util.ScissorManager;
import dev.lambdaurora.spruceui.widget.SpruceElement;
import dev.lambdaurora.spruceui.widget.SpruceWidget;
import java.util.List;
import java.util.ListIterator;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public abstract class SpruceHandledScreen<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T>
implements SprucePositioned,
SpruceElement {
    protected double scaleFactor;

    public SpruceHandledScreen(T handler, Inventory inventory, Component title) {
        super(handler, inventory, title);
    }

    public void m_7522_(GuiEventListener focused) {
        GuiEventListener old = this.m_7222_();
        if (old == focused) {
            return;
        }
        if (old instanceof SpruceWidget) {
            ((SpruceWidget)old).m_93692_(false);
        }
        super.m_7522_(focused);
        if (focused instanceof SpruceWidget) {
            ((SpruceWidget)focused).m_93692_(true);
        }
    }

    protected void m_7856_() {
        this.scaleFactor = this.f_96541_.m_91268_().m_85449_();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        return super.m_7933_(keyCode, scanCode, modifiers) || NavigationDirection.fromKey(keyCode, Screen.m_96638_()).map(dir -> this.onNavigation((NavigationDirection)((Object)dir), keyCode == 258)).orElseGet(() -> super.m_7933_(keyCode, scanCode, modifiers)) != false;
    }

    @Override
    public boolean onNavigation(NavigationDirection direction, boolean tab) {
        boolean isNonNull;
        if (this.requiresCursor()) {
            return false;
        }
        GuiEventListener focused = this.m_7222_();
        boolean bl = isNonNull = focused != null;
        if (!isNonNull || !this.tryNavigating(focused, direction, tab)) {
            GuiEventListener nextElement;
            Supplier<GuiEventListener> nextGetter;
            BooleanSupplier hasNext;
            List children = this.m_6702_();
            int i = children.indexOf(focused);
            int next = isNonNull && i >= 0 ? i + (direction.isLookingForward() ? 1 : 0) : (direction.isLookingForward() ? 0 : children.size());
            ListIterator iterator = children.listIterator(next);
            BooleanSupplier booleanSupplier = direction.isLookingForward() ? iterator::hasNext : (hasNext = iterator::hasPrevious);
            Supplier<GuiEventListener> supplier = direction.isLookingForward() ? iterator::next : (nextGetter = iterator::previous);
            do {
                if (hasNext.getAsBoolean()) continue;
                this.m_7522_(null);
                return false;
            } while (!this.tryNavigating(nextElement = nextGetter.get(), direction, tab));
            this.m_7522_(nextElement);
        }
        return true;
    }

    private boolean tryNavigating(GuiEventListener element, NavigationDirection direction, boolean tab) {
        if (element instanceof SpruceElement) {
            return ((SpruceElement)element).onNavigation(direction, tab);
        }
        element.m_93692_(direction.isLookingForward());
        return true;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        ScissorManager.pushScaleFactor(this.scaleFactor);
        super.m_88315_(graphics, mouseX, mouseY, delta);
        this.renderWidgets(graphics, mouseX, mouseY, delta);
        this.renderTitle(graphics, mouseX, mouseY, delta);
        Tooltip.renderAll(graphics);
        ScissorManager.popScaleFactor();
    }

    public void renderTitle(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
    }

    public void renderWidgets(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        for (GuiEventListener element : this.m_6702_()) {
            if (!(element instanceof Renderable)) continue;
            Renderable drawable = (Renderable)element;
            drawable.m_88315_(graphics, mouseX, mouseY, delta);
        }
    }
}

