/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.spruceui.hud;

import dev.lambdaurora.spruceui.event.OpenScreenCallback;
import dev.lambdaurora.spruceui.event.ResolutionChangeCallback;
import dev.lambdaurora.spruceui.hud.Hud;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class HudManager {
    private static final Map<ResourceLocation, Hud> HUDS = new Object2ObjectOpenHashMap();

    public void initialize() {
        HudRenderCallback.EVENT.register((graphics, tickDelta) -> HUDS.forEach((id, hud) -> {
            if (hud.isEnabled() && hud.isVisible()) {
                hud.render(graphics, tickDelta);
            }
        }));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (!HudManager.canRenderHuds(client)) {
                return;
            }
            HUDS.forEach((id, hud) -> {
                if (hud.isEnabled() && hud.isVisible() && hud.hasTicks()) {
                    hud.tick();
                }
            });
        });
        OpenScreenCallback.EVENT.register((client, screen) -> HudManager.initAll(client, client.m_91268_().m_85445_(), client.m_91268_().m_85446_()));
        ResolutionChangeCallback.EVENT.register(client -> HudManager.initAll(client, client.m_91268_().m_85445_(), client.m_91268_().m_85446_()));
    }

    protected static void initAll(@NotNull Minecraft client, int screenWidth, int screenHeight) {
        if (!HudManager.canRenderHuds(client)) {
            return;
        }
        HUDS.forEach((id, hud) -> {
            if (hud.isEnabled()) {
                hud.init(client, screenWidth, screenHeight);
            }
        });
    }

    public static void register(@NotNull Hud hud) {
        if (HUDS.containsKey(hud.getIdentifier())) {
            throw new IllegalArgumentException("Cannot register the same HUD twice!");
        }
        HUDS.put(hud.getIdentifier(), hud);
    }

    public static void unregister(@NotNull ResourceLocation identifier) {
        HUDS.remove(identifier);
    }

    public static void unregister(@NotNull Hud hud) {
        HudManager.unregister(hud.getIdentifier());
    }

    public static boolean canRenderHuds(@NotNull Minecraft client) {
        return client.f_91073_ != null && (!client.f_91066_.f_92062_ || client.f_91080_ != null);
    }

    public static Optional<Hud> getHud(@NotNull ResourceLocation identifier) {
        return Optional.ofNullable(HUDS.get(identifier));
    }

    public static Collection<Hud> getHuds() {
        return HUDS.values();
    }
}

