/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.spruceui.hud;

import com.google.common.collect.ImmutableList;
import dev.lambdaurora.spruceui.hud.HudComponent;
import dev.lambdaurora.spruceui.util.Identifiable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public abstract class Hud
implements Identifiable {
    protected final ResourceLocation identifier;
    protected final List<HudComponent> components = new ArrayList<HudComponent>();
    protected final String translationKey;
    private boolean enabled = true;
    protected boolean visible = true;

    public Hud(@NotNull ResourceLocation id) {
        this.identifier = id;
        this.translationKey = this.identifier.m_135827_() + ".hud." + this.identifier.m_135815_().replace('/', '.');
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (enabled) {
            Minecraft client = Minecraft.m_91087_();
            this.init(client, client.m_91268_().m_85445_(), client.m_91268_().m_85446_());
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void init(@NotNull Minecraft client, int screenWidth, int screenHeight) {
        this.components.clear();
    }

    public void render(GuiGraphics graphics, float tickDelta) {
        this.components.stream().filter(HudComponent::isEnabled).forEach(component -> component.render(graphics, tickDelta));
    }

    public void tick() {
        this.components.stream().filter(((Predicate<HudComponent>)HudComponent::hasTicks).and(HudComponent::isEnabled)).forEach(HudComponent::tick);
    }

    public boolean hasTicks() {
        return false;
    }

    @NotNull
    public List<HudComponent> getComponents() {
        return ImmutableList.copyOf(this.components);
    }

    @Override
    @NotNull
    public ResourceLocation getIdentifier() {
        return this.identifier;
    }
}

