/*
 * Decompiled with CFR 0.152.
 */
package dev.cammiescorner.icarus.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.cammiescorner.icarus.api.client.IcarusAPIClient;
import dev.cammiescorner.icarus.client.IcarusClient;
import dev.cammiescorner.icarus.client.IcarusModels;
import dev.cammiescorner.icarus.client.models.DiscordsWingsModel;
import dev.cammiescorner.icarus.client.models.FeatheredWingsModel;
import dev.cammiescorner.icarus.client.models.FlandresWingsModel;
import dev.cammiescorner.icarus.client.models.LeatherWingsModel;
import dev.cammiescorner.icarus.client.models.LightWingsModel;
import dev.cammiescorner.icarus.client.models.WingEntityModel;
import dev.cammiescorner.icarus.client.models.ZanzasWingsModel;
import dev.cammiescorner.icarus.init.IcarusItems;
import dev.cammiescorner.icarus.item.WingItem;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class WingsLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private final FeatheredWingsModel<T> featheredWings;
    private final LeatherWingsModel<T> leatherWings;
    private final LightWingsModel<T> lightWings;
    private final FlandresWingsModel<T> flandresWings;
    private final DiscordsWingsModel<T> discordsWings;
    private final ZanzasWingsModel<T> zanzasWings;

    public WingsLayer(RenderLayerParent<T, M> context, EntityModelSet loader) {
        super(context);
        this.featheredWings = new FeatheredWingsModel(loader.m_171103_(IcarusModels.FEATHERED));
        this.leatherWings = new LeatherWingsModel(loader.m_171103_(IcarusModels.LEATHER));
        this.lightWings = new LightWingsModel(loader.m_171103_(IcarusModels.LIGHT));
        this.flandresWings = new FlandresWingsModel(loader.m_171103_(IcarusModels.FLANDRE));
        this.discordsWings = new DiscordsWingsModel(loader.m_171103_(IcarusModels.DISCORD));
        this.zanzasWings = new ZanzasWingsModel(loader.m_171103_(IcarusModels.ZANZA));
    }

    public void render(PoseStack matrices, MultiBufferSource vertexConsumers, int light, T entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        ItemStack stack = IcarusAPIClient.getWingsForRendering(entity);
        Item item = stack.m_41720_();
        if (item instanceof WingItem) {
            WingItem wingItem = (WingItem)item;
            if (IcarusClient.shouldRenderWings(entity)) {
                WingEntityModel wingModel;
                float[] primaryColour = wingItem.getPrimaryColor(stack).m_41068_();
                float[] secondaryColour = wingItem.getSecondaryColor(stack).m_41068_();
                float r1 = primaryColour[0];
                float g1 = primaryColour[1];
                float b1 = primaryColour[2];
                float r2 = secondaryColour[0];
                float g2 = secondaryColour[1];
                float b2 = secondaryColour[2];
                switch (wingItem.getWingType()) {
                    case FEATHERED: 
                    case MECHANICAL_FEATHERED: {
                        WingEntityModel wingEntityModel = this.featheredWings;
                        break;
                    }
                    case DRAGON: 
                    case MECHANICAL_LEATHER: {
                        WingEntityModel wingEntityModel = this.leatherWings;
                        break;
                    }
                    case LIGHT: {
                        WingEntityModel wingEntityModel = this.lightWings;
                        break;
                    }
                    case UNIQUE: {
                        WingEntityModel wingEntityModel;
                        if (stack.m_150930_((Item)IcarusItems.FLANDRES_WINGS.get())) {
                            wingEntityModel = this.flandresWings;
                            break;
                        }
                        if (stack.m_150930_((Item)IcarusItems.DISCORDS_WINGS.get())) {
                            wingEntityModel = this.discordsWings;
                            break;
                        }
                        if (stack.m_150930_((Item)IcarusItems.ZANZAS_WINGS.get())) {
                            wingEntityModel = this.zanzasWings;
                            break;
                        }
                        wingEntityModel = null;
                        break;
                    }
                    default: {
                        WingEntityModel wingEntityModel = wingModel = null;
                    }
                }
                if (wingModel == null) {
                    return;
                }
                ResourceLocation layer1 = wingItem.getWingType().getTextureLayer1(stack);
                ResourceLocation layer2 = wingItem.getWingType().getTextureLayer2(stack);
                matrices.m_85836_();
                matrices.m_85837_(0.0, 0.0, 0.125);
                this.m_117386_().m_102624_(wingModel);
                wingModel.setupAnim(entity, limbAngle, limbDistance, animationProgress, headYaw, headPitch);
                this.renderWings(wingModel, matrices, vertexConsumers, stack, RenderType.m_110473_((ResourceLocation)layer2), light, r2, g2, b2);
                this.renderWings(wingModel, matrices, vertexConsumers, stack, RenderType.m_110473_((ResourceLocation)layer1), light, r1, g1, b1);
                matrices.m_85849_();
            }
        }
    }

    public void renderWings(WingEntityModel<T> model, PoseStack matrices, MultiBufferSource vertexConsumers, @Nullable ItemStack stack, RenderType renderLayer, int light, float r, float g, float b) {
        VertexConsumer vertexConsumer = ItemRenderer.m_115184_((MultiBufferSource)vertexConsumers, (RenderType)renderLayer, (boolean)false, (stack != null && stack.m_41790_() ? 1 : 0) != 0);
        model.m_7695_(matrices, vertexConsumer, light, OverlayTexture.f_118083_, r, g, b, 1.0f);
    }
}

