/*
 * Decompiled with CFR 0.152.
 */
package sleys.lazyutilities.modules.epicfight.wrapper;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;
import sleys.lazyutilities.modules.epicfight.interfaces.ICapabilityRegisterAnimations;

public class AnimationsRegisterWrapper {
    public static Register createForEF9(Map<String, Runnable> registryMap, String modId) {
        try {
            return new Register(registryMap, modId);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("EF9 registry created but EF9 not detected", e);
        }
    }

    public static Register createForEF10(Object animationRegistryEvent, String modId) {
        try {
            return new Register(animationRegistryEvent, modId);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("EF10+ registry created but EF10+ not detected", e);
        }
    }

    public static class Register {
        private final Object registryTarget;
        private final String modId;
        private final EpicFightType currentVersion;

        public Register(@Nullable Object registryTarget, String modId) throws ClassNotFoundException {
            this.registryTarget = registryTarget;
            this.modId = modId;
            this.currentVersion = EpicFightType.detectVersion();
            this.validateTarget();
        }

        private void validateTarget() {
            if (this.currentVersion == EpicFightType.EF9) {
                if (!(this.registryTarget instanceof Map)) {
                    throw new IllegalArgumentException("EF9 requires a Map<String, Runnable> as registry target");
                }
            } else {
                try {
                    Class<?> eventClass = Class.forName("yesman.epicfight.api.animation.AnimationManager$AnimationRegistryEvent");
                    if (!eventClass.isInstance(this.registryTarget)) {
                        throw new IllegalArgumentException("EF10+ requires an AnimationRegistryEvent as registry target");
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Failed to validate EF10+ target, registration intent out of range", e);
                }
            }
        }

        public String getModId() {
            return this.modId;
        }

        public EpicFightType getCurrentVersion() {
            return this.currentVersion;
        }

        public void tryRegister(Runnable builder) {
            if (this.currentVersion != EpicFightType.EF9) {
                throw new UnsupportedOperationException("Runnable-based registration is only supported in EF9");
            }
            if (builder == null || !(this.registryTarget instanceof Map)) {
                throw new IllegalArgumentException("EF9 requires non-null Runnable and Map registry target");
            }
            ((Map)this.registryTarget).put(this.modId, builder);
        }

        public void tryRegister(Consumer<?> consumerBuilder) {
            if (this.currentVersion == EpicFightType.EF9) {
                throw new UnsupportedOperationException("Consumer-based registration is only supported in EF10+");
            }
            if (consumerBuilder == null || this.registryTarget == null) {
                throw new IllegalArgumentException("EF10+ requires non-null Consumer and AnimationRegistryEvent");
            }
            try {
                Method newBuilderMethod = this.registryTarget.getClass().getMethod("newBuilder", String.class, Consumer.class);
                newBuilderMethod.invoke(this.registryTarget, this.modId, consumerBuilder);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("newBuilder method not found for EF10+ registration", e);
            }
            catch (Exception e) {
                throw new RuntimeException("Consumer registration failed", e);
            }
        }
    }

    public static abstract class CapabilityRegisterAnimations
    implements ICapabilityRegisterAnimations {
        @Override
        public void capabilityRegisterAnimations(Register event) {
            event.tryRegister(this::buildAnimations);
        }

        protected abstract void buildAnimations();
    }

    public static enum EpicFightType {
        EF9,
        EF10,
        EF11,
        EF12;


        public static EpicFightType detectVersion() throws ClassNotFoundException {
            try {
                Class.forName("yesman.epicfight.api.animation.AnimationManager$AnimationRegistryEvent");
                return EF10;
            }
            catch (ClassNotFoundException e1) {
                try {
                    Class.forName("yesman.epicfight.api.forgeevent.AnimationRegistryEvent");
                    return EF9;
                }
                catch (ClassNotFoundException ignored) {
                    throw new ClassNotFoundException("Capability Animation Builder error: Out of range In Register Capability Level");
                }
            }
        }
    }
}

