/*
 * Decompiled with CFR 0.152.
 */
package sleys.lazyutilities.modules.epicfight.utilities.skills;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import sleys.lazyutilities.core.utilities.network.STCFocalTagSyncSender;
import sleys.lazyutilities.modules.epicfight.forgeevents.client.EpicFightAFKEvent;
import sleys.lazyutilities.modules.epicfight.interfaces.IUpdateContainerModule;
import sleys.lazyutilities.modules.epicfight.interfaces.IUseIdleAnimations;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

public abstract class ExtendedPassiveSkill
extends Skill
implements IUpdateContainerModule,
IUseIdleAnimations {
    public ExtendedPassiveSkill(SkillBuilder<? extends Skill> builder) {
        super(builder);
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        PlayerPatch patchPlayer = container.getExecutor();
        Player player = (Player)patchPlayer.getOriginal();
        Level level = player.m_9236_();
        boolean isClientSide = level.m_5776_();
        if (isClientSide) {
            this.ClientThreadSkill(container, patchPlayer, player, level, player.m_7655_());
        } else {
            this.ServerThreadSkill(container, patchPlayer, (ServerPlayer)player, (ServerLevel)level, player.getPersistentData());
        }
        if (this.implementIdleAnimations()) {
            boolean clientAfkAccessor = false;
            String useAfkTimer = EpicFightAFKEvent.getAfkNeedCounting();
            String isAFK = EpicFightAFKEvent.getTagAfkIsAFK();
            String wasAFK = EpicFightAFKEvent.getTagAfkWasAFK();
            CompoundTag commonData = player.getPersistentData();
            if (isClientSide) {
                clientAfkAccessor = commonData.m_128471_(useAfkTimer);
            }
            if (!isClientSide) {
                boolean serverAfkAccessor = commonData.m_128471_(useAfkTimer);
                if (clientAfkAccessor != serverAfkAccessor) {
                    commonData.m_128379_(useAfkTimer, true);
                    STCFocalTagSyncSender.sendBoolean((ServerPlayer)player, useAfkTimer, true);
                }
                if (!serverAfkAccessor) {
                    commonData.m_128379_(useAfkTimer, true);
                    STCFocalTagSyncSender.sendBoolean((ServerPlayer)player, useAfkTimer, true);
                }
                if (commonData.m_128471_(isAFK)) {
                    this.IdleAnimations(container.getDataManager(), patchPlayer, (ServerPlayer)player, (ServerLevel)level, commonData);
                    if (!commonData.m_128471_(wasAFK)) {
                        commonData.m_128379_(wasAFK, true);
                    }
                } else if (commonData.m_128471_(wasAFK)) {
                    this.resetIdleData(container.getDataManager(), (ServerPlayer)player, 0);
                    commonData.m_128379_(wasAFK, false);
                }
            }
        }
    }

    @Override
    public boolean implementIdleAnimations() {
        return false;
    }

    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        if (this.implementIdleAnimations() && !((Player)container.getExecutor().getOriginal()).m_9236_().f_46443_) {
            PlayerPatch patchPlayer = container.getExecutor();
            ServerPlayer player = (ServerPlayer)patchPlayer.getOriginal();
            CompoundTag persistentData = player.getPersistentData();
            String useAfkTimer = EpicFightAFKEvent.getAfkNeedCounting();
            String wasAFK = EpicFightAFKEvent.getTagAfkWasAFK();
            STCFocalTagSyncSender.sendBoolean(player, useAfkTimer, false);
            persistentData.m_128473_(useAfkTimer);
            persistentData.m_128473_(wasAFK);
        }
    }

    @Override
    public void IdleAnimations(SkillDataManager skillData, PlayerPatch<?> patchPlayer, ServerPlayer player, ServerLevel world, CompoundTag persistentData) {
    }

    @Override
    public void resetIdleData(SkillDataManager skillData, ServerPlayer player, int resetValue) {
    }

    @Override
    public void ClientThreadSkill(SkillContainer container, PlayerPatch<?> patchPlayer, Player player, Level world, InteractionHand hand) {
    }

    @Override
    public void ServerThreadSkill(SkillContainer container, PlayerPatch<?> patchPlayer, ServerPlayer player, ServerLevel world, CompoundTag persistentData) {
    }
}

