/*
 * Decompiled with CFR 0.152.
 */
package sleys.lazyutilities.modules.epicfight.utilities.skills;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;

public class ArmorAbilitySyncHandler {
    private final ServerPlayer player;
    private final CompoundTag persistentData;
    private final SkillContainer container;

    public ArmorAbilitySyncHandler(SkillContainer container, ServerPlayer player, CompoundTag persistentData) {
        this.container = container;
        this.player = player;
        this.persistentData = persistentData;
    }

    public void handleAbility(ServerPlayer player, String tag, String tagNoEF, SkillDataKey<Boolean> abilityFlag, @Nullable SkillDataKey<Boolean> failFlag, @Nullable SkillDataKey<Boolean> failExecutionFlag, boolean inCooldown, Runnable onInitiate, @Nullable Runnable onUpdate, @Nullable Runnable onRemove, @Nullable Runnable onSkillFail, @Nullable Runnable onSkillFailExecution) {
        boolean failExecutionActive;
        boolean activeAbility = (Boolean)this.container.getDataManager().getDataValue(abilityFlag);
        boolean failAbility = failFlag != null && (Boolean)this.container.getDataManager().getDataValue(failFlag) != false;
        boolean bl = failExecutionActive = failExecutionFlag != null && (Boolean)this.container.getDataManager().getDataValue(failExecutionFlag) != false;
        if (inCooldown) {
            if (activeAbility) {
                if (onUpdate != null) {
                    onUpdate.run();
                }
            } else if (!activeAbility) {
                this.container.getDataManager().setDataSync(abilityFlag, (Object)true, player);
                onInitiate.run();
            } else if (!this.persistentData.m_128471_(tag) && !this.persistentData.m_128471_(tagNoEF)) {
                this.persistentData.m_128379_(tag, true);
                this.persistentData.m_128379_(tagNoEF, true);
                onInitiate.run();
            }
            if (failAbility && onSkillFail != null) {
                this.container.getDataManager().setDataSync(failFlag, (Object)false, player);
                onSkillFail.run();
            }
        } else if (activeAbility) {
            this.container.getDataManager().setDataSync(abilityFlag, (Object)false, player);
            if (onRemove != null) {
                onRemove.run();
            }
        } else if (this.persistentData.m_128471_(tag) && this.persistentData.m_128471_(tagNoEF)) {
            this.persistentData.m_128473_(tag);
            this.persistentData.m_128473_(tagNoEF);
            if (onRemove != null) {
                onRemove.run();
            }
        }
        if (!inCooldown && failExecutionActive && onSkillFailExecution != null) {
            this.container.getDataManager().setDataSync(failExecutionFlag, (Object)false, player);
            onSkillFailExecution.run();
        }
    }
}

