/*
 * Decompiled with CFR 0.152.
 */
package sleys.lazyutilities.modules.epicfight.utilities.model;

import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import sleys.lazyutilities.core.LazyUtilitiesMod;
import sleys.lazyutilities.core.interfaces.IParticleEmitterPacket;
import sleys.lazyutilities.core.utilities.network.CTSParticlePacket;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class ParticlePoseEngineComplex {
    public static void generateParticles(LivingEntity entity, String jointName, List<Vec3> offsets, double step, Vec3 randomVariation, Vec3 particleVelocity, IParticleEmitterPacket emitter, float amount) {
        if (entity == null) {
            return;
        }
        Level world = entity.m_9236_();
        ThreadLocalRandom random = ThreadLocalRandom.current();
        LivingEntityPatch entityPatch = (LivingEntityPatch)entity.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY, null).orElse(null);
        if (entityPatch == null) {
            return;
        }
        Joint joint = entityPatch.getArmature().searchJointByName(jointName);
        if (joint == null) {
            return;
        }
        for (float i = 1.0f; i <= 9.0f; i += 2.0f) {
            float t = (i + ((Random)random).nextFloat() - 1.0f) / 10.0f;
            Pose middlePose = entityPatch.getAnimator().getPose(t);
            Vec3 posMid = entity.m_20318_(t);
            OpenMatrix4f middleModelTf = OpenMatrix4f.createTranslation((float)((float)posMid.f_82479_), (float)((float)posMid.f_82480_), (float)((float)posMid.f_82481_)).mulBack(OpenMatrix4f.createRotatorDeg((float)180.0f, (Vec3f)Vec3f.Y_AXIS).mulBack(entityPatch.getModelMatrix(t)));
            OpenMatrix4f middleJointTf = entityPatch.getArmature().getBindedTransformFor(middlePose, joint).mulFront(middleModelTf);
            int bound = (int)((double)(100.0f / Math.max(amount, 0.01f)) * Math.max(step, 1.0));
            if (bound <= 0) continue;
            for (Vec3 baseOffset : offsets) {
                if (((Random)random).nextInt(bound) >= 40) continue;
                Vec3 variedOffset = baseOffset.m_82520_((double)((Random)random).nextFloat() * randomVariation.f_82479_, (double)((Random)random).nextFloat() * randomVariation.f_82480_, (double)((Random)random).nextFloat() * randomVariation.f_82481_);
                Vec3 particlePos = OpenMatrix4f.transform((OpenMatrix4f)middleJointTf, (Vec3)variedOffset);
                if (!world.f_46443_) continue;
                emitter.emit(world, particlePos, particleVelocity);
            }
        }
    }

    public class SimpleParticleEmitter
    implements IParticleEmitterPacket {
        private final SimpleParticleType particle;

        public SimpleParticleEmitter(SimpleParticleType particle) {
            this.particle = particle;
        }

        @Override
        public void emit(Level level, Vec3 position, Vec3 speed) {
            if (level.f_46443_) {
                LazyUtilitiesMod.PACKET_HANDLER.sendToServer((Object)new CTSParticlePacket(position.f_82479_, position.f_82480_, position.f_82481_, speed.f_82479_, speed.f_82480_, speed.f_82481_, (ParticleOptions)this.particle));
            }
        }
    }
}

