/*
 * Decompiled with CFR 0.152.
 */
package sleys.lazyutilities.modules.epicfight.runner.screen;

import java.util.HashSet;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import sleys.lazyutilities.modules.epicfight.runner.reader.LegacyRunnerClient;
import sleys.lazyutilities.modules.epicfight.runner.register.RequestRecordStorage;
import sleys.lazyutilities.modules.epicfight.runner.register.RequestRecordsManager;
import sleys.lazyutilities.modules.epicfight.runner.screen.LegacyRunnerScreenHandler;

public class LegacyRunnerScreen
extends Screen {
    private final Runnable onClose;
    private final boolean isMissingTargetIds;
    private boolean getStatus;

    public LegacyRunnerScreen(Runnable onClose) {
        super((Component)Component.m_237113_((String)"Epic Fight Utilities"));
        this.onClose = onClose;
        this.isMissingTargetIds = LegacyRunnerScreen.checkMissingTargets();
    }

    protected void m_7856_() {
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ - 30;
        if (LegacyRunnerScreenHandler.nextScreen) {
            this.getStatus = true;
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Continue"), button -> {
                RequestRecordStorage.saveRequests();
                this.onClose.run();
            }).m_252794_(centerX - 50, centerY).m_253046_(100, 20).m_253136_());
        }
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(graphics);
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        graphics.m_280137_(this.f_96547_, "LZM: Epic Fight", centerX, centerY - 110, 0xFFFFFF);
        graphics.m_280137_(this.f_96547_, "Requests have been detected, print effects:", centerX, centerY - 90, 0xAAAAAA);
        int warningOffset = -70;
        if (this.getStatus) {
            if (this.isMissingTargetIds) {
                graphics.m_280137_(this.f_96547_, "\u26a0 Some Files Missing! Please Install them. \u26a0", centerX, centerY + warningOffset, 0xFF0000);
            }
        } else {
            graphics.m_280137_(this.f_96547_, "\ud83d\udd03 Reloading! \ud83d\udd03", centerX, centerY + warningOffset, 255);
        }
        HashSet installedAddons = new HashSet(LegacyRunnerClient.Addons_Loader_Raw);
        Map<String, String> requestedMods = RequestRecordsManager.getRequestedMods();
        int startY = centerY - 30;
        graphics.m_280488_(this.f_96547_, "Source", centerX - 180, startY, 0xFFFF00);
        graphics.m_280488_(this.f_96547_, "Target", centerX - 20, startY, 0xFFFF00);
        if (this.getStatus) {
            graphics.m_280488_(this.f_96547_, "State", centerX + 160, startY, 0xFFFF00);
        }
        int yOffset = 20;
        for (Map.Entry<String, String> request : requestedMods.entrySet()) {
            int stateColor;
            String stateText;
            String sourceModId = request.getKey();
            String targetModId = request.getValue();
            String sourceName = RequestRecordsManager.getRequestComment(sourceModId);
            String targetName = RequestRecordsManager.getRequestComment(targetModId);
            boolean isValid = installedAddons.contains(targetModId);
            if (!isValid) {
                stateText = "\u274c";
                stateColor = 0xFF0000;
            } else {
                stateText = "\u2705";
                stateColor = 65280;
            }
            graphics.m_280488_(this.f_96547_, sourceName, centerX - 180, startY + yOffset, 0xFFFFFF);
            graphics.m_280488_(this.f_96547_, targetName, centerX - 20, startY + yOffset, 0xFFFFFF);
            if (this.getStatus) {
                graphics.m_280488_(this.f_96547_, stateText, centerX + 170, startY + yOffset, stateColor);
            }
            yOffset += 15;
        }
        super.m_88315_(graphics, mouseX, mouseY, delta);
    }

    public static boolean checkMissingTargets() {
        HashSet installedAddons = new HashSet(LegacyRunnerClient.Addons_Loader_Raw);
        Map<String, String> requestedMods = RequestRecordsManager.getRequestedMods();
        for (String targetModId : requestedMods.values()) {
            if (installedAddons.contains(targetModId)) continue;
            return true;
        }
        return false;
    }
}

