/*
 * Decompiled with CFR 0.152.
 */
package sleys.lazyutilities.modules.epicfight.runner.reader;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;
import sleys.lazyutilities.modules.epicfight.runner.reader.LegacyRunnerBase;

public class LegacyRunnerClient
extends LegacyRunnerBase {
    public static final List<String> Addons_Loader = new ArrayList<String>();

    @Override
    protected void onProcessComplete(List<String> knownAddons, List<String> detectedAddons, List<String> invalidAddons, List<String> disabledAddons) {
        StringBuilder descriptionBuilder = new StringBuilder("Requests for legacy runners...\nCurrent status of files in folder\n\n");
        if (!knownAddons.isEmpty()) {
            descriptionBuilder.append("Known Addons:\n");
            for (String addon : knownAddons) {
                descriptionBuilder.append("- ").append(addon).append("\n");
            }
            descriptionBuilder.append("\n");
        }
        if (!detectedAddons.isEmpty()) {
            descriptionBuilder.append("Detected Addons:\n");
            for (String addon : detectedAddons) {
                descriptionBuilder.append("- ").append(addon).append("\n");
            }
            descriptionBuilder.append("\n");
        }
        if (!invalidAddons.isEmpty()) {
            descriptionBuilder.append("Invalid Addons:\n");
            for (String addon : invalidAddons) {
                descriptionBuilder.append("- ").append(addon).append(": Invalid structure or missing modId\n");
            }
            descriptionBuilder.append("\n");
        }
        if (!disabledAddons.isEmpty()) {
            descriptionBuilder.append("Disabled Addons:\n");
            for (String addon : disabledAddons) {
                descriptionBuilder.append("- ").append(addon).append("\n");
            }
            descriptionBuilder.append("\n");
        }
        this.updateModDescription(descriptionBuilder.toString().trim());
        Addons_Loader.clear();
        Addons_Loader.add("Known Addons: " + String.valueOf(knownAddons));
        Addons_Loader.add("Detected Addons: " + String.valueOf(detectedAddons));
        Addons_Loader.add("Invalid Addons: " + String.valueOf(invalidAddons));
        Addons_Loader.add("Disabled Addons: " + String.valueOf(disabledAddons));
        StringBuilder loaderString = new StringBuilder();
        for (String entry : Addons_Loader) {
            loaderString.append(entry).append("\n");
        }
    }

    private void updateModDescription(String newDescription) {
        try {
            ModList modList = ModList.get();
            IModInfo modInfo = ((ModContainer)modList.getModContainerById("lzm_epicfight").get()).getModInfo();
            Field descriptionField = modInfo.getClass().getDeclaredField("description");
            descriptionField.setAccessible(true);
            descriptionField.set(modInfo, newDescription);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

