/*
 * Decompiled with CFR 0.152.
 */
package sleys.lazyutilities.modules.epicfight.mixins;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import sleys.lazyutilities.core.config.LazyUtilitiesConfigCommon;
import sleys.lazyutilities.core.interfaces.IWeaponCodexEF;
import sleys.lazyutilities.core.utilities.logic.PlayerLogicUtilities;
import yesman.epicfight.client.events.engine.RenderEngine;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;

@Mixin(value={RenderEngine.Events.class}, priority=2000)
public class RenderEngineMixinClient {
    @Final
    @Inject(method={"itemTooltip"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private static void cancelOnCodexEF(ItemTooltipEvent event, CallbackInfo ci) {
        if (LazyUtilitiesConfigCommon.getErrorHandlerEpicFight() != LazyUtilitiesConfigCommon.ErrorHandler.EXCEPTION) {
            try {
                RenderEngineMixinClient.lazy_utilities$OnCodexEFPayload(event, ci);
            }
            catch (Exception exception) {}
        } else {
            RenderEngineMixinClient.lazy_utilities$OnCodexEFPayload(event, ci);
        }
    }

    @Unique
    private static void lazy_utilities$OnCodexEFPayload(ItemTooltipEvent event, CallbackInfo ci) {
        if (event == null) {
            return;
        }
        if (!PlayerLogicUtilities.isValidPlayer(event.getEntity())) {
            return;
        }
        ItemStack stack = event.getItemStack();
        Item item = stack.m_41720_();
        if (item instanceof IWeaponCodexEF) {
            IWeaponCodexEF efCodex = (IWeaponCodexEF)item;
            if (efCodex.isUnImplementedInnateSkill()) {
                return;
            }
            EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)event.getEntity(), LocalPlayerPatch.class).ifPresent(playerPatch -> {
                if (!PlayerLogicUtilities.isValidPatchedPlayer(playerPatch)) {
                    return;
                }
                if (EpicFightCapabilities.getItemStackCapabilityOr((ItemStack)event.getItemStack(), null) == null) {
                    return;
                }
                ci.cancel();
            });
        }
    }
}

