/*
 * Decompiled with CFR 0.152.
 */
package sleys.lazyutilities.modules.epicfight.forgeevents.client;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import sleys.lazyutilities.core.config.LazyUtilitiesConfigCommon;
import sleys.lazyutilities.core.utilities.logic.PlayerLogicUtilities;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

public class StaminaOverlayEvent {
    @SubscribeEvent
    public static void onRenderOverlayEvent(RenderGuiOverlayEvent.Post event) {
        if (LazyUtilitiesConfigCommon.getErrorHandlerEpicFight() != LazyUtilitiesConfigCommon.ErrorHandler.EXCEPTION) {
            try {
                StaminaOverlayEvent.onRenderOverlayPayload(event);
            }
            catch (Exception exception) {}
        } else {
            StaminaOverlayEvent.onRenderOverlayPayload(event);
        }
    }

    private static void onRenderOverlayPayload(RenderGuiOverlayEvent.Post event) {
        if (event == null) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (!PlayerLogicUtilities.isValidPlayer((Player)player)) {
            return;
        }
        PlayerPatch playerPatch = (PlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)player, PlayerPatch.class);
        if (!PlayerLogicUtilities.isValidPatchedPlayer(playerPatch)) {
            return;
        }
        GuiGraphics gui = event.getGuiGraphics();
        MinecraftForge.EVENT_BUS.post((Event)new RenderEvent(event, playerPatch, player, gui));
    }

    public static class RenderEvent
    extends Event {
        private final PlayerPatch<?> playerPatch;
        private final LocalPlayer player;
        private final Minecraft mc;
        private final GuiGraphics gui;
        private final RenderGuiOverlayEvent.Post forgeEvent;
        private static int maxCountTime = 0;
        private static float currentAlpha = 1.0f;
        private static float targetAlpha = 1.0f;
        private static RenderEffect currentEffect = RenderEffect.EASE_OUT;

        public RenderEvent(RenderGuiOverlayEvent.Post forgeEvent, PlayerPatch<?> playerPatch, LocalPlayer player, GuiGraphics gui) {
            this.forgeEvent = forgeEvent;
            this.mc = Minecraft.m_91087_();
            this.playerPatch = playerPatch;
            this.player = player;
            this.gui = gui;
        }

        public void renderStaminaBar(RenderEffect effect, int x, int y, int barWidth, int barHeight) {
            currentEffect = effect;
            float progress = this.getProgressStamina();
            this.updateAlpha(progress);
            int baseColor = this.calculateColor(progress);
            int filledHeight = (int)((float)barHeight * progress);
            int staminaColor = this.convertAlpha(baseColor, (int)(255.0f * currentAlpha));
            float minBgAlpha = 0.02f;
            float maxBgAlpha = 0.025f;
            float backgroundAlpha = minBgAlpha + (maxBgAlpha - minBgAlpha) * progress;
            int backgroundColor = this.convertAlpha(0, (int)(255.0f * backgroundAlpha));
            if (progress != 1.0f) {
                this.gui.m_280509_(x, y - barHeight, x + barWidth, y, backgroundColor);
            }
            if (filledHeight > 0) {
                this.gui.m_280509_(x, y - filledHeight, x + barWidth, y, staminaColor);
            }
        }

        public void renderStaminaBar(int x, int y, int barWidth, int barHeight) {
            float progress = this.getProgressStamina();
            int baseColor = this.calculateColor(progress);
            int filledHeight = (int)((float)barHeight * progress);
            int staminaColor = this.convertAlpha(baseColor, (int)(255.0f * currentAlpha));
            int backgroundColor = this.convertAlpha(0, 8);
            this.gui.m_280509_(x, y - barHeight, x + barWidth, y, backgroundColor);
            this.gui.m_280509_(x, y - filledHeight, x + barWidth, y, staminaColor);
        }

        public float getProgressStamina() {
            float actualStamina = this.playerPatch.getStamina();
            float maxStamina = this.playerPatch.getMaxStamina();
            float progress = actualStamina / maxStamina;
            return Math.min(progress, 1.0f);
        }

        public int calculateColor(float progress) {
            float hue = progress * 0.4f;
            return Color.HSBtoRGB(hue, 0.9f, 0.9f);
        }

        public int convertAlpha(int rgbColor, int alpha) {
            return alpha << 24 | rgbColor & 0xFFFFFF;
        }

        private void updateAlpha(float progress) {
            float actualStamina = this.playerPatch.getStamina();
            float maxStamina = this.playerPatch.getMaxStamina();
            switch (currentEffect) {
                case DIRECT: {
                    this.handleDirectEffect(actualStamina, maxStamina);
                    break;
                }
                case EASE_IN: {
                    this.handleEaseInEffect(actualStamina, maxStamina, progress);
                    break;
                }
                case EASE_OUT: {
                    this.handleEaseOutEffect(actualStamina, maxStamina);
                }
            }
            float alphaSpeed = 0.2f;
            currentAlpha += (targetAlpha - currentAlpha) * alphaSpeed;
        }

        private void handleDirectEffect(float actualStamina, float maxStamina) {
            targetAlpha = actualStamina == maxStamina ? 0.0f : 1.0f;
        }

        private void handleEaseInEffect(float actualStamina, float maxStamina, float progress) {
            targetAlpha = actualStamina < maxStamina ? progress : 0.1f;
        }

        private void handleEaseOutEffect(float actualStamina, float maxStamina) {
            if (actualStamina == maxStamina) {
                if (maxCountTime < this.convertTime(1)) {
                    ++maxCountTime;
                    targetAlpha = 1.0f;
                } else {
                    float t = (float)(maxCountTime - this.convertTime(10)) / (float)this.convertTime(30);
                    t = Math.min(Math.max(t, 0.0f), 1.0f);
                    float easeOut = 1.0f - (1.0f - t) * (1.0f - t);
                    targetAlpha = 1.0f - easeOut;
                    ++maxCountTime;
                }
            } else {
                maxCountTime = 0;
                targetAlpha = 1.0f;
            }
        }

        public int convertTime(int seconds) {
            return this.getFrameRates() * seconds;
        }

        public PlayerPatch<?> getPlayerPatch() {
            return this.playerPatch;
        }

        public int getFrameRates() {
            return this.mc.m_260875_();
        }

        public int getRefreshRate() {
            return this.mc.m_91268_().m_85377_();
        }

        public Player getPlayer() {
            return this.player;
        }

        public GuiGraphics getGui() {
            return this.gui;
        }

        public float getStamina() {
            return this.playerPatch.getStamina();
        }

        public float getMaxStamina() {
            return this.playerPatch.getMaxStamina();
        }

        public RenderGuiOverlayEvent.Post getForgeEvent() {
            return this.forgeEvent;
        }
    }

    public static enum RenderEffect {
        DIRECT,
        EASE_IN,
        EASE_OUT;

    }
}

