/*
 * Decompiled with CFR 0.152.
 */
package sleys.lazyutilities.modules.epicfight.forgeevents.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import sleys.lazyutilities.core.config.LazyUtilitiesConfigCommon;
import sleys.lazyutilities.core.interfaces.IWeaponCodexEF;
import sleys.lazyutilities.core.utilities.logic.PlayerLogicUtilities;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;

public class ShadowTooltipEvent {
    @SubscribeEvent
    public static void itemTooltipEvent(ItemTooltipEvent event) {
        if (LazyUtilitiesConfigCommon.getErrorHandlerEpicFight() != LazyUtilitiesConfigCommon.ErrorHandler.EXCEPTION) {
            try {
                ShadowTooltipEvent.itemTooltipPayload(event);
            }
            catch (Exception exception) {}
        } else {
            ShadowTooltipEvent.itemTooltipPayload(event);
        }
    }

    private static void itemTooltipPayload(ItemTooltipEvent event) {
        if (event == null) {
            return;
        }
        if (!PlayerLogicUtilities.isValidPlayer(event.getEntity())) {
            return;
        }
        ItemStack stack = event.getItemStack();
        Item item = stack.m_41720_();
        if (item instanceof IWeaponCodexEF) {
            IWeaponCodexEF efCodex = (IWeaponCodexEF)item;
            boolean isUnImplementedEF = efCodex.isUnImplementedInnateSkill();
            if (isUnImplementedEF) {
                return;
            }
            EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)event.getEntity(), LocalPlayerPatch.class).ifPresent(playerpatch -> {
                if (!PlayerLogicUtilities.isValidPatchedPlayer(playerpatch)) {
                    return;
                }
                List tooltip = event.getToolTip();
                CapabilityItem cap = EpicFightCapabilities.getItemStackCapabilityOr((ItemStack)event.getItemStack(), null);
                if (cap == null) {
                    return;
                }
                cap.modifyItemTooltip(event.getItemStack(), event.getToolTip(), (LivingEntityPatch)playerpatch);
                for (int i = 0; i < tooltip.size(); ++i) {
                    MutableComponent mutableComponent$2;
                    ComponentContents patt3309$temp;
                    Object patt3189$temp;
                    TranslatableContents translatableContent;
                    MutableComponent mutableComponent;
                    ComponentContents patt3024$temp;
                    Component sibling;
                    Component textComp = (Component)tooltip.get(i);
                    if (textComp.m_7360_().isEmpty() || !((sibling = (Component)textComp.m_7360_().get(0)) instanceof MutableComponent) || !((patt3024$temp = (mutableComponent = (MutableComponent)sibling).m_214077_()) instanceof TranslatableContents) || (translatableContent = (TranslatableContents)patt3024$temp).m_237523_().length <= 1 || !((patt3189$temp = translatableContent.m_237523_()[1]) instanceof MutableComponent) || !((patt3309$temp = (mutableComponent$2 = (MutableComponent)patt3189$temp).m_214077_()) instanceof TranslatableContents)) continue;
                    TranslatableContents translatableContent$2 = (TranslatableContents)patt3309$temp;
                    if (translatableContent$2.m_237508_().equals(Attributes.f_22283_.m_22087_())) {
                        float weaponSpeed = (float)playerpatch.getWeaponAttribute(Attributes.f_22283_, event.getItemStack());
                        tooltip.remove(i);
                        tooltip.add(i, Component.m_237113_((String)String.format(" %.2f ", Float.valueOf(playerpatch.getModifiedAttackSpeed(cap, weaponSpeed)))).m_7220_((Component)Component.m_237115_((String)Attributes.f_22283_.m_22087_())));
                        continue;
                    }
                    if (!translatableContent$2.m_237508_().equals(Attributes.f_22281_.m_22087_())) continue;
                    float weaponDamage = (float)playerpatch.getWeaponAttribute(Attributes.f_22281_, event.getItemStack());
                    float damageBonus = EnchantmentHelper.m_44833_((ItemStack)event.getItemStack(), (MobType)MobType.f_21640_);
                    String damageFormat = ItemStack.f_41584_.format(playerpatch.getModifiedBaseDamage(weaponDamage) + damageBonus);
                    tooltip.remove(i);
                    tooltip.add(i, Component.m_237113_((String)String.format(" %s ", damageFormat)).m_7220_((Component)Component.m_237115_((String)Attributes.f_22281_.m_22087_())).m_130940_(ChatFormatting.DARK_GREEN));
                }
                Skill weaponInnateSkill = cap.getInnateSkill((PlayerPatch)playerpatch, event.getItemStack());
                if (weaponInnateSkill != null) {
                    List skillTooltip = weaponInnateSkill.getTooltipOnItem(event.getItemStack(), cap, (PlayerPatch)playerpatch);
                    CodexSkillTooltipCache.store(event.getItemStack(), skillTooltip);
                }
            });
        }
    }

    public static class CodexSkillTooltipCache {
        public static final Map<Item, List<Component>> cache = Collections.synchronizedMap(new WeakHashMap());
        private static final int MAX_CACHE_SIZE = 1000;
        private static final long CACHE_DURATION_MS = 300000L;

        public static void store(ItemStack stack, List<Component> tooltip) {
            if (cache.size() >= 1000) {
                CodexSkillTooltipCache.clearOldEntries();
            }
            if (stack.m_41720_() instanceof IWeaponCodexEF) {
                cache.put(stack.m_41720_(), new ArrayList<Component>(tooltip));
            }
        }

        public static List<Component> get(ItemStack stack) {
            if (stack.m_41720_() instanceof IWeaponCodexEF) {
                List<Component> cached = cache.get(stack.m_41720_());
                return cached != null ? new ArrayList<Component>(cached) : List.of();
            }
            return List.of();
        }

        private static void clearOldEntries() {
            cache.entrySet().removeIf(entry -> true);
        }

        @SubscribeEvent
        public static void onClientDisconnect(ClientPlayerNetworkEvent.LoggingOut event) {
            cache.clear();
        }
    }
}

