/*
 * Decompiled with CFR 0.152.
 */
package sleys.lazyutilities.modules.epicfight.forgeevents;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class GlobalSkillEvent {
    private static final Set<UUID> playersWithActivePassive = new HashSet<UUID>();
    private static final Map<String, Set<String>> registryKeys = new HashMap<String, Set<String>>();

    public static void register(String modID, String skillKey) {
        registryKeys.computeIfAbsent(modID, k -> new HashSet()).add(modID + ":" + skillKey);
    }

    public static void safeRegister(String modID, String skillKey) {
        String fullKey = modID + ":" + skillKey;
        if (registryKeys.containsKey(modID) && registryKeys.get(modID).contains(fullKey)) {
            return;
        }
        registryKeys.computeIfAbsent(modID, k -> new HashSet()).add(fullKey);
    }

    public static void unregister(String modID, String skillKey) {
        if (registryKeys.containsKey(modID)) {
            registryKeys.get(modID).remove(modID + ":" + skillKey);
            if (registryKeys.get(modID).isEmpty()) {
                registryKeys.remove(modID);
            }
        }
    }

    public static boolean contains(String modID, String skillKey) {
        return registryKeys.containsKey(modID) && registryKeys.get(modID).contains(modID + ":" + skillKey);
    }

    public static Map<String, Set<String>> getAll() {
        return Collections.unmodifiableMap(registryKeys);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void inGlobalPassiveSkill(LZEpicFightSkillEvent event) {
        Map<String, Set<String>> registryKeys = GlobalSkillEvent.getAll();
        if (registryKeys.isEmpty()) {
            return;
        }
        UUID playerUUID = event.player.m_20148_();
        ItemStack mainHand = event.player.m_21205_();
        for (Set<String> skillTags : registryKeys.values()) {
            for (String tagKey : skillTags) {
                boolean hasKey = event.isImplementedTagKey(mainHand, tagKey);
                if (hasKey && !playersWithActivePassive.contains(playerUUID)) {
                    playersWithActivePassive.add(playerUUID);
                    MinecraftForge.EVENT_BUS.post((Event)new ActivationEvent(event, tagKey));
                }
                if (!hasKey && playersWithActivePassive.contains(playerUUID)) {
                    playersWithActivePassive.remove(playerUUID);
                    MinecraftForge.EVENT_BUS.post((Event)new DeactivationEvent(event, tagKey));
                }
                if (!hasKey || !playersWithActivePassive.contains(playerUUID)) continue;
                MinecraftForge.EVENT_BUS.post((Event)new ContinuousEvent(event, tagKey));
            }
        }
    }

    public static class LZEpicFightSkillEvent
    extends Event {
        private final PlayerPatch<?> playerPatch;
        private final Player player;
        private final TickEvent.PlayerTickEvent forgeEvent;
        private final String passiveKey;

        public LZEpicFightSkillEvent(PlayerPatch<?> playerPatch, TickEvent.PlayerTickEvent forgeEvent, String passiveKey) {
            this.playerPatch = playerPatch;
            this.player = (Player)playerPatch.getOriginal();
            this.forgeEvent = forgeEvent;
            this.passiveKey = passiveKey;
        }

        public PlayerPatch<?> getPlayerPatch() {
            return this.playerPatch;
        }

        public ServerPlayerPatch getServerPlayerPatch() {
            if (!this.isClientSide()) {
                return (ServerPlayerPatch)this.getPlayerPatch();
            }
            return null;
        }

        public LocalPlayerPatch getLocalPlayerPatch() {
            if (this.isClientSide()) {
                return (LocalPlayerPatch)this.getPlayerPatch();
            }
            return null;
        }

        public Player getPlayer() {
            return this.player;
        }

        public ItemStack getMainItemStack() {
            return this.player.m_21205_();
        }

        public ItemStack getOffItemStack() {
            return this.player.m_21206_();
        }

        public boolean isClientSide() {
            return this.player.m_9236_().f_46443_;
        }

        public boolean isImplementedTagKey(ItemStack itemStack, String key) {
            return itemStack.m_204131_().anyMatch(itemTagKey -> itemTagKey.f_203868_().toString().equals(key));
        }

        public String getPassiveKey() {
            return this.passiveKey;
        }

        public TickEvent.PlayerTickEvent getForgeEvent() {
            return this.forgeEvent;
        }
    }

    public static class ActivationEvent
    extends Event {
        private final LZEpicFightSkillEvent precursorEvent;
        private final String passiveKey;

        public ActivationEvent(LZEpicFightSkillEvent precursorEvent, String passiveKey) {
            this.precursorEvent = precursorEvent;
            this.passiveKey = passiveKey;
        }

        public LZEpicFightSkillEvent getPrecursorEvent() {
            return this.precursorEvent;
        }

        public String getPassiveKey() {
            return this.passiveKey;
        }
    }

    public static class DeactivationEvent
    extends Event {
        private final LZEpicFightSkillEvent precursorEvent;
        private final String passiveKey;

        public DeactivationEvent(LZEpicFightSkillEvent precursorEvent, String passiveKey) {
            this.precursorEvent = precursorEvent;
            this.passiveKey = passiveKey;
        }

        public LZEpicFightSkillEvent getPrecursorEvent() {
            return this.precursorEvent;
        }

        public String getPassiveKey() {
            return this.passiveKey;
        }
    }

    public static class ContinuousEvent
    extends Event {
        private final LZEpicFightSkillEvent precursorEvent;
        private final String passiveKey;

        public ContinuousEvent(LZEpicFightSkillEvent precursorEvent, String passiveKey) {
            this.precursorEvent = precursorEvent;
            this.passiveKey = passiveKey;
        }

        public LZEpicFightSkillEvent getPrecursorEvent() {
            return this.precursorEvent;
        }

        public String getPassiveKey() {
            return this.passiveKey;
        }
    }
}

