/*
 * Decompiled with CFR 0.152.
 */
package sleys.lazyutilities.modules.elements.utilities.math;

import javax.annotation.Nullable;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class TextParticleMath {
    public static Vec3 getRandomEdgePosition(LivingEntity entity) {
        float width = entity.m_20205_() / 2.0f;
        float height = entity.m_20206_() * 1.5f;
        RandomSource random = entity.m_217043_();
        double offsetX = (float)(random.m_188499_() ? 1 : -1) * (width + random.m_188501_() * 0.2f);
        double offsetY = random.m_188501_() * height;
        double offsetZ = (float)(random.m_188499_() ? 1 : -1) * (width + random.m_188501_() * 0.2f);
        if (random.m_188499_()) {
            offsetX = 0.0;
        } else {
            offsetZ = 0.0;
        }
        return new Vec3(entity.m_20185_() + offsetX, entity.m_20186_() + offsetY, entity.m_20189_() + offsetZ);
    }

    public static Vec3 getSmartEdgePosition(LivingEntity target, @Nullable Entity player) {
        double offsetZ;
        double offsetX;
        AABB bounds = target.m_20191_();
        RandomSource random = target.m_217043_();
        double centerX = (bounds.f_82288_ + bounds.f_82291_) / 2.0;
        double centerY = (bounds.f_82289_ + bounds.f_82292_) / 2.0;
        double centerZ = (bounds.f_82290_ + bounds.f_82293_) / 2.0;
        double widthX = bounds.f_82291_ - bounds.f_82288_;
        double widthZ = bounds.f_82293_ - bounds.f_82290_;
        double height = bounds.f_82292_ - bounds.f_82289_;
        double maxVerticalOffset = height * 0.4;
        double offsetY = centerY + (random.m_188500_() * 2.0 - 1.0) * maxVerticalOffset;
        if (player != null) {
            Vec3 playerPos = player.m_20182_();
            Vec3 targetPos = target.m_20182_();
            double dx = playerPos.f_82479_ - targetPos.f_82479_;
            double dz = playerPos.f_82481_ - targetPos.f_82481_;
            double length = Math.sqrt(dx * dx + dz * dz);
            if (length > 0.0) {
                dx /= length;
                dz /= length;
            }
            double edgeX = dx * (widthX / 2.0);
            double edgeZ = dz * (widthZ / 2.0);
            double margin = 0.1 + random.m_188500_() * 0.2;
            offsetX = edgeX + (random.m_188500_() * 2.0 - 1.0) * margin;
            offsetZ = edgeZ + (random.m_188500_() * 2.0 - 1.0) * margin;
        } else {
            double angle = random.m_188500_() * Math.PI * 2.0;
            double radiusX = widthX / 2.0;
            double radiusZ = widthZ / 2.0;
            offsetX = Math.cos(angle) * radiusX;
            offsetZ = Math.sin(angle) * radiusZ;
            double margin = 0.1 + random.m_188500_() * 0.2;
            offsetX += (random.m_188500_() * 2.0 - 1.0) * margin;
            offsetZ += (random.m_188500_() * 2.0 - 1.0) * margin;
        }
        return new Vec3(centerX + offsetX, offsetY, centerZ + offsetZ);
    }

    public static Vec3 getCylindricalEdgePosition(LivingEntity target, @Nullable Entity player, double baseRadiusMultiplier, double verticalSpread, double horizontalOffsetX, double horizontalOffsetZ) {
        double angle;
        AABB bounds = target.m_20191_();
        RandomSource random = target.m_217043_();
        double centerX = (bounds.f_82288_ + bounds.f_82291_) / 2.0;
        double centerY = (bounds.f_82289_ + bounds.f_82292_) / 2.0;
        double centerZ = (bounds.f_82290_ + bounds.f_82293_) / 2.0;
        double width = bounds.f_82291_ - bounds.f_82288_;
        double depth = bounds.f_82293_ - bounds.f_82290_;
        double height = bounds.f_82292_ - bounds.f_82289_;
        double radius = Math.sqrt(2.0) * Math.max(width, depth) / 2.0 * baseRadiusMultiplier;
        double offsetY = centerY + (random.m_188500_() * 2.0 - 1.0) * height * verticalSpread;
        if (player != null) {
            double dx = player.m_20185_() - centerX;
            double dz = player.m_20189_() - centerZ;
            angle = Math.atan2(dz, dx);
        } else {
            angle = random.m_188500_() * Math.PI * 2.0;
        }
        double randomRadius = radius + (random.m_188500_() - 0.5) * radius * 0.2;
        double baseOffsetX = Math.cos(angle) * randomRadius;
        double baseOffsetZ = Math.sin(angle) * randomRadius;
        double additionalX = (random.m_188500_() * 2.0 - 1.0) * horizontalOffsetX;
        double additionalZ = (random.m_188500_() * 2.0 - 1.0) * horizontalOffsetZ;
        return new Vec3(centerX + baseOffsetX + additionalX, offsetY, centerZ + baseOffsetZ + additionalZ);
    }

    public static Vec3 getRandomClusterPosition(LivingEntity entity, double radius, double verticalFactor) {
        double rz;
        double ry;
        AABB bounds = entity.m_20191_();
        RandomSource random = entity.m_217043_();
        double centerX = (bounds.f_82288_ + bounds.f_82291_) / 2.0;
        double centerY = (bounds.f_82289_ + bounds.f_82292_) / 2.0;
        double centerZ = (bounds.f_82290_ + bounds.f_82293_) / 2.0;
        double rx = (random.m_188500_() * 2.0 - 1.0) * radius;
        double length = Math.sqrt(rx * rx + (ry = (random.m_188500_() * 2.0 - 1.0) * radius * verticalFactor) * ry + (rz = (random.m_188500_() * 2.0 - 1.0) * radius) * rz);
        if (length > radius) {
            rx *= radius / length;
            ry *= radius / length;
            rz *= radius / length;
        }
        return new Vec3(centerX + rx, centerY + ry, centerZ + rz);
    }

    public static Vec3 getAdvancedCylindricalEdgePosition(LivingEntity target, @Nullable Entity player, double baseRadiusMultiplier, double horizontalSpread, double verticalSpread, RandomSource random) {
        Vec3 aperture = TextParticleMath.getAperturePoint(target, player, baseRadiusMultiplier);
        Vec3 finalPos = player != null ? TextParticleMath.applyMonitorSpread(aperture, player, horizontalSpread, verticalSpread, random) : TextParticleMath.getCylindricalEdgePosition(target, null, baseRadiusMultiplier, verticalSpread, horizontalSpread, horizontalSpread);
        return finalPos;
    }

    public static Vec3 getAperturePoint(LivingEntity target, @Nullable Entity player, double baseRadiusMultiplier) {
        double angle;
        AABB bounds = target.m_20191_();
        double centerX = (bounds.f_82288_ + bounds.f_82291_) / 2.0;
        double centerY = (bounds.f_82289_ + bounds.f_82292_) / 2.0;
        double centerZ = (bounds.f_82290_ + bounds.f_82293_) / 2.0;
        double width = bounds.f_82291_ - bounds.f_82288_;
        double depth = bounds.f_82293_ - bounds.f_82290_;
        double radius = Math.sqrt(2.0) * Math.max(width, depth) / 2.0 * baseRadiusMultiplier;
        if (player != null) {
            double dx = player.m_20185_() - centerX;
            double dz = player.m_20189_() - centerZ;
            angle = Math.atan2(dz, dx);
        } else {
            angle = target.m_217043_().m_188500_() * Math.PI * 2.0;
        }
        double x = centerX + Math.cos(angle) * radius;
        double y = centerY;
        double z = centerZ + Math.sin(angle) * radius;
        return new Vec3(x, y, z);
    }

    public static Vec3 applyMonitorSpread(Vec3 aperturePoint, Entity player, double horizontalSpread, double verticalSpread, RandomSource random) {
        Vec3 forward = new Vec3(player.m_20185_() - aperturePoint.f_82479_, 0.0, player.m_20189_() - aperturePoint.f_82481_).m_82541_();
        Vec3 up = new Vec3(0.0, 1.0, 0.0);
        Vec3 right = forward.m_82537_(up).m_82541_();
        double offsetX = (random.m_188500_() * 2.0 - 1.0) * horizontalSpread;
        double offsetY = (random.m_188500_() * 2.0 - 1.0) * verticalSpread;
        Vec3 offset = right.m_82490_(offsetX).m_82549_(up.m_82490_(offsetY));
        return aperturePoint.m_82549_(offset);
    }
}

